/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class IssuingVelocityLimit {

    /**
     * The maximum amount in cents that can be spent in a given interval.
     */
    @JsonProperty("amount")
    private long amount;

    /**
     * Specifies the time frame for the velocity limit. Currently supports only per-transaction limits.
     */
    @JsonProperty("interval")
    private IssuingIntervalLimit interval;

    @JsonCreator
    public IssuingVelocityLimit(
            @JsonProperty("amount") long amount,
            @JsonProperty("interval") IssuingIntervalLimit interval) {
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(interval, "interval");
        this.amount = amount;
        this.interval = interval;
    }

    /**
     * The maximum amount in cents that can be spent in a given interval.
     */
    @JsonIgnore
    public long amount() {
        return amount;
    }

    /**
     * Specifies the time frame for the velocity limit. Currently supports only per-transaction limits.
     */
    @JsonIgnore
    public IssuingIntervalLimit interval() {
        return interval;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The maximum amount in cents that can be spent in a given interval.
     */
    public IssuingVelocityLimit withAmount(long amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    /**
     * Specifies the time frame for the velocity limit. Currently supports only per-transaction limits.
     */
    public IssuingVelocityLimit withInterval(IssuingIntervalLimit interval) {
        Utils.checkNotNull(interval, "interval");
        this.interval = interval;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IssuingVelocityLimit other = (IssuingVelocityLimit) o;
        return 
            Objects.deepEquals(this.amount, other.amount) &&
            Objects.deepEquals(this.interval, other.interval);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            amount,
            interval);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IssuingVelocityLimit.class,
                "amount", amount,
                "interval", interval);
    }
    
    public final static class Builder {
 
        private Long amount;
 
        private IssuingIntervalLimit interval;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The maximum amount in cents that can be spent in a given interval.
         */
        public Builder amount(long amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        /**
         * Specifies the time frame for the velocity limit. Currently supports only per-transaction limits.
         */
        public Builder interval(IssuingIntervalLimit interval) {
            Utils.checkNotNull(interval, "interval");
            this.interval = interval;
            return this;
        }
        
        public IssuingVelocityLimit build() {
            return new IssuingVelocityLimit(
                amount,
                interval);
        }
    }
}
