/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IssuingControls {

    /**
     * Indicates if the card is single-use. If true, the card closes after the first authorization.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("singleUse")
    private Optional<Boolean> singleUse;

    /**
     * Sets the spending limit per time interval. Only one limit per interval is supported.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("velocityLimits")
    private Optional<? extends List<IssuingVelocityLimit>> velocityLimits;

    @JsonCreator
    public IssuingControls(
            @JsonProperty("singleUse") Optional<Boolean> singleUse,
            @JsonProperty("velocityLimits") Optional<? extends List<IssuingVelocityLimit>> velocityLimits) {
        Utils.checkNotNull(singleUse, "singleUse");
        Utils.checkNotNull(velocityLimits, "velocityLimits");
        this.singleUse = singleUse;
        this.velocityLimits = velocityLimits;
    }
    
    public IssuingControls() {
        this(Optional.empty(), Optional.empty());
    }

    /**
     * Indicates if the card is single-use. If true, the card closes after the first authorization.
     */
    @JsonIgnore
    public Optional<Boolean> singleUse() {
        return singleUse;
    }

    /**
     * Sets the spending limit per time interval. Only one limit per interval is supported.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<IssuingVelocityLimit>> velocityLimits() {
        return (Optional<List<IssuingVelocityLimit>>) velocityLimits;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Indicates if the card is single-use. If true, the card closes after the first authorization.
     */
    public IssuingControls withSingleUse(boolean singleUse) {
        Utils.checkNotNull(singleUse, "singleUse");
        this.singleUse = Optional.ofNullable(singleUse);
        return this;
    }

    /**
     * Indicates if the card is single-use. If true, the card closes after the first authorization.
     */
    public IssuingControls withSingleUse(Optional<Boolean> singleUse) {
        Utils.checkNotNull(singleUse, "singleUse");
        this.singleUse = singleUse;
        return this;
    }

    /**
     * Sets the spending limit per time interval. Only one limit per interval is supported.
     */
    public IssuingControls withVelocityLimits(List<IssuingVelocityLimit> velocityLimits) {
        Utils.checkNotNull(velocityLimits, "velocityLimits");
        this.velocityLimits = Optional.ofNullable(velocityLimits);
        return this;
    }

    /**
     * Sets the spending limit per time interval. Only one limit per interval is supported.
     */
    public IssuingControls withVelocityLimits(Optional<? extends List<IssuingVelocityLimit>> velocityLimits) {
        Utils.checkNotNull(velocityLimits, "velocityLimits");
        this.velocityLimits = velocityLimits;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IssuingControls other = (IssuingControls) o;
        return 
            Objects.deepEquals(this.singleUse, other.singleUse) &&
            Objects.deepEquals(this.velocityLimits, other.velocityLimits);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            singleUse,
            velocityLimits);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IssuingControls.class,
                "singleUse", singleUse,
                "velocityLimits", velocityLimits);
    }
    
    public final static class Builder {
 
        private Optional<Boolean> singleUse = Optional.empty();
 
        private Optional<? extends List<IssuingVelocityLimit>> velocityLimits = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Indicates if the card is single-use. If true, the card closes after the first authorization.
         */
        public Builder singleUse(boolean singleUse) {
            Utils.checkNotNull(singleUse, "singleUse");
            this.singleUse = Optional.ofNullable(singleUse);
            return this;
        }

        /**
         * Indicates if the card is single-use. If true, the card closes after the first authorization.
         */
        public Builder singleUse(Optional<Boolean> singleUse) {
            Utils.checkNotNull(singleUse, "singleUse");
            this.singleUse = singleUse;
            return this;
        }

        /**
         * Sets the spending limit per time interval. Only one limit per interval is supported.
         */
        public Builder velocityLimits(List<IssuingVelocityLimit> velocityLimits) {
            Utils.checkNotNull(velocityLimits, "velocityLimits");
            this.velocityLimits = Optional.ofNullable(velocityLimits);
            return this;
        }

        /**
         * Sets the spending limit per time interval. Only one limit per interval is supported.
         */
        public Builder velocityLimits(Optional<? extends List<IssuingVelocityLimit>> velocityLimits) {
            Utils.checkNotNull(velocityLimits, "velocityLimits");
            this.velocityLimits = velocityLimits;
            return this;
        }
        
        public IssuingControls build() {
            return new IssuingControls(
                singleUse,
                velocityLimits);
        }
    }
}
