/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

public class IssuedCardTransaction {

    @JsonProperty("cardTransactionID")
    private String cardTransactionID;

    @JsonProperty("issuedCardID")
    private String issuedCardID;

    @JsonProperty("fundingWalletID")
    private String fundingWalletID;

    /**
     * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
     */
    @JsonProperty("amount")
    private String amount;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("authorizationID")
    private Optional<String> authorizationID;

    @JsonProperty("authorizedOn")
    private OffsetDateTime authorizedOn;

    @JsonProperty("merchantData")
    private IssuingMerchantData merchantData;

    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonCreator
    public IssuedCardTransaction(
            @JsonProperty("cardTransactionID") String cardTransactionID,
            @JsonProperty("issuedCardID") String issuedCardID,
            @JsonProperty("fundingWalletID") String fundingWalletID,
            @JsonProperty("amount") String amount,
            @JsonProperty("authorizationID") Optional<String> authorizationID,
            @JsonProperty("authorizedOn") OffsetDateTime authorizedOn,
            @JsonProperty("merchantData") IssuingMerchantData merchantData,
            @JsonProperty("createdOn") OffsetDateTime createdOn) {
        Utils.checkNotNull(cardTransactionID, "cardTransactionID");
        Utils.checkNotNull(issuedCardID, "issuedCardID");
        Utils.checkNotNull(fundingWalletID, "fundingWalletID");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(authorizationID, "authorizationID");
        Utils.checkNotNull(authorizedOn, "authorizedOn");
        Utils.checkNotNull(merchantData, "merchantData");
        Utils.checkNotNull(createdOn, "createdOn");
        this.cardTransactionID = cardTransactionID;
        this.issuedCardID = issuedCardID;
        this.fundingWalletID = fundingWalletID;
        this.amount = amount;
        this.authorizationID = authorizationID;
        this.authorizedOn = authorizedOn;
        this.merchantData = merchantData;
        this.createdOn = createdOn;
    }
    
    public IssuedCardTransaction(
            String cardTransactionID,
            String issuedCardID,
            String fundingWalletID,
            String amount,
            OffsetDateTime authorizedOn,
            IssuingMerchantData merchantData,
            OffsetDateTime createdOn) {
        this(cardTransactionID, issuedCardID, fundingWalletID, amount, Optional.empty(), authorizedOn, merchantData, createdOn);
    }

    @JsonIgnore
    public String cardTransactionID() {
        return cardTransactionID;
    }

    @JsonIgnore
    public String issuedCardID() {
        return issuedCardID;
    }

    @JsonIgnore
    public String fundingWalletID() {
        return fundingWalletID;
    }

    /**
     * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
     */
    @JsonIgnore
    public String amount() {
        return amount;
    }

    @JsonIgnore
    public Optional<String> authorizationID() {
        return authorizationID;
    }

    @JsonIgnore
    public OffsetDateTime authorizedOn() {
        return authorizedOn;
    }

    @JsonIgnore
    public IssuingMerchantData merchantData() {
        return merchantData;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public IssuedCardTransaction withCardTransactionID(String cardTransactionID) {
        Utils.checkNotNull(cardTransactionID, "cardTransactionID");
        this.cardTransactionID = cardTransactionID;
        return this;
    }

    public IssuedCardTransaction withIssuedCardID(String issuedCardID) {
        Utils.checkNotNull(issuedCardID, "issuedCardID");
        this.issuedCardID = issuedCardID;
        return this;
    }

    public IssuedCardTransaction withFundingWalletID(String fundingWalletID) {
        Utils.checkNotNull(fundingWalletID, "fundingWalletID");
        this.fundingWalletID = fundingWalletID;
        return this;
    }

    /**
     * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
     */
    public IssuedCardTransaction withAmount(String amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public IssuedCardTransaction withAuthorizationID(String authorizationID) {
        Utils.checkNotNull(authorizationID, "authorizationID");
        this.authorizationID = Optional.ofNullable(authorizationID);
        return this;
    }

    public IssuedCardTransaction withAuthorizationID(Optional<String> authorizationID) {
        Utils.checkNotNull(authorizationID, "authorizationID");
        this.authorizationID = authorizationID;
        return this;
    }

    public IssuedCardTransaction withAuthorizedOn(OffsetDateTime authorizedOn) {
        Utils.checkNotNull(authorizedOn, "authorizedOn");
        this.authorizedOn = authorizedOn;
        return this;
    }

    public IssuedCardTransaction withMerchantData(IssuingMerchantData merchantData) {
        Utils.checkNotNull(merchantData, "merchantData");
        this.merchantData = merchantData;
        return this;
    }

    public IssuedCardTransaction withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IssuedCardTransaction other = (IssuedCardTransaction) o;
        return 
            Objects.deepEquals(this.cardTransactionID, other.cardTransactionID) &&
            Objects.deepEquals(this.issuedCardID, other.issuedCardID) &&
            Objects.deepEquals(this.fundingWalletID, other.fundingWalletID) &&
            Objects.deepEquals(this.amount, other.amount) &&
            Objects.deepEquals(this.authorizationID, other.authorizationID) &&
            Objects.deepEquals(this.authorizedOn, other.authorizedOn) &&
            Objects.deepEquals(this.merchantData, other.merchantData) &&
            Objects.deepEquals(this.createdOn, other.createdOn);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            cardTransactionID,
            issuedCardID,
            fundingWalletID,
            amount,
            authorizationID,
            authorizedOn,
            merchantData,
            createdOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IssuedCardTransaction.class,
                "cardTransactionID", cardTransactionID,
                "issuedCardID", issuedCardID,
                "fundingWalletID", fundingWalletID,
                "amount", amount,
                "authorizationID", authorizationID,
                "authorizedOn", authorizedOn,
                "merchantData", merchantData,
                "createdOn", createdOn);
    }
    
    public final static class Builder {
 
        private String cardTransactionID;
 
        private String issuedCardID;
 
        private String fundingWalletID;
 
        private String amount;
 
        private Optional<String> authorizationID = Optional.empty();
 
        private OffsetDateTime authorizedOn;
 
        private IssuingMerchantData merchantData;
 
        private OffsetDateTime createdOn;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder cardTransactionID(String cardTransactionID) {
            Utils.checkNotNull(cardTransactionID, "cardTransactionID");
            this.cardTransactionID = cardTransactionID;
            return this;
        }

        public Builder issuedCardID(String issuedCardID) {
            Utils.checkNotNull(issuedCardID, "issuedCardID");
            this.issuedCardID = issuedCardID;
            return this;
        }

        public Builder fundingWalletID(String fundingWalletID) {
            Utils.checkNotNull(fundingWalletID, "fundingWalletID");
            this.fundingWalletID = fundingWalletID;
            return this;
        }

        /**
         * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
         */
        public Builder amount(String amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public Builder authorizationID(String authorizationID) {
            Utils.checkNotNull(authorizationID, "authorizationID");
            this.authorizationID = Optional.ofNullable(authorizationID);
            return this;
        }

        public Builder authorizationID(Optional<String> authorizationID) {
            Utils.checkNotNull(authorizationID, "authorizationID");
            this.authorizationID = authorizationID;
            return this;
        }

        public Builder authorizedOn(OffsetDateTime authorizedOn) {
            Utils.checkNotNull(authorizedOn, "authorizedOn");
            this.authorizedOn = authorizedOn;
            return this;
        }

        public Builder merchantData(IssuingMerchantData merchantData) {
            Utils.checkNotNull(merchantData, "merchantData");
            this.merchantData = merchantData;
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }
        
        public IssuedCardTransaction build() {
            return new IssuedCardTransaction(
                cardTransactionID,
                issuedCardID,
                fundingWalletID,
                amount,
                authorizationID,
                authorizedOn,
                merchantData,
                createdOn);
        }
    }
}
