/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class IssuedCardAuthorizationEvent {

    /**
     * The identifier for this event. Use the `eventType` field to determine what resource is identified by this ID (`authorization`, `reversal`, etc.).
     */
    @JsonProperty("eventID")
    private String eventID;

    /**
     * The type of event that occurred on the card.
     */
    @JsonProperty("eventType")
    private IssuedCardEventType eventType;

    /**
     * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
     */
    @JsonProperty("amount")
    private String amount;

    /**
     * The result of an event.
     */
    @JsonProperty("result")
    private IssuedCardAuthorizationEventResult result;

    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonCreator
    public IssuedCardAuthorizationEvent(
            @JsonProperty("eventID") String eventID,
            @JsonProperty("eventType") IssuedCardEventType eventType,
            @JsonProperty("amount") String amount,
            @JsonProperty("result") IssuedCardAuthorizationEventResult result,
            @JsonProperty("createdOn") OffsetDateTime createdOn) {
        Utils.checkNotNull(eventID, "eventID");
        Utils.checkNotNull(eventType, "eventType");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(result, "result");
        Utils.checkNotNull(createdOn, "createdOn");
        this.eventID = eventID;
        this.eventType = eventType;
        this.amount = amount;
        this.result = result;
        this.createdOn = createdOn;
    }

    /**
     * The identifier for this event. Use the `eventType` field to determine what resource is identified by this ID (`authorization`, `reversal`, etc.).
     */
    @JsonIgnore
    public String eventID() {
        return eventID;
    }

    /**
     * The type of event that occurred on the card.
     */
    @JsonIgnore
    public IssuedCardEventType eventType() {
        return eventType;
    }

    /**
     * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
     */
    @JsonIgnore
    public String amount() {
        return amount;
    }

    /**
     * The result of an event.
     */
    @JsonIgnore
    public IssuedCardAuthorizationEventResult result() {
        return result;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The identifier for this event. Use the `eventType` field to determine what resource is identified by this ID (`authorization`, `reversal`, etc.).
     */
    public IssuedCardAuthorizationEvent withEventID(String eventID) {
        Utils.checkNotNull(eventID, "eventID");
        this.eventID = eventID;
        return this;
    }

    /**
     * The type of event that occurred on the card.
     */
    public IssuedCardAuthorizationEvent withEventType(IssuedCardEventType eventType) {
        Utils.checkNotNull(eventType, "eventType");
        this.eventType = eventType;
        return this;
    }

    /**
     * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
     */
    public IssuedCardAuthorizationEvent withAmount(String amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    /**
     * The result of an event.
     */
    public IssuedCardAuthorizationEvent withResult(IssuedCardAuthorizationEventResult result) {
        Utils.checkNotNull(result, "result");
        this.result = result;
        return this;
    }

    public IssuedCardAuthorizationEvent withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IssuedCardAuthorizationEvent other = (IssuedCardAuthorizationEvent) o;
        return 
            Objects.deepEquals(this.eventID, other.eventID) &&
            Objects.deepEquals(this.eventType, other.eventType) &&
            Objects.deepEquals(this.amount, other.amount) &&
            Objects.deepEquals(this.result, other.result) &&
            Objects.deepEquals(this.createdOn, other.createdOn);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            eventID,
            eventType,
            amount,
            result,
            createdOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IssuedCardAuthorizationEvent.class,
                "eventID", eventID,
                "eventType", eventType,
                "amount", amount,
                "result", result,
                "createdOn", createdOn);
    }
    
    public final static class Builder {
 
        private String eventID;
 
        private IssuedCardEventType eventType;
 
        private String amount;
 
        private IssuedCardAuthorizationEventResult result;
 
        private OffsetDateTime createdOn;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The identifier for this event. Use the `eventType` field to determine what resource is identified by this ID (`authorization`, `reversal`, etc.).
         */
        public Builder eventID(String eventID) {
            Utils.checkNotNull(eventID, "eventID");
            this.eventID = eventID;
            return this;
        }

        /**
         * The type of event that occurred on the card.
         */
        public Builder eventType(IssuedCardEventType eventType) {
            Utils.checkNotNull(eventType, "eventType");
            this.eventType = eventType;
            return this;
        }

        /**
         * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
         */
        public Builder amount(String amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        /**
         * The result of an event.
         */
        public Builder result(IssuedCardAuthorizationEventResult result) {
            Utils.checkNotNull(result, "result");
            this.result = result;
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }
        
        public IssuedCardAuthorizationEvent build() {
            return new IssuedCardAuthorizationEvent(
                eventID,
                eventType,
                amount,
                result,
                createdOn);
        }
    }
}
