/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

/**
 * IndividualProfile
 * 
 * <p>Describes an individual.
 */
public class IndividualProfile {

    @JsonProperty("name")
    private IndividualName name;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone")
    private Optional<? extends PhoneNumber> phone;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private Optional<String> email;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("address")
    private Optional<? extends Address> address;

    /**
     * Indicates whether this individual's birth date has been provided.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("birthDateProvided")
    private Optional<Boolean> birthDateProvided;

    /**
     * Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this individual.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("governmentIDProvided")
    private Optional<Boolean> governmentIDProvided;

    @JsonCreator
    public IndividualProfile(
            @JsonProperty("name") IndividualName name,
            @JsonProperty("phone") Optional<? extends PhoneNumber> phone,
            @JsonProperty("email") Optional<String> email,
            @JsonProperty("address") Optional<? extends Address> address,
            @JsonProperty("birthDateProvided") Optional<Boolean> birthDateProvided,
            @JsonProperty("governmentIDProvided") Optional<Boolean> governmentIDProvided) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(phone, "phone");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(address, "address");
        Utils.checkNotNull(birthDateProvided, "birthDateProvided");
        Utils.checkNotNull(governmentIDProvided, "governmentIDProvided");
        this.name = name;
        this.phone = phone;
        this.email = email;
        this.address = address;
        this.birthDateProvided = birthDateProvided;
        this.governmentIDProvided = governmentIDProvided;
    }
    
    public IndividualProfile(
            IndividualName name) {
        this(name, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public IndividualName name() {
        return name;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PhoneNumber> phone() {
        return (Optional<PhoneNumber>) phone;
    }

    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Address> address() {
        return (Optional<Address>) address;
    }

    /**
     * Indicates whether this individual's birth date has been provided.
     */
    @JsonIgnore
    public Optional<Boolean> birthDateProvided() {
        return birthDateProvided;
    }

    /**
     * Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this individual.
     */
    @JsonIgnore
    public Optional<Boolean> governmentIDProvided() {
        return governmentIDProvided;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public IndividualProfile withName(IndividualName name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public IndividualProfile withPhone(PhoneNumber phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = Optional.ofNullable(phone);
        return this;
    }

    public IndividualProfile withPhone(Optional<? extends PhoneNumber> phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = phone;
        return this;
    }

    public IndividualProfile withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }

    public IndividualProfile withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public IndividualProfile withAddress(Address address) {
        Utils.checkNotNull(address, "address");
        this.address = Optional.ofNullable(address);
        return this;
    }

    public IndividualProfile withAddress(Optional<? extends Address> address) {
        Utils.checkNotNull(address, "address");
        this.address = address;
        return this;
    }

    /**
     * Indicates whether this individual's birth date has been provided.
     */
    public IndividualProfile withBirthDateProvided(boolean birthDateProvided) {
        Utils.checkNotNull(birthDateProvided, "birthDateProvided");
        this.birthDateProvided = Optional.ofNullable(birthDateProvided);
        return this;
    }

    /**
     * Indicates whether this individual's birth date has been provided.
     */
    public IndividualProfile withBirthDateProvided(Optional<Boolean> birthDateProvided) {
        Utils.checkNotNull(birthDateProvided, "birthDateProvided");
        this.birthDateProvided = birthDateProvided;
        return this;
    }

    /**
     * Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this individual.
     */
    public IndividualProfile withGovernmentIDProvided(boolean governmentIDProvided) {
        Utils.checkNotNull(governmentIDProvided, "governmentIDProvided");
        this.governmentIDProvided = Optional.ofNullable(governmentIDProvided);
        return this;
    }

    /**
     * Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this individual.
     */
    public IndividualProfile withGovernmentIDProvided(Optional<Boolean> governmentIDProvided) {
        Utils.checkNotNull(governmentIDProvided, "governmentIDProvided");
        this.governmentIDProvided = governmentIDProvided;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IndividualProfile other = (IndividualProfile) o;
        return 
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.phone, other.phone) &&
            Objects.deepEquals(this.email, other.email) &&
            Objects.deepEquals(this.address, other.address) &&
            Objects.deepEquals(this.birthDateProvided, other.birthDateProvided) &&
            Objects.deepEquals(this.governmentIDProvided, other.governmentIDProvided);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            name,
            phone,
            email,
            address,
            birthDateProvided,
            governmentIDProvided);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IndividualProfile.class,
                "name", name,
                "phone", phone,
                "email", email,
                "address", address,
                "birthDateProvided", birthDateProvided,
                "governmentIDProvided", governmentIDProvided);
    }
    
    public final static class Builder {
 
        private IndividualName name;
 
        private Optional<? extends PhoneNumber> phone = Optional.empty();
 
        private Optional<String> email = Optional.empty();
 
        private Optional<? extends Address> address = Optional.empty();
 
        private Optional<Boolean> birthDateProvided = Optional.empty();
 
        private Optional<Boolean> governmentIDProvided = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder name(IndividualName name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder phone(PhoneNumber phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        public Builder phone(Optional<? extends PhoneNumber> phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = phone;
            return this;
        }

        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public Builder address(Address address) {
            Utils.checkNotNull(address, "address");
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Optional<? extends Address> address) {
            Utils.checkNotNull(address, "address");
            this.address = address;
            return this;
        }

        /**
         * Indicates whether this individual's birth date has been provided.
         */
        public Builder birthDateProvided(boolean birthDateProvided) {
            Utils.checkNotNull(birthDateProvided, "birthDateProvided");
            this.birthDateProvided = Optional.ofNullable(birthDateProvided);
            return this;
        }

        /**
         * Indicates whether this individual's birth date has been provided.
         */
        public Builder birthDateProvided(Optional<Boolean> birthDateProvided) {
            Utils.checkNotNull(birthDateProvided, "birthDateProvided");
            this.birthDateProvided = birthDateProvided;
            return this;
        }

        /**
         * Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this individual.
         */
        public Builder governmentIDProvided(boolean governmentIDProvided) {
            Utils.checkNotNull(governmentIDProvided, "governmentIDProvided");
            this.governmentIDProvided = Optional.ofNullable(governmentIDProvided);
            return this;
        }

        /**
         * Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this individual.
         */
        public Builder governmentIDProvided(Optional<Boolean> governmentIDProvided) {
            Utils.checkNotNull(governmentIDProvided, "governmentIDProvided");
            this.governmentIDProvided = governmentIDProvided;
            return this;
        }
        
        public IndividualProfile build() {
            return new IndividualProfile(
                name,
                phone,
                email,
                address,
                birthDateProvided,
                governmentIDProvided);
        }
    }
}
