/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class FulfillmentDetails {

    @JsonProperty("hasPhysicalGoods")
    private boolean hasPhysicalGoods;

    @JsonProperty("isShippingProduct")
    private boolean isShippingProduct;

    @JsonProperty("shipmentDurationDays")
    private long shipmentDurationDays;

    @JsonProperty("returnPolicy")
    private ReturnPolicyType returnPolicy;

    @JsonCreator
    public FulfillmentDetails(
            @JsonProperty("hasPhysicalGoods") boolean hasPhysicalGoods,
            @JsonProperty("isShippingProduct") boolean isShippingProduct,
            @JsonProperty("shipmentDurationDays") long shipmentDurationDays,
            @JsonProperty("returnPolicy") ReturnPolicyType returnPolicy) {
        Utils.checkNotNull(hasPhysicalGoods, "hasPhysicalGoods");
        Utils.checkNotNull(isShippingProduct, "isShippingProduct");
        Utils.checkNotNull(shipmentDurationDays, "shipmentDurationDays");
        Utils.checkNotNull(returnPolicy, "returnPolicy");
        this.hasPhysicalGoods = hasPhysicalGoods;
        this.isShippingProduct = isShippingProduct;
        this.shipmentDurationDays = shipmentDurationDays;
        this.returnPolicy = returnPolicy;
    }

    @JsonIgnore
    public boolean hasPhysicalGoods() {
        return hasPhysicalGoods;
    }

    @JsonIgnore
    public boolean isShippingProduct() {
        return isShippingProduct;
    }

    @JsonIgnore
    public long shipmentDurationDays() {
        return shipmentDurationDays;
    }

    @JsonIgnore
    public ReturnPolicyType returnPolicy() {
        return returnPolicy;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public FulfillmentDetails withHasPhysicalGoods(boolean hasPhysicalGoods) {
        Utils.checkNotNull(hasPhysicalGoods, "hasPhysicalGoods");
        this.hasPhysicalGoods = hasPhysicalGoods;
        return this;
    }

    public FulfillmentDetails withIsShippingProduct(boolean isShippingProduct) {
        Utils.checkNotNull(isShippingProduct, "isShippingProduct");
        this.isShippingProduct = isShippingProduct;
        return this;
    }

    public FulfillmentDetails withShipmentDurationDays(long shipmentDurationDays) {
        Utils.checkNotNull(shipmentDurationDays, "shipmentDurationDays");
        this.shipmentDurationDays = shipmentDurationDays;
        return this;
    }

    public FulfillmentDetails withReturnPolicy(ReturnPolicyType returnPolicy) {
        Utils.checkNotNull(returnPolicy, "returnPolicy");
        this.returnPolicy = returnPolicy;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FulfillmentDetails other = (FulfillmentDetails) o;
        return 
            Objects.deepEquals(this.hasPhysicalGoods, other.hasPhysicalGoods) &&
            Objects.deepEquals(this.isShippingProduct, other.isShippingProduct) &&
            Objects.deepEquals(this.shipmentDurationDays, other.shipmentDurationDays) &&
            Objects.deepEquals(this.returnPolicy, other.returnPolicy);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            hasPhysicalGoods,
            isShippingProduct,
            shipmentDurationDays,
            returnPolicy);
    }
    
    @Override
    public String toString() {
        return Utils.toString(FulfillmentDetails.class,
                "hasPhysicalGoods", hasPhysicalGoods,
                "isShippingProduct", isShippingProduct,
                "shipmentDurationDays", shipmentDurationDays,
                "returnPolicy", returnPolicy);
    }
    
    public final static class Builder {
 
        private Boolean hasPhysicalGoods;
 
        private Boolean isShippingProduct;
 
        private Long shipmentDurationDays;
 
        private ReturnPolicyType returnPolicy;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder hasPhysicalGoods(boolean hasPhysicalGoods) {
            Utils.checkNotNull(hasPhysicalGoods, "hasPhysicalGoods");
            this.hasPhysicalGoods = hasPhysicalGoods;
            return this;
        }

        public Builder isShippingProduct(boolean isShippingProduct) {
            Utils.checkNotNull(isShippingProduct, "isShippingProduct");
            this.isShippingProduct = isShippingProduct;
            return this;
        }

        public Builder shipmentDurationDays(long shipmentDurationDays) {
            Utils.checkNotNull(shipmentDurationDays, "shipmentDurationDays");
            this.shipmentDurationDays = shipmentDurationDays;
            return this;
        }

        public Builder returnPolicy(ReturnPolicyType returnPolicy) {
            Utils.checkNotNull(returnPolicy, "returnPolicy");
            this.returnPolicy = returnPolicy;
            return this;
        }
        
        public FulfillmentDetails build() {
            return new FulfillmentDetails(
                hasPhysicalGoods,
                isShippingProduct,
                shipmentDurationDays,
                returnPolicy);
        }
    }
}
