/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class EnrichedBusinessResponse {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("business")
    private Optional<? extends EnrichedBusinessProfile> business;

    @JsonCreator
    public EnrichedBusinessResponse(
            @JsonProperty("business") Optional<? extends EnrichedBusinessProfile> business) {
        Utils.checkNotNull(business, "business");
        this.business = business;
    }
    
    public EnrichedBusinessResponse() {
        this(Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<EnrichedBusinessProfile> business() {
        return (Optional<EnrichedBusinessProfile>) business;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public EnrichedBusinessResponse withBusiness(EnrichedBusinessProfile business) {
        Utils.checkNotNull(business, "business");
        this.business = Optional.ofNullable(business);
        return this;
    }

    public EnrichedBusinessResponse withBusiness(Optional<? extends EnrichedBusinessProfile> business) {
        Utils.checkNotNull(business, "business");
        this.business = business;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnrichedBusinessResponse other = (EnrichedBusinessResponse) o;
        return 
            Objects.deepEquals(this.business, other.business);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            business);
    }
    
    @Override
    public String toString() {
        return Utils.toString(EnrichedBusinessResponse.class,
                "business", business);
    }
    
    public final static class Builder {
 
        private Optional<? extends EnrichedBusinessProfile> business = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder business(EnrichedBusinessProfile business) {
            Utils.checkNotNull(business, "business");
            this.business = Optional.ofNullable(business);
            return this;
        }

        public Builder business(Optional<? extends EnrichedBusinessProfile> business) {
            Utils.checkNotNull(business, "business");
            this.business = business;
            return this;
        }
        
        public EnrichedBusinessResponse build() {
            return new EnrichedBusinessResponse(
                business);
        }
    }
}
