/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

/**
 * E2EETokenUpdate
 * 
 * <p>Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
 * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
 * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
 */
public class E2EETokenUpdate {

    /**
     * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("token")
    private Optional<String> token;

    @JsonCreator
    public E2EETokenUpdate(
            @JsonProperty("token") Optional<String> token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
    }
    
    public E2EETokenUpdate() {
        this(Optional.empty());
    }

    /**
     * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
     */
    @JsonIgnore
    public Optional<String> token() {
        return token;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
     */
    public E2EETokenUpdate withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = Optional.ofNullable(token);
        return this;
    }

    /**
     * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
     */
    public E2EETokenUpdate withToken(Optional<String> token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        E2EETokenUpdate other = (E2EETokenUpdate) o;
        return 
            Objects.deepEquals(this.token, other.token);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            token);
    }
    
    @Override
    public String toString() {
        return Utils.toString(E2EETokenUpdate.class,
                "token", token);
    }
    
    public final static class Builder {
 
        private Optional<String> token = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
         */
        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = Optional.ofNullable(token);
            return this;
        }

        /**
         * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
         */
        public Builder token(Optional<String> token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }
        
        public E2EETokenUpdate build() {
            return new E2EETokenUpdate(
                token);
        }
    }
}
