/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Document {

    @JsonProperty("documentID")
    private String documentID;

    /**
     * Types of documents that can be uploaded.
     */
    @JsonProperty("type")
    private DocumentType type;

    /**
     * The document's MIME type.
     */
    @JsonProperty("contentType")
    private String contentType;

    /**
     * Optional array of errors encountered during automated parsing.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parseErrors")
    private Optional<? extends List<String>> parseErrors;

    @JsonProperty("uploadedAt")
    private OffsetDateTime uploadedAt;

    @JsonCreator
    public Document(
            @JsonProperty("documentID") String documentID,
            @JsonProperty("type") DocumentType type,
            @JsonProperty("contentType") String contentType,
            @JsonProperty("parseErrors") Optional<? extends List<String>> parseErrors,
            @JsonProperty("uploadedAt") OffsetDateTime uploadedAt) {
        Utils.checkNotNull(documentID, "documentID");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(parseErrors, "parseErrors");
        Utils.checkNotNull(uploadedAt, "uploadedAt");
        this.documentID = documentID;
        this.type = type;
        this.contentType = contentType;
        this.parseErrors = parseErrors;
        this.uploadedAt = uploadedAt;
    }
    
    public Document(
            String documentID,
            DocumentType type,
            String contentType,
            OffsetDateTime uploadedAt) {
        this(documentID, type, contentType, Optional.empty(), uploadedAt);
    }

    @JsonIgnore
    public String documentID() {
        return documentID;
    }

    /**
     * Types of documents that can be uploaded.
     */
    @JsonIgnore
    public DocumentType type() {
        return type;
    }

    /**
     * The document's MIME type.
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * Optional array of errors encountered during automated parsing.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> parseErrors() {
        return (Optional<List<String>>) parseErrors;
    }

    @JsonIgnore
    public OffsetDateTime uploadedAt() {
        return uploadedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public Document withDocumentID(String documentID) {
        Utils.checkNotNull(documentID, "documentID");
        this.documentID = documentID;
        return this;
    }

    /**
     * Types of documents that can be uploaded.
     */
    public Document withType(DocumentType type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The document's MIME type.
     */
    public Document withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * Optional array of errors encountered during automated parsing.
     */
    public Document withParseErrors(List<String> parseErrors) {
        Utils.checkNotNull(parseErrors, "parseErrors");
        this.parseErrors = Optional.ofNullable(parseErrors);
        return this;
    }

    /**
     * Optional array of errors encountered during automated parsing.
     */
    public Document withParseErrors(Optional<? extends List<String>> parseErrors) {
        Utils.checkNotNull(parseErrors, "parseErrors");
        this.parseErrors = parseErrors;
        return this;
    }

    public Document withUploadedAt(OffsetDateTime uploadedAt) {
        Utils.checkNotNull(uploadedAt, "uploadedAt");
        this.uploadedAt = uploadedAt;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Document other = (Document) o;
        return 
            Objects.deepEquals(this.documentID, other.documentID) &&
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.contentType, other.contentType) &&
            Objects.deepEquals(this.parseErrors, other.parseErrors) &&
            Objects.deepEquals(this.uploadedAt, other.uploadedAt);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            documentID,
            type,
            contentType,
            parseErrors,
            uploadedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Document.class,
                "documentID", documentID,
                "type", type,
                "contentType", contentType,
                "parseErrors", parseErrors,
                "uploadedAt", uploadedAt);
    }
    
    public final static class Builder {
 
        private String documentID;
 
        private DocumentType type;
 
        private String contentType;
 
        private Optional<? extends List<String>> parseErrors = Optional.empty();
 
        private OffsetDateTime uploadedAt;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder documentID(String documentID) {
            Utils.checkNotNull(documentID, "documentID");
            this.documentID = documentID;
            return this;
        }

        /**
         * Types of documents that can be uploaded.
         */
        public Builder type(DocumentType type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        /**
         * The document's MIME type.
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * Optional array of errors encountered during automated parsing.
         */
        public Builder parseErrors(List<String> parseErrors) {
            Utils.checkNotNull(parseErrors, "parseErrors");
            this.parseErrors = Optional.ofNullable(parseErrors);
            return this;
        }

        /**
         * Optional array of errors encountered during automated parsing.
         */
        public Builder parseErrors(Optional<? extends List<String>> parseErrors) {
            Utils.checkNotNull(parseErrors, "parseErrors");
            this.parseErrors = parseErrors;
            return this;
        }

        public Builder uploadedAt(OffsetDateTime uploadedAt) {
            Utils.checkNotNull(uploadedAt, "uploadedAt");
            this.uploadedAt = uploadedAt;
            return this;
        }
        
        public Document build() {
            return new Document(
                documentID,
                type,
                contentType,
                parseErrors,
                uploadedAt);
        }
    }
}
