/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

/**
 * Dispute
 * 
 * <p>Details of a card transaction dispute.
 */
public class Dispute {

    @JsonProperty("disputeID")
    private String disputeID;

    @JsonProperty("merchantAccountID")
    private String merchantAccountID;

    @JsonProperty("amount")
    private Amount amount;

    /**
     * Indicates the card network's category for the dispute. 
     * 
     * <p>These codes may differ between card brands. You can find more information on the code from the networkReasonDescription field.
     */
    @JsonProperty("networkReasonCode")
    private String networkReasonCode;

    /**
     * Provides detail on the card network's categorization of the dispute.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("networkReasonDescription")
    private Optional<String> networkReasonDescription;

    @JsonProperty("transfer")
    private DisputeTransferDetails transfer;

    @JsonProperty("respondBy")
    private OffsetDateTime respondBy;

    /**
     * The status of a particular dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
     */
    @JsonProperty("status")
    private DisputeStatus status;

    /**
     * The phase of a dispute within the dispute lifecycle.
     */
    @JsonProperty("phase")
    private DisputePhase phase;

    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("submittedOn")
    private Optional<OffsetDateTime> submittedOn;

    @JsonCreator
    public Dispute(
            @JsonProperty("disputeID") String disputeID,
            @JsonProperty("merchantAccountID") String merchantAccountID,
            @JsonProperty("amount") Amount amount,
            @JsonProperty("networkReasonCode") String networkReasonCode,
            @JsonProperty("networkReasonDescription") Optional<String> networkReasonDescription,
            @JsonProperty("transfer") DisputeTransferDetails transfer,
            @JsonProperty("respondBy") OffsetDateTime respondBy,
            @JsonProperty("status") DisputeStatus status,
            @JsonProperty("phase") DisputePhase phase,
            @JsonProperty("createdOn") OffsetDateTime createdOn,
            @JsonProperty("submittedOn") Optional<OffsetDateTime> submittedOn) {
        Utils.checkNotNull(disputeID, "disputeID");
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(networkReasonCode, "networkReasonCode");
        Utils.checkNotNull(networkReasonDescription, "networkReasonDescription");
        Utils.checkNotNull(transfer, "transfer");
        Utils.checkNotNull(respondBy, "respondBy");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(phase, "phase");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(submittedOn, "submittedOn");
        this.disputeID = disputeID;
        this.merchantAccountID = merchantAccountID;
        this.amount = amount;
        this.networkReasonCode = networkReasonCode;
        this.networkReasonDescription = networkReasonDescription;
        this.transfer = transfer;
        this.respondBy = respondBy;
        this.status = status;
        this.phase = phase;
        this.createdOn = createdOn;
        this.submittedOn = submittedOn;
    }
    
    public Dispute(
            String disputeID,
            String merchantAccountID,
            Amount amount,
            String networkReasonCode,
            DisputeTransferDetails transfer,
            OffsetDateTime respondBy,
            DisputeStatus status,
            DisputePhase phase,
            OffsetDateTime createdOn) {
        this(disputeID, merchantAccountID, amount, networkReasonCode, Optional.empty(), transfer, respondBy, status, phase, createdOn, Optional.empty());
    }

    @JsonIgnore
    public String disputeID() {
        return disputeID;
    }

    @JsonIgnore
    public String merchantAccountID() {
        return merchantAccountID;
    }

    @JsonIgnore
    public Amount amount() {
        return amount;
    }

    /**
     * Indicates the card network's category for the dispute. 
     * 
     * <p>These codes may differ between card brands. You can find more information on the code from the networkReasonDescription field.
     */
    @JsonIgnore
    public String networkReasonCode() {
        return networkReasonCode;
    }

    /**
     * Provides detail on the card network's categorization of the dispute.
     */
    @JsonIgnore
    public Optional<String> networkReasonDescription() {
        return networkReasonDescription;
    }

    @JsonIgnore
    public DisputeTransferDetails transfer() {
        return transfer;
    }

    @JsonIgnore
    public OffsetDateTime respondBy() {
        return respondBy;
    }

    /**
     * The status of a particular dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
     */
    @JsonIgnore
    public DisputeStatus status() {
        return status;
    }

    /**
     * The phase of a dispute within the dispute lifecycle.
     */
    @JsonIgnore
    public DisputePhase phase() {
        return phase;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> submittedOn() {
        return submittedOn;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public Dispute withDisputeID(String disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = disputeID;
        return this;
    }

    public Dispute withMerchantAccountID(String merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = merchantAccountID;
        return this;
    }

    public Dispute withAmount(Amount amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    /**
     * Indicates the card network's category for the dispute. 
     * 
     * <p>These codes may differ between card brands. You can find more information on the code from the networkReasonDescription field.
     */
    public Dispute withNetworkReasonCode(String networkReasonCode) {
        Utils.checkNotNull(networkReasonCode, "networkReasonCode");
        this.networkReasonCode = networkReasonCode;
        return this;
    }

    /**
     * Provides detail on the card network's categorization of the dispute.
     */
    public Dispute withNetworkReasonDescription(String networkReasonDescription) {
        Utils.checkNotNull(networkReasonDescription, "networkReasonDescription");
        this.networkReasonDescription = Optional.ofNullable(networkReasonDescription);
        return this;
    }

    /**
     * Provides detail on the card network's categorization of the dispute.
     */
    public Dispute withNetworkReasonDescription(Optional<String> networkReasonDescription) {
        Utils.checkNotNull(networkReasonDescription, "networkReasonDescription");
        this.networkReasonDescription = networkReasonDescription;
        return this;
    }

    public Dispute withTransfer(DisputeTransferDetails transfer) {
        Utils.checkNotNull(transfer, "transfer");
        this.transfer = transfer;
        return this;
    }

    public Dispute withRespondBy(OffsetDateTime respondBy) {
        Utils.checkNotNull(respondBy, "respondBy");
        this.respondBy = respondBy;
        return this;
    }

    /**
     * The status of a particular dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
     */
    public Dispute withStatus(DisputeStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The phase of a dispute within the dispute lifecycle.
     */
    public Dispute withPhase(DisputePhase phase) {
        Utils.checkNotNull(phase, "phase");
        this.phase = phase;
        return this;
    }

    public Dispute withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    public Dispute withSubmittedOn(OffsetDateTime submittedOn) {
        Utils.checkNotNull(submittedOn, "submittedOn");
        this.submittedOn = Optional.ofNullable(submittedOn);
        return this;
    }

    public Dispute withSubmittedOn(Optional<OffsetDateTime> submittedOn) {
        Utils.checkNotNull(submittedOn, "submittedOn");
        this.submittedOn = submittedOn;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Dispute other = (Dispute) o;
        return 
            Objects.deepEquals(this.disputeID, other.disputeID) &&
            Objects.deepEquals(this.merchantAccountID, other.merchantAccountID) &&
            Objects.deepEquals(this.amount, other.amount) &&
            Objects.deepEquals(this.networkReasonCode, other.networkReasonCode) &&
            Objects.deepEquals(this.networkReasonDescription, other.networkReasonDescription) &&
            Objects.deepEquals(this.transfer, other.transfer) &&
            Objects.deepEquals(this.respondBy, other.respondBy) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.phase, other.phase) &&
            Objects.deepEquals(this.createdOn, other.createdOn) &&
            Objects.deepEquals(this.submittedOn, other.submittedOn);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            disputeID,
            merchantAccountID,
            amount,
            networkReasonCode,
            networkReasonDescription,
            transfer,
            respondBy,
            status,
            phase,
            createdOn,
            submittedOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Dispute.class,
                "disputeID", disputeID,
                "merchantAccountID", merchantAccountID,
                "amount", amount,
                "networkReasonCode", networkReasonCode,
                "networkReasonDescription", networkReasonDescription,
                "transfer", transfer,
                "respondBy", respondBy,
                "status", status,
                "phase", phase,
                "createdOn", createdOn,
                "submittedOn", submittedOn);
    }
    
    public final static class Builder {
 
        private String disputeID;
 
        private String merchantAccountID;
 
        private Amount amount;
 
        private String networkReasonCode;
 
        private Optional<String> networkReasonDescription = Optional.empty();
 
        private DisputeTransferDetails transfer;
 
        private OffsetDateTime respondBy;
 
        private DisputeStatus status;
 
        private DisputePhase phase;
 
        private OffsetDateTime createdOn;
 
        private Optional<OffsetDateTime> submittedOn = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder disputeID(String disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = disputeID;
            return this;
        }

        public Builder merchantAccountID(String merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = merchantAccountID;
            return this;
        }

        public Builder amount(Amount amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        /**
         * Indicates the card network's category for the dispute. 
         * 
         * <p>These codes may differ between card brands. You can find more information on the code from the networkReasonDescription field.
         */
        public Builder networkReasonCode(String networkReasonCode) {
            Utils.checkNotNull(networkReasonCode, "networkReasonCode");
            this.networkReasonCode = networkReasonCode;
            return this;
        }

        /**
         * Provides detail on the card network's categorization of the dispute.
         */
        public Builder networkReasonDescription(String networkReasonDescription) {
            Utils.checkNotNull(networkReasonDescription, "networkReasonDescription");
            this.networkReasonDescription = Optional.ofNullable(networkReasonDescription);
            return this;
        }

        /**
         * Provides detail on the card network's categorization of the dispute.
         */
        public Builder networkReasonDescription(Optional<String> networkReasonDescription) {
            Utils.checkNotNull(networkReasonDescription, "networkReasonDescription");
            this.networkReasonDescription = networkReasonDescription;
            return this;
        }

        public Builder transfer(DisputeTransferDetails transfer) {
            Utils.checkNotNull(transfer, "transfer");
            this.transfer = transfer;
            return this;
        }

        public Builder respondBy(OffsetDateTime respondBy) {
            Utils.checkNotNull(respondBy, "respondBy");
            this.respondBy = respondBy;
            return this;
        }

        /**
         * The status of a particular dispute. 
         * 
         * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
         */
        public Builder status(DisputeStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * The phase of a dispute within the dispute lifecycle.
         */
        public Builder phase(DisputePhase phase) {
            Utils.checkNotNull(phase, "phase");
            this.phase = phase;
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }

        public Builder submittedOn(OffsetDateTime submittedOn) {
            Utils.checkNotNull(submittedOn, "submittedOn");
            this.submittedOn = Optional.ofNullable(submittedOn);
            return this;
        }

        public Builder submittedOn(Optional<OffsetDateTime> submittedOn) {
            Utils.checkNotNull(submittedOn, "submittedOn");
            this.submittedOn = submittedOn;
            return this;
        }
        
        public Dispute build() {
            return new Dispute(
                disputeID,
                merchantAccountID,
                amount,
                networkReasonCode,
                networkReasonDescription,
                transfer,
                respondBy,
                status,
                phase,
                createdOn,
                submittedOn);
        }
    }
}
