/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class CustomerSupportError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone")
    private Optional<? extends PhoneNumberError> phone;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private Optional<String> email;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("address")
    private Optional<? extends AddressError> address;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("website")
    private Optional<String> website;

    @JsonCreator
    public CustomerSupportError(
            @JsonProperty("phone") Optional<? extends PhoneNumberError> phone,
            @JsonProperty("email") Optional<String> email,
            @JsonProperty("address") Optional<? extends AddressError> address,
            @JsonProperty("website") Optional<String> website) {
        Utils.checkNotNull(phone, "phone");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(address, "address");
        Utils.checkNotNull(website, "website");
        this.phone = phone;
        this.email = email;
        this.address = address;
        this.website = website;
    }
    
    public CustomerSupportError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PhoneNumberError> phone() {
        return (Optional<PhoneNumberError>) phone;
    }

    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AddressError> address() {
        return (Optional<AddressError>) address;
    }

    @JsonIgnore
    public Optional<String> website() {
        return website;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public CustomerSupportError withPhone(PhoneNumberError phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = Optional.ofNullable(phone);
        return this;
    }

    public CustomerSupportError withPhone(Optional<? extends PhoneNumberError> phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = phone;
        return this;
    }

    public CustomerSupportError withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }

    public CustomerSupportError withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public CustomerSupportError withAddress(AddressError address) {
        Utils.checkNotNull(address, "address");
        this.address = Optional.ofNullable(address);
        return this;
    }

    public CustomerSupportError withAddress(Optional<? extends AddressError> address) {
        Utils.checkNotNull(address, "address");
        this.address = address;
        return this;
    }

    public CustomerSupportError withWebsite(String website) {
        Utils.checkNotNull(website, "website");
        this.website = Optional.ofNullable(website);
        return this;
    }

    public CustomerSupportError withWebsite(Optional<String> website) {
        Utils.checkNotNull(website, "website");
        this.website = website;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CustomerSupportError other = (CustomerSupportError) o;
        return 
            Objects.deepEquals(this.phone, other.phone) &&
            Objects.deepEquals(this.email, other.email) &&
            Objects.deepEquals(this.address, other.address) &&
            Objects.deepEquals(this.website, other.website);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            phone,
            email,
            address,
            website);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CustomerSupportError.class,
                "phone", phone,
                "email", email,
                "address", address,
                "website", website);
    }
    
    public final static class Builder {
 
        private Optional<? extends PhoneNumberError> phone = Optional.empty();
 
        private Optional<String> email = Optional.empty();
 
        private Optional<? extends AddressError> address = Optional.empty();
 
        private Optional<String> website = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder phone(PhoneNumberError phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        public Builder phone(Optional<? extends PhoneNumberError> phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = phone;
            return this;
        }

        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public Builder address(AddressError address) {
            Utils.checkNotNull(address, "address");
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Optional<? extends AddressError> address) {
            Utils.checkNotNull(address, "address");
            this.address = address;
            return this;
        }

        public Builder website(String website) {
            Utils.checkNotNull(website, "website");
            this.website = Optional.ofNullable(website);
            return this;
        }

        public Builder website(Optional<String> website) {
            Utils.checkNotNull(website, "website");
            this.website = website;
            return this;
        }
        
        public CustomerSupportError build() {
            return new CustomerSupportError(
                phone,
                email,
                address,
                website);
        }
    }
}
