/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

/**
 * CreateTerminalApplication
 * 
 * <p>Describes a create terminal application request.
 */
public class CreateTerminalApplication {

    /**
     * Platform of the terminal application.
     */
    @JsonProperty("platform")
    private TerminalApplicationPlatform platform;

    /**
     * The app bundle identifier of the terminal application. Required if platform is `ios`.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("appBundleID")
    private Optional<String> appBundleID;

    /**
     * The app package name of the terminal application. Required if platform is `android`.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("packageName")
    private Optional<String> packageName;

    /**
     * The app version of the terminal application. Required if paltform is `android`.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sha256Digest")
    private Optional<String> sha256Digest;

    /**
     * The app version of the terminal application. Required if platform is `android`.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("versionCode")
    private Optional<String> versionCode;

    @JsonCreator
    public CreateTerminalApplication(
            @JsonProperty("platform") TerminalApplicationPlatform platform,
            @JsonProperty("appBundleID") Optional<String> appBundleID,
            @JsonProperty("packageName") Optional<String> packageName,
            @JsonProperty("sha256Digest") Optional<String> sha256Digest,
            @JsonProperty("versionCode") Optional<String> versionCode) {
        Utils.checkNotNull(platform, "platform");
        Utils.checkNotNull(appBundleID, "appBundleID");
        Utils.checkNotNull(packageName, "packageName");
        Utils.checkNotNull(sha256Digest, "sha256Digest");
        Utils.checkNotNull(versionCode, "versionCode");
        this.platform = platform;
        this.appBundleID = appBundleID;
        this.packageName = packageName;
        this.sha256Digest = sha256Digest;
        this.versionCode = versionCode;
    }
    
    public CreateTerminalApplication(
            TerminalApplicationPlatform platform) {
        this(platform, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Platform of the terminal application.
     */
    @JsonIgnore
    public TerminalApplicationPlatform platform() {
        return platform;
    }

    /**
     * The app bundle identifier of the terminal application. Required if platform is `ios`.
     */
    @JsonIgnore
    public Optional<String> appBundleID() {
        return appBundleID;
    }

    /**
     * The app package name of the terminal application. Required if platform is `android`.
     */
    @JsonIgnore
    public Optional<String> packageName() {
        return packageName;
    }

    /**
     * The app version of the terminal application. Required if paltform is `android`.
     */
    @JsonIgnore
    public Optional<String> sha256Digest() {
        return sha256Digest;
    }

    /**
     * The app version of the terminal application. Required if platform is `android`.
     */
    @JsonIgnore
    public Optional<String> versionCode() {
        return versionCode;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Platform of the terminal application.
     */
    public CreateTerminalApplication withPlatform(TerminalApplicationPlatform platform) {
        Utils.checkNotNull(platform, "platform");
        this.platform = platform;
        return this;
    }

    /**
     * The app bundle identifier of the terminal application. Required if platform is `ios`.
     */
    public CreateTerminalApplication withAppBundleID(String appBundleID) {
        Utils.checkNotNull(appBundleID, "appBundleID");
        this.appBundleID = Optional.ofNullable(appBundleID);
        return this;
    }

    /**
     * The app bundle identifier of the terminal application. Required if platform is `ios`.
     */
    public CreateTerminalApplication withAppBundleID(Optional<String> appBundleID) {
        Utils.checkNotNull(appBundleID, "appBundleID");
        this.appBundleID = appBundleID;
        return this;
    }

    /**
     * The app package name of the terminal application. Required if platform is `android`.
     */
    public CreateTerminalApplication withPackageName(String packageName) {
        Utils.checkNotNull(packageName, "packageName");
        this.packageName = Optional.ofNullable(packageName);
        return this;
    }

    /**
     * The app package name of the terminal application. Required if platform is `android`.
     */
    public CreateTerminalApplication withPackageName(Optional<String> packageName) {
        Utils.checkNotNull(packageName, "packageName");
        this.packageName = packageName;
        return this;
    }

    /**
     * The app version of the terminal application. Required if paltform is `android`.
     */
    public CreateTerminalApplication withSha256Digest(String sha256Digest) {
        Utils.checkNotNull(sha256Digest, "sha256Digest");
        this.sha256Digest = Optional.ofNullable(sha256Digest);
        return this;
    }

    /**
     * The app version of the terminal application. Required if paltform is `android`.
     */
    public CreateTerminalApplication withSha256Digest(Optional<String> sha256Digest) {
        Utils.checkNotNull(sha256Digest, "sha256Digest");
        this.sha256Digest = sha256Digest;
        return this;
    }

    /**
     * The app version of the terminal application. Required if platform is `android`.
     */
    public CreateTerminalApplication withVersionCode(String versionCode) {
        Utils.checkNotNull(versionCode, "versionCode");
        this.versionCode = Optional.ofNullable(versionCode);
        return this;
    }

    /**
     * The app version of the terminal application. Required if platform is `android`.
     */
    public CreateTerminalApplication withVersionCode(Optional<String> versionCode) {
        Utils.checkNotNull(versionCode, "versionCode");
        this.versionCode = versionCode;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTerminalApplication other = (CreateTerminalApplication) o;
        return 
            Objects.deepEquals(this.platform, other.platform) &&
            Objects.deepEquals(this.appBundleID, other.appBundleID) &&
            Objects.deepEquals(this.packageName, other.packageName) &&
            Objects.deepEquals(this.sha256Digest, other.sha256Digest) &&
            Objects.deepEquals(this.versionCode, other.versionCode);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            platform,
            appBundleID,
            packageName,
            sha256Digest,
            versionCode);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTerminalApplication.class,
                "platform", platform,
                "appBundleID", appBundleID,
                "packageName", packageName,
                "sha256Digest", sha256Digest,
                "versionCode", versionCode);
    }
    
    public final static class Builder {
 
        private TerminalApplicationPlatform platform;
 
        private Optional<String> appBundleID = Optional.empty();
 
        private Optional<String> packageName = Optional.empty();
 
        private Optional<String> sha256Digest = Optional.empty();
 
        private Optional<String> versionCode = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Platform of the terminal application.
         */
        public Builder platform(TerminalApplicationPlatform platform) {
            Utils.checkNotNull(platform, "platform");
            this.platform = platform;
            return this;
        }

        /**
         * The app bundle identifier of the terminal application. Required if platform is `ios`.
         */
        public Builder appBundleID(String appBundleID) {
            Utils.checkNotNull(appBundleID, "appBundleID");
            this.appBundleID = Optional.ofNullable(appBundleID);
            return this;
        }

        /**
         * The app bundle identifier of the terminal application. Required if platform is `ios`.
         */
        public Builder appBundleID(Optional<String> appBundleID) {
            Utils.checkNotNull(appBundleID, "appBundleID");
            this.appBundleID = appBundleID;
            return this;
        }

        /**
         * The app package name of the terminal application. Required if platform is `android`.
         */
        public Builder packageName(String packageName) {
            Utils.checkNotNull(packageName, "packageName");
            this.packageName = Optional.ofNullable(packageName);
            return this;
        }

        /**
         * The app package name of the terminal application. Required if platform is `android`.
         */
        public Builder packageName(Optional<String> packageName) {
            Utils.checkNotNull(packageName, "packageName");
            this.packageName = packageName;
            return this;
        }

        /**
         * The app version of the terminal application. Required if paltform is `android`.
         */
        public Builder sha256Digest(String sha256Digest) {
            Utils.checkNotNull(sha256Digest, "sha256Digest");
            this.sha256Digest = Optional.ofNullable(sha256Digest);
            return this;
        }

        /**
         * The app version of the terminal application. Required if paltform is `android`.
         */
        public Builder sha256Digest(Optional<String> sha256Digest) {
            Utils.checkNotNull(sha256Digest, "sha256Digest");
            this.sha256Digest = sha256Digest;
            return this;
        }

        /**
         * The app version of the terminal application. Required if platform is `android`.
         */
        public Builder versionCode(String versionCode) {
            Utils.checkNotNull(versionCode, "versionCode");
            this.versionCode = Optional.ofNullable(versionCode);
            return this;
        }

        /**
         * The app version of the terminal application. Required if platform is `android`.
         */
        public Builder versionCode(Optional<String> versionCode) {
            Utils.checkNotNull(versionCode, "versionCode");
            this.versionCode = versionCode;
            return this;
        }
        
        public CreateTerminalApplication build() {
            return new CreateTerminalApplication(
                platform,
                appBundleID,
                packageName,
                sha256Digest,
                versionCode);
        }
    }
}
