/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

/**
 * CreateRepresentative
 * 
 * <p>Describes a business representative to create.
 */
public class CreateRepresentative {

    @JsonProperty("name")
    private IndividualName name;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone")
    private Optional<? extends PhoneNumber> phone;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private Optional<String> email;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("address")
    private Optional<? extends Address> address;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("birthDate")
    private Optional<? extends BirthDate> birthDate;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("governmentID")
    private Optional<? extends GovernmentID> governmentID;

    /**
     * Describes the job responsibilities of a business representative.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("responsibilities")
    private Optional<? extends RepresentativeResponsibilities> responsibilities;

    @JsonCreator
    public CreateRepresentative(
            @JsonProperty("name") IndividualName name,
            @JsonProperty("phone") Optional<? extends PhoneNumber> phone,
            @JsonProperty("email") Optional<String> email,
            @JsonProperty("address") Optional<? extends Address> address,
            @JsonProperty("birthDate") Optional<? extends BirthDate> birthDate,
            @JsonProperty("governmentID") Optional<? extends GovernmentID> governmentID,
            @JsonProperty("responsibilities") Optional<? extends RepresentativeResponsibilities> responsibilities) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(phone, "phone");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(address, "address");
        Utils.checkNotNull(birthDate, "birthDate");
        Utils.checkNotNull(governmentID, "governmentID");
        Utils.checkNotNull(responsibilities, "responsibilities");
        this.name = name;
        this.phone = phone;
        this.email = email;
        this.address = address;
        this.birthDate = birthDate;
        this.governmentID = governmentID;
        this.responsibilities = responsibilities;
    }
    
    public CreateRepresentative(
            IndividualName name) {
        this(name, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public IndividualName name() {
        return name;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PhoneNumber> phone() {
        return (Optional<PhoneNumber>) phone;
    }

    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Address> address() {
        return (Optional<Address>) address;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BirthDate> birthDate() {
        return (Optional<BirthDate>) birthDate;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<GovernmentID> governmentID() {
        return (Optional<GovernmentID>) governmentID;
    }

    /**
     * Describes the job responsibilities of a business representative.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<RepresentativeResponsibilities> responsibilities() {
        return (Optional<RepresentativeResponsibilities>) responsibilities;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public CreateRepresentative withName(IndividualName name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public CreateRepresentative withPhone(PhoneNumber phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = Optional.ofNullable(phone);
        return this;
    }

    public CreateRepresentative withPhone(Optional<? extends PhoneNumber> phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = phone;
        return this;
    }

    public CreateRepresentative withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }

    public CreateRepresentative withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public CreateRepresentative withAddress(Address address) {
        Utils.checkNotNull(address, "address");
        this.address = Optional.ofNullable(address);
        return this;
    }

    public CreateRepresentative withAddress(Optional<? extends Address> address) {
        Utils.checkNotNull(address, "address");
        this.address = address;
        return this;
    }

    public CreateRepresentative withBirthDate(BirthDate birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = Optional.ofNullable(birthDate);
        return this;
    }

    public CreateRepresentative withBirthDate(Optional<? extends BirthDate> birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = birthDate;
        return this;
    }

    public CreateRepresentative withGovernmentID(GovernmentID governmentID) {
        Utils.checkNotNull(governmentID, "governmentID");
        this.governmentID = Optional.ofNullable(governmentID);
        return this;
    }

    public CreateRepresentative withGovernmentID(Optional<? extends GovernmentID> governmentID) {
        Utils.checkNotNull(governmentID, "governmentID");
        this.governmentID = governmentID;
        return this;
    }

    /**
     * Describes the job responsibilities of a business representative.
     */
    public CreateRepresentative withResponsibilities(RepresentativeResponsibilities responsibilities) {
        Utils.checkNotNull(responsibilities, "responsibilities");
        this.responsibilities = Optional.ofNullable(responsibilities);
        return this;
    }

    /**
     * Describes the job responsibilities of a business representative.
     */
    public CreateRepresentative withResponsibilities(Optional<? extends RepresentativeResponsibilities> responsibilities) {
        Utils.checkNotNull(responsibilities, "responsibilities");
        this.responsibilities = responsibilities;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateRepresentative other = (CreateRepresentative) o;
        return 
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.phone, other.phone) &&
            Objects.deepEquals(this.email, other.email) &&
            Objects.deepEquals(this.address, other.address) &&
            Objects.deepEquals(this.birthDate, other.birthDate) &&
            Objects.deepEquals(this.governmentID, other.governmentID) &&
            Objects.deepEquals(this.responsibilities, other.responsibilities);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            name,
            phone,
            email,
            address,
            birthDate,
            governmentID,
            responsibilities);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateRepresentative.class,
                "name", name,
                "phone", phone,
                "email", email,
                "address", address,
                "birthDate", birthDate,
                "governmentID", governmentID,
                "responsibilities", responsibilities);
    }
    
    public final static class Builder {
 
        private IndividualName name;
 
        private Optional<? extends PhoneNumber> phone = Optional.empty();
 
        private Optional<String> email = Optional.empty();
 
        private Optional<? extends Address> address = Optional.empty();
 
        private Optional<? extends BirthDate> birthDate = Optional.empty();
 
        private Optional<? extends GovernmentID> governmentID = Optional.empty();
 
        private Optional<? extends RepresentativeResponsibilities> responsibilities = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder name(IndividualName name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder phone(PhoneNumber phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        public Builder phone(Optional<? extends PhoneNumber> phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = phone;
            return this;
        }

        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public Builder address(Address address) {
            Utils.checkNotNull(address, "address");
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Optional<? extends Address> address) {
            Utils.checkNotNull(address, "address");
            this.address = address;
            return this;
        }

        public Builder birthDate(BirthDate birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = Optional.ofNullable(birthDate);
            return this;
        }

        public Builder birthDate(Optional<? extends BirthDate> birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = birthDate;
            return this;
        }

        public Builder governmentID(GovernmentID governmentID) {
            Utils.checkNotNull(governmentID, "governmentID");
            this.governmentID = Optional.ofNullable(governmentID);
            return this;
        }

        public Builder governmentID(Optional<? extends GovernmentID> governmentID) {
            Utils.checkNotNull(governmentID, "governmentID");
            this.governmentID = governmentID;
            return this;
        }

        /**
         * Describes the job responsibilities of a business representative.
         */
        public Builder responsibilities(RepresentativeResponsibilities responsibilities) {
            Utils.checkNotNull(responsibilities, "responsibilities");
            this.responsibilities = Optional.ofNullable(responsibilities);
            return this;
        }

        /**
         * Describes the job responsibilities of a business representative.
         */
        public Builder responsibilities(Optional<? extends RepresentativeResponsibilities> responsibilities) {
            Utils.checkNotNull(responsibilities, "responsibilities");
            this.responsibilities = responsibilities;
            return this;
        }
        
        public CreateRepresentative build() {
            return new CreateRepresentative(
                name,
                phone,
                email,
                address,
                birthDate,
                governmentID,
                responsibilities);
        }
    }
}
