/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

/**
 * CreatePaymentLink
 * 
 * <p>Request to create a new payment link.
 * 
 * <p>A payment link must include either `payment` or `payout` details, but not both. For payout payment links,
 * `maxUses` will automatically be set to 1, as these are intended for a one-time disbursement
 * to a specific recipient.
 * 
 * <p>**Note:** The `payout` option is currently under development and is not yet available for general use.
 */
public class CreatePaymentLink {

    /**
     * The partner's Moov account ID.
     */
    @JsonProperty("partnerAccountID")
    private String partnerAccountID;

    /**
     * The merchant's preferred payment method ID. Must be a wallet payment method.
     */
    @JsonProperty("merchantPaymentMethodID")
    private String merchantPaymentMethodID;

    @JsonProperty("amount")
    private Amount amount;

    /**
     * An optional limit on the number of times this payment link can be used. 
     * 
     * <p>**For payouts, `maxUses` is always 1.**
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("maxUses")
    private Optional<Long> maxUses;

    /**
     * An optional expiration date for this payment link.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expiresOn")
    private Optional<OffsetDateTime> expiresOn;

    /**
     * Customizable display options for a payment link.
     */
    @JsonProperty("display")
    private PaymentLinkDisplayOptions display;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("customer")
    private Optional<? extends PaymentLinkCustomerOptions> customer;

    /**
     * Options for payment links used to collect payment.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("payment")
    private Optional<? extends PaymentLinkPaymentDetails> payment;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("payout")
    private Optional<? extends PaymentLinkPayoutDetails> payout;

    @JsonCreator
    public CreatePaymentLink(
            @JsonProperty("partnerAccountID") String partnerAccountID,
            @JsonProperty("merchantPaymentMethodID") String merchantPaymentMethodID,
            @JsonProperty("amount") Amount amount,
            @JsonProperty("maxUses") Optional<Long> maxUses,
            @JsonProperty("expiresOn") Optional<OffsetDateTime> expiresOn,
            @JsonProperty("display") PaymentLinkDisplayOptions display,
            @JsonProperty("customer") Optional<? extends PaymentLinkCustomerOptions> customer,
            @JsonProperty("payment") Optional<? extends PaymentLinkPaymentDetails> payment,
            @JsonProperty("payout") Optional<? extends PaymentLinkPayoutDetails> payout) {
        Utils.checkNotNull(partnerAccountID, "partnerAccountID");
        Utils.checkNotNull(merchantPaymentMethodID, "merchantPaymentMethodID");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(maxUses, "maxUses");
        Utils.checkNotNull(expiresOn, "expiresOn");
        Utils.checkNotNull(display, "display");
        Utils.checkNotNull(customer, "customer");
        Utils.checkNotNull(payment, "payment");
        Utils.checkNotNull(payout, "payout");
        this.partnerAccountID = partnerAccountID;
        this.merchantPaymentMethodID = merchantPaymentMethodID;
        this.amount = amount;
        this.maxUses = maxUses;
        this.expiresOn = expiresOn;
        this.display = display;
        this.customer = customer;
        this.payment = payment;
        this.payout = payout;
    }
    
    public CreatePaymentLink(
            String partnerAccountID,
            String merchantPaymentMethodID,
            Amount amount,
            PaymentLinkDisplayOptions display) {
        this(partnerAccountID, merchantPaymentMethodID, amount, Optional.empty(), Optional.empty(), display, Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * The partner's Moov account ID.
     */
    @JsonIgnore
    public String partnerAccountID() {
        return partnerAccountID;
    }

    /**
     * The merchant's preferred payment method ID. Must be a wallet payment method.
     */
    @JsonIgnore
    public String merchantPaymentMethodID() {
        return merchantPaymentMethodID;
    }

    @JsonIgnore
    public Amount amount() {
        return amount;
    }

    /**
     * An optional limit on the number of times this payment link can be used. 
     * 
     * <p>**For payouts, `maxUses` is always 1.**
     */
    @JsonIgnore
    public Optional<Long> maxUses() {
        return maxUses;
    }

    /**
     * An optional expiration date for this payment link.
     */
    @JsonIgnore
    public Optional<OffsetDateTime> expiresOn() {
        return expiresOn;
    }

    /**
     * Customizable display options for a payment link.
     */
    @JsonIgnore
    public PaymentLinkDisplayOptions display() {
        return display;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentLinkCustomerOptions> customer() {
        return (Optional<PaymentLinkCustomerOptions>) customer;
    }

    /**
     * Options for payment links used to collect payment.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentLinkPaymentDetails> payment() {
        return (Optional<PaymentLinkPaymentDetails>) payment;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentLinkPayoutDetails> payout() {
        return (Optional<PaymentLinkPayoutDetails>) payout;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The partner's Moov account ID.
     */
    public CreatePaymentLink withPartnerAccountID(String partnerAccountID) {
        Utils.checkNotNull(partnerAccountID, "partnerAccountID");
        this.partnerAccountID = partnerAccountID;
        return this;
    }

    /**
     * The merchant's preferred payment method ID. Must be a wallet payment method.
     */
    public CreatePaymentLink withMerchantPaymentMethodID(String merchantPaymentMethodID) {
        Utils.checkNotNull(merchantPaymentMethodID, "merchantPaymentMethodID");
        this.merchantPaymentMethodID = merchantPaymentMethodID;
        return this;
    }

    public CreatePaymentLink withAmount(Amount amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    /**
     * An optional limit on the number of times this payment link can be used. 
     * 
     * <p>**For payouts, `maxUses` is always 1.**
     */
    public CreatePaymentLink withMaxUses(long maxUses) {
        Utils.checkNotNull(maxUses, "maxUses");
        this.maxUses = Optional.ofNullable(maxUses);
        return this;
    }

    /**
     * An optional limit on the number of times this payment link can be used. 
     * 
     * <p>**For payouts, `maxUses` is always 1.**
     */
    public CreatePaymentLink withMaxUses(Optional<Long> maxUses) {
        Utils.checkNotNull(maxUses, "maxUses");
        this.maxUses = maxUses;
        return this;
    }

    /**
     * An optional expiration date for this payment link.
     */
    public CreatePaymentLink withExpiresOn(OffsetDateTime expiresOn) {
        Utils.checkNotNull(expiresOn, "expiresOn");
        this.expiresOn = Optional.ofNullable(expiresOn);
        return this;
    }

    /**
     * An optional expiration date for this payment link.
     */
    public CreatePaymentLink withExpiresOn(Optional<OffsetDateTime> expiresOn) {
        Utils.checkNotNull(expiresOn, "expiresOn");
        this.expiresOn = expiresOn;
        return this;
    }

    /**
     * Customizable display options for a payment link.
     */
    public CreatePaymentLink withDisplay(PaymentLinkDisplayOptions display) {
        Utils.checkNotNull(display, "display");
        this.display = display;
        return this;
    }

    public CreatePaymentLink withCustomer(PaymentLinkCustomerOptions customer) {
        Utils.checkNotNull(customer, "customer");
        this.customer = Optional.ofNullable(customer);
        return this;
    }

    public CreatePaymentLink withCustomer(Optional<? extends PaymentLinkCustomerOptions> customer) {
        Utils.checkNotNull(customer, "customer");
        this.customer = customer;
        return this;
    }

    /**
     * Options for payment links used to collect payment.
     */
    public CreatePaymentLink withPayment(PaymentLinkPaymentDetails payment) {
        Utils.checkNotNull(payment, "payment");
        this.payment = Optional.ofNullable(payment);
        return this;
    }

    /**
     * Options for payment links used to collect payment.
     */
    public CreatePaymentLink withPayment(Optional<? extends PaymentLinkPaymentDetails> payment) {
        Utils.checkNotNull(payment, "payment");
        this.payment = payment;
        return this;
    }

    public CreatePaymentLink withPayout(PaymentLinkPayoutDetails payout) {
        Utils.checkNotNull(payout, "payout");
        this.payout = Optional.ofNullable(payout);
        return this;
    }

    public CreatePaymentLink withPayout(Optional<? extends PaymentLinkPayoutDetails> payout) {
        Utils.checkNotNull(payout, "payout");
        this.payout = payout;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreatePaymentLink other = (CreatePaymentLink) o;
        return 
            Objects.deepEquals(this.partnerAccountID, other.partnerAccountID) &&
            Objects.deepEquals(this.merchantPaymentMethodID, other.merchantPaymentMethodID) &&
            Objects.deepEquals(this.amount, other.amount) &&
            Objects.deepEquals(this.maxUses, other.maxUses) &&
            Objects.deepEquals(this.expiresOn, other.expiresOn) &&
            Objects.deepEquals(this.display, other.display) &&
            Objects.deepEquals(this.customer, other.customer) &&
            Objects.deepEquals(this.payment, other.payment) &&
            Objects.deepEquals(this.payout, other.payout);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            partnerAccountID,
            merchantPaymentMethodID,
            amount,
            maxUses,
            expiresOn,
            display,
            customer,
            payment,
            payout);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreatePaymentLink.class,
                "partnerAccountID", partnerAccountID,
                "merchantPaymentMethodID", merchantPaymentMethodID,
                "amount", amount,
                "maxUses", maxUses,
                "expiresOn", expiresOn,
                "display", display,
                "customer", customer,
                "payment", payment,
                "payout", payout);
    }
    
    public final static class Builder {
 
        private String partnerAccountID;
 
        private String merchantPaymentMethodID;
 
        private Amount amount;
 
        private Optional<Long> maxUses = Optional.empty();
 
        private Optional<OffsetDateTime> expiresOn = Optional.empty();
 
        private PaymentLinkDisplayOptions display;
 
        private Optional<? extends PaymentLinkCustomerOptions> customer = Optional.empty();
 
        private Optional<? extends PaymentLinkPaymentDetails> payment = Optional.empty();
 
        private Optional<? extends PaymentLinkPayoutDetails> payout = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The partner's Moov account ID.
         */
        public Builder partnerAccountID(String partnerAccountID) {
            Utils.checkNotNull(partnerAccountID, "partnerAccountID");
            this.partnerAccountID = partnerAccountID;
            return this;
        }

        /**
         * The merchant's preferred payment method ID. Must be a wallet payment method.
         */
        public Builder merchantPaymentMethodID(String merchantPaymentMethodID) {
            Utils.checkNotNull(merchantPaymentMethodID, "merchantPaymentMethodID");
            this.merchantPaymentMethodID = merchantPaymentMethodID;
            return this;
        }

        public Builder amount(Amount amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        /**
         * An optional limit on the number of times this payment link can be used. 
         * 
         * <p>**For payouts, `maxUses` is always 1.**
         */
        public Builder maxUses(long maxUses) {
            Utils.checkNotNull(maxUses, "maxUses");
            this.maxUses = Optional.ofNullable(maxUses);
            return this;
        }

        /**
         * An optional limit on the number of times this payment link can be used. 
         * 
         * <p>**For payouts, `maxUses` is always 1.**
         */
        public Builder maxUses(Optional<Long> maxUses) {
            Utils.checkNotNull(maxUses, "maxUses");
            this.maxUses = maxUses;
            return this;
        }

        /**
         * An optional expiration date for this payment link.
         */
        public Builder expiresOn(OffsetDateTime expiresOn) {
            Utils.checkNotNull(expiresOn, "expiresOn");
            this.expiresOn = Optional.ofNullable(expiresOn);
            return this;
        }

        /**
         * An optional expiration date for this payment link.
         */
        public Builder expiresOn(Optional<OffsetDateTime> expiresOn) {
            Utils.checkNotNull(expiresOn, "expiresOn");
            this.expiresOn = expiresOn;
            return this;
        }

        /**
         * Customizable display options for a payment link.
         */
        public Builder display(PaymentLinkDisplayOptions display) {
            Utils.checkNotNull(display, "display");
            this.display = display;
            return this;
        }

        public Builder customer(PaymentLinkCustomerOptions customer) {
            Utils.checkNotNull(customer, "customer");
            this.customer = Optional.ofNullable(customer);
            return this;
        }

        public Builder customer(Optional<? extends PaymentLinkCustomerOptions> customer) {
            Utils.checkNotNull(customer, "customer");
            this.customer = customer;
            return this;
        }

        /**
         * Options for payment links used to collect payment.
         */
        public Builder payment(PaymentLinkPaymentDetails payment) {
            Utils.checkNotNull(payment, "payment");
            this.payment = Optional.ofNullable(payment);
            return this;
        }

        /**
         * Options for payment links used to collect payment.
         */
        public Builder payment(Optional<? extends PaymentLinkPaymentDetails> payment) {
            Utils.checkNotNull(payment, "payment");
            this.payment = payment;
            return this;
        }

        public Builder payout(PaymentLinkPayoutDetails payout) {
            Utils.checkNotNull(payout, "payout");
            this.payout = Optional.ofNullable(payout);
            return this;
        }

        public Builder payout(Optional<? extends PaymentLinkPayoutDetails> payout) {
            Utils.checkNotNull(payout, "payout");
            this.payout = payout;
            return this;
        }
        
        public CreatePaymentLink build() {
            return new CreatePaymentLink(
                partnerAccountID,
                merchantPaymentMethodID,
                amount,
                maxUses,
                expiresOn,
                display,
                customer,
                payment,
                payout);
        }
    }
}
