/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class CreateIndividualProfile {

    @JsonProperty("name")
    private IndividualName name;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone")
    private Optional<? extends PhoneNumber> phone;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private Optional<String> email;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("address")
    private Optional<? extends Address> address;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("birthDate")
    private Optional<? extends BirthDate> birthDate;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("governmentID")
    private Optional<? extends GovernmentID> governmentID;

    @JsonCreator
    public CreateIndividualProfile(
            @JsonProperty("name") IndividualName name,
            @JsonProperty("phone") Optional<? extends PhoneNumber> phone,
            @JsonProperty("email") Optional<String> email,
            @JsonProperty("address") Optional<? extends Address> address,
            @JsonProperty("birthDate") Optional<? extends BirthDate> birthDate,
            @JsonProperty("governmentID") Optional<? extends GovernmentID> governmentID) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(phone, "phone");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(address, "address");
        Utils.checkNotNull(birthDate, "birthDate");
        Utils.checkNotNull(governmentID, "governmentID");
        this.name = name;
        this.phone = phone;
        this.email = email;
        this.address = address;
        this.birthDate = birthDate;
        this.governmentID = governmentID;
    }
    
    public CreateIndividualProfile(
            IndividualName name) {
        this(name, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public IndividualName name() {
        return name;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PhoneNumber> phone() {
        return (Optional<PhoneNumber>) phone;
    }

    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Address> address() {
        return (Optional<Address>) address;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BirthDate> birthDate() {
        return (Optional<BirthDate>) birthDate;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<GovernmentID> governmentID() {
        return (Optional<GovernmentID>) governmentID;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public CreateIndividualProfile withName(IndividualName name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public CreateIndividualProfile withPhone(PhoneNumber phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = Optional.ofNullable(phone);
        return this;
    }

    public CreateIndividualProfile withPhone(Optional<? extends PhoneNumber> phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = phone;
        return this;
    }

    public CreateIndividualProfile withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }

    public CreateIndividualProfile withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public CreateIndividualProfile withAddress(Address address) {
        Utils.checkNotNull(address, "address");
        this.address = Optional.ofNullable(address);
        return this;
    }

    public CreateIndividualProfile withAddress(Optional<? extends Address> address) {
        Utils.checkNotNull(address, "address");
        this.address = address;
        return this;
    }

    public CreateIndividualProfile withBirthDate(BirthDate birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = Optional.ofNullable(birthDate);
        return this;
    }

    public CreateIndividualProfile withBirthDate(Optional<? extends BirthDate> birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = birthDate;
        return this;
    }

    public CreateIndividualProfile withGovernmentID(GovernmentID governmentID) {
        Utils.checkNotNull(governmentID, "governmentID");
        this.governmentID = Optional.ofNullable(governmentID);
        return this;
    }

    public CreateIndividualProfile withGovernmentID(Optional<? extends GovernmentID> governmentID) {
        Utils.checkNotNull(governmentID, "governmentID");
        this.governmentID = governmentID;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateIndividualProfile other = (CreateIndividualProfile) o;
        return 
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.phone, other.phone) &&
            Objects.deepEquals(this.email, other.email) &&
            Objects.deepEquals(this.address, other.address) &&
            Objects.deepEquals(this.birthDate, other.birthDate) &&
            Objects.deepEquals(this.governmentID, other.governmentID);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            name,
            phone,
            email,
            address,
            birthDate,
            governmentID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateIndividualProfile.class,
                "name", name,
                "phone", phone,
                "email", email,
                "address", address,
                "birthDate", birthDate,
                "governmentID", governmentID);
    }
    
    public final static class Builder {
 
        private IndividualName name;
 
        private Optional<? extends PhoneNumber> phone = Optional.empty();
 
        private Optional<String> email = Optional.empty();
 
        private Optional<? extends Address> address = Optional.empty();
 
        private Optional<? extends BirthDate> birthDate = Optional.empty();
 
        private Optional<? extends GovernmentID> governmentID = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder name(IndividualName name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder phone(PhoneNumber phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        public Builder phone(Optional<? extends PhoneNumber> phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = phone;
            return this;
        }

        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public Builder address(Address address) {
            Utils.checkNotNull(address, "address");
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Optional<? extends Address> address) {
            Utils.checkNotNull(address, "address");
            this.address = address;
            return this;
        }

        public Builder birthDate(BirthDate birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = Optional.ofNullable(birthDate);
            return this;
        }

        public Builder birthDate(Optional<? extends BirthDate> birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = birthDate;
            return this;
        }

        public Builder governmentID(GovernmentID governmentID) {
            Utils.checkNotNull(governmentID, "governmentID");
            this.governmentID = Optional.ofNullable(governmentID);
            return this;
        }

        public Builder governmentID(Optional<? extends GovernmentID> governmentID) {
            Utils.checkNotNull(governmentID, "governmentID");
            this.governmentID = governmentID;
            return this;
        }
        
        public CreateIndividualProfile build() {
            return new CreateIndividualProfile(
                name,
                phone,
                email,
                address,
                birthDate,
                governmentID);
        }
    }
}
