/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CreateEvidenceText {

    /**
     * The text to associate with the dispute as evidence.
     */
    @JsonProperty("text")
    private String text;

    @JsonProperty("evidenceType")
    private EvidenceType evidenceType;

    @JsonCreator
    public CreateEvidenceText(
            @JsonProperty("text") String text,
            @JsonProperty("evidenceType") EvidenceType evidenceType) {
        Utils.checkNotNull(text, "text");
        Utils.checkNotNull(evidenceType, "evidenceType");
        this.text = text;
        this.evidenceType = evidenceType;
    }

    /**
     * The text to associate with the dispute as evidence.
     */
    @JsonIgnore
    public String text() {
        return text;
    }

    @JsonIgnore
    public EvidenceType evidenceType() {
        return evidenceType;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The text to associate with the dispute as evidence.
     */
    public CreateEvidenceText withText(String text) {
        Utils.checkNotNull(text, "text");
        this.text = text;
        return this;
    }

    public CreateEvidenceText withEvidenceType(EvidenceType evidenceType) {
        Utils.checkNotNull(evidenceType, "evidenceType");
        this.evidenceType = evidenceType;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateEvidenceText other = (CreateEvidenceText) o;
        return 
            Objects.deepEquals(this.text, other.text) &&
            Objects.deepEquals(this.evidenceType, other.evidenceType);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            text,
            evidenceType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateEvidenceText.class,
                "text", text,
                "evidenceType", evidenceType);
    }
    
    public final static class Builder {
 
        private String text;
 
        private EvidenceType evidenceType;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The text to associate with the dispute as evidence.
         */
        public Builder text(String text) {
            Utils.checkNotNull(text, "text");
            this.text = text;
            return this;
        }

        public Builder evidenceType(EvidenceType evidenceType) {
            Utils.checkNotNull(evidenceType, "evidenceType");
            this.evidenceType = evidenceType;
            return this;
        }
        
        public CreateEvidenceText build() {
            return new CreateEvidenceText(
                text,
                evidenceType);
        }
    }
}
