/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CreateApplePaySession {

    /**
     * A fully qualified top-level or sub-domain name where you will accept Apple Pay. Should not include "https".
     */
    @JsonProperty("domain")
    private String domain;

    /**
     * A UTF-8 string to display in the Buy button.
     */
    @JsonProperty("displayName")
    private String displayName;

    @JsonCreator
    public CreateApplePaySession(
            @JsonProperty("domain") String domain,
            @JsonProperty("displayName") String displayName) {
        Utils.checkNotNull(domain, "domain");
        Utils.checkNotNull(displayName, "displayName");
        this.domain = domain;
        this.displayName = displayName;
    }

    /**
     * A fully qualified top-level or sub-domain name where you will accept Apple Pay. Should not include "https".
     */
    @JsonIgnore
    public String domain() {
        return domain;
    }

    /**
     * A UTF-8 string to display in the Buy button.
     */
    @JsonIgnore
    public String displayName() {
        return displayName;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * A fully qualified top-level or sub-domain name where you will accept Apple Pay. Should not include "https".
     */
    public CreateApplePaySession withDomain(String domain) {
        Utils.checkNotNull(domain, "domain");
        this.domain = domain;
        return this;
    }

    /**
     * A UTF-8 string to display in the Buy button.
     */
    public CreateApplePaySession withDisplayName(String displayName) {
        Utils.checkNotNull(displayName, "displayName");
        this.displayName = displayName;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateApplePaySession other = (CreateApplePaySession) o;
        return 
            Objects.deepEquals(this.domain, other.domain) &&
            Objects.deepEquals(this.displayName, other.displayName);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            domain,
            displayName);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateApplePaySession.class,
                "domain", domain,
                "displayName", displayName);
    }
    
    public final static class Builder {
 
        private String domain;
 
        private String displayName;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * A fully qualified top-level or sub-domain name where you will accept Apple Pay. Should not include "https".
         */
        public Builder domain(String domain) {
            Utils.checkNotNull(domain, "domain");
            this.domain = domain;
            return this;
        }

        /**
         * A UTF-8 string to display in the Buy button.
         */
        public Builder displayName(String displayName) {
            Utils.checkNotNull(displayName, "displayName");
            this.displayName = displayName;
            return this;
        }
        
        public CreateApplePaySession build() {
            return new CreateApplePaySession(
                domain,
                displayName);
        }
    }
}
