/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class CreateAccountSettings {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardPayment")
    private Optional<? extends CardPayment> cardPayment;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("achPayment")
    private Optional<? extends AchPayment> achPayment;

    @JsonCreator
    public CreateAccountSettings(
            @JsonProperty("cardPayment") Optional<? extends CardPayment> cardPayment,
            @JsonProperty("achPayment") Optional<? extends AchPayment> achPayment) {
        Utils.checkNotNull(cardPayment, "cardPayment");
        Utils.checkNotNull(achPayment, "achPayment");
        this.cardPayment = cardPayment;
        this.achPayment = achPayment;
    }
    
    public CreateAccountSettings() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardPayment> cardPayment() {
        return (Optional<CardPayment>) cardPayment;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AchPayment> achPayment() {
        return (Optional<AchPayment>) achPayment;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public CreateAccountSettings withCardPayment(CardPayment cardPayment) {
        Utils.checkNotNull(cardPayment, "cardPayment");
        this.cardPayment = Optional.ofNullable(cardPayment);
        return this;
    }

    public CreateAccountSettings withCardPayment(Optional<? extends CardPayment> cardPayment) {
        Utils.checkNotNull(cardPayment, "cardPayment");
        this.cardPayment = cardPayment;
        return this;
    }

    public CreateAccountSettings withAchPayment(AchPayment achPayment) {
        Utils.checkNotNull(achPayment, "achPayment");
        this.achPayment = Optional.ofNullable(achPayment);
        return this;
    }

    public CreateAccountSettings withAchPayment(Optional<? extends AchPayment> achPayment) {
        Utils.checkNotNull(achPayment, "achPayment");
        this.achPayment = achPayment;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountSettings other = (CreateAccountSettings) o;
        return 
            Objects.deepEquals(this.cardPayment, other.cardPayment) &&
            Objects.deepEquals(this.achPayment, other.achPayment);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            cardPayment,
            achPayment);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateAccountSettings.class,
                "cardPayment", cardPayment,
                "achPayment", achPayment);
    }
    
    public final static class Builder {
 
        private Optional<? extends CardPayment> cardPayment = Optional.empty();
 
        private Optional<? extends AchPayment> achPayment = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder cardPayment(CardPayment cardPayment) {
            Utils.checkNotNull(cardPayment, "cardPayment");
            this.cardPayment = Optional.ofNullable(cardPayment);
            return this;
        }

        public Builder cardPayment(Optional<? extends CardPayment> cardPayment) {
            Utils.checkNotNull(cardPayment, "cardPayment");
            this.cardPayment = cardPayment;
            return this;
        }

        public Builder achPayment(AchPayment achPayment) {
            Utils.checkNotNull(achPayment, "achPayment");
            this.achPayment = Optional.ofNullable(achPayment);
            return this;
        }

        public Builder achPayment(Optional<? extends AchPayment> achPayment) {
            Utils.checkNotNull(achPayment, "achPayment");
            this.achPayment = achPayment;
            return this;
        }
        
        public CreateAccountSettings build() {
            return new CreateAccountSettings(
                cardPayment,
                achPayment);
        }
    }
}
