/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateAccount {

    @JsonProperty("accountType")
    private CreateAccountType accountType;

    @JsonProperty("profile")
    private CreateProfile profile;

    /**
     * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("metadata")
    private Optional<? extends Map<String, String>> metadata;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("termsOfService")
    private Optional<? extends CreateAccountTermsOfService> termsOfService;

    /**
     * Optional alias from a foreign/external system which can be used to reference this resource.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("foreignID")
    private Optional<String> foreignID;

    /**
     * User-provided information that can be displayed on credit card transactions for customers to use when
     * contacting a customer support team. This data is only allowed on a business account.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("customerSupport")
    private Optional<? extends CustomerSupport> customerSupport;

    /**
     * User provided settings to manage an account.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("settings")
    private Optional<? extends Settings> settings;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("capabilities")
    private Optional<? extends List<CapabilityID>> capabilities;

    /**
     * The operating mode for an account.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("mode")
    private Optional<? extends Mode> mode;

    @JsonCreator
    public CreateAccount(
            @JsonProperty("accountType") CreateAccountType accountType,
            @JsonProperty("profile") CreateProfile profile,
            @JsonProperty("metadata") Optional<? extends Map<String, String>> metadata,
            @JsonProperty("termsOfService") Optional<? extends CreateAccountTermsOfService> termsOfService,
            @JsonProperty("foreignID") Optional<String> foreignID,
            @JsonProperty("customerSupport") Optional<? extends CustomerSupport> customerSupport,
            @JsonProperty("settings") Optional<? extends Settings> settings,
            @JsonProperty("capabilities") Optional<? extends List<CapabilityID>> capabilities,
            @JsonProperty("mode") Optional<? extends Mode> mode) {
        Utils.checkNotNull(accountType, "accountType");
        Utils.checkNotNull(profile, "profile");
        Utils.checkNotNull(metadata, "metadata");
        Utils.checkNotNull(termsOfService, "termsOfService");
        Utils.checkNotNull(foreignID, "foreignID");
        Utils.checkNotNull(customerSupport, "customerSupport");
        Utils.checkNotNull(settings, "settings");
        Utils.checkNotNull(capabilities, "capabilities");
        Utils.checkNotNull(mode, "mode");
        this.accountType = accountType;
        this.profile = profile;
        this.metadata = metadata;
        this.termsOfService = termsOfService;
        this.foreignID = foreignID;
        this.customerSupport = customerSupport;
        this.settings = settings;
        this.capabilities = capabilities;
        this.mode = mode;
    }
    
    public CreateAccount(
            CreateAccountType accountType,
            CreateProfile profile) {
        this(accountType, profile, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public CreateAccountType accountType() {
        return accountType;
    }

    @JsonIgnore
    public CreateProfile profile() {
        return profile;
    }

    /**
     * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Map<String, String>> metadata() {
        return (Optional<Map<String, String>>) metadata;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateAccountTermsOfService> termsOfService() {
        return (Optional<CreateAccountTermsOfService>) termsOfService;
    }

    /**
     * Optional alias from a foreign/external system which can be used to reference this resource.
     */
    @JsonIgnore
    public Optional<String> foreignID() {
        return foreignID;
    }

    /**
     * User-provided information that can be displayed on credit card transactions for customers to use when
     * contacting a customer support team. This data is only allowed on a business account.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CustomerSupport> customerSupport() {
        return (Optional<CustomerSupport>) customerSupport;
    }

    /**
     * User provided settings to manage an account.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Settings> settings() {
        return (Optional<Settings>) settings;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<CapabilityID>> capabilities() {
        return (Optional<List<CapabilityID>>) capabilities;
    }

    /**
     * The operating mode for an account.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Mode> mode() {
        return (Optional<Mode>) mode;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public CreateAccount withAccountType(CreateAccountType accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = accountType;
        return this;
    }

    public CreateAccount withProfile(CreateProfile profile) {
        Utils.checkNotNull(profile, "profile");
        this.profile = profile;
        return this;
    }

    /**
     * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
     */
    public CreateAccount withMetadata(Map<String, String> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = Optional.ofNullable(metadata);
        return this;
    }

    /**
     * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
     */
    public CreateAccount withMetadata(Optional<? extends Map<String, String>> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }

    public CreateAccount withTermsOfService(CreateAccountTermsOfService termsOfService) {
        Utils.checkNotNull(termsOfService, "termsOfService");
        this.termsOfService = Optional.ofNullable(termsOfService);
        return this;
    }

    public CreateAccount withTermsOfService(Optional<? extends CreateAccountTermsOfService> termsOfService) {
        Utils.checkNotNull(termsOfService, "termsOfService");
        this.termsOfService = termsOfService;
        return this;
    }

    /**
     * Optional alias from a foreign/external system which can be used to reference this resource.
     */
    public CreateAccount withForeignID(String foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = Optional.ofNullable(foreignID);
        return this;
    }

    /**
     * Optional alias from a foreign/external system which can be used to reference this resource.
     */
    public CreateAccount withForeignID(Optional<String> foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = foreignID;
        return this;
    }

    /**
     * User-provided information that can be displayed on credit card transactions for customers to use when
     * contacting a customer support team. This data is only allowed on a business account.
     */
    public CreateAccount withCustomerSupport(CustomerSupport customerSupport) {
        Utils.checkNotNull(customerSupport, "customerSupport");
        this.customerSupport = Optional.ofNullable(customerSupport);
        return this;
    }

    /**
     * User-provided information that can be displayed on credit card transactions for customers to use when
     * contacting a customer support team. This data is only allowed on a business account.
     */
    public CreateAccount withCustomerSupport(Optional<? extends CustomerSupport> customerSupport) {
        Utils.checkNotNull(customerSupport, "customerSupport");
        this.customerSupport = customerSupport;
        return this;
    }

    /**
     * User provided settings to manage an account.
     */
    public CreateAccount withSettings(Settings settings) {
        Utils.checkNotNull(settings, "settings");
        this.settings = Optional.ofNullable(settings);
        return this;
    }

    /**
     * User provided settings to manage an account.
     */
    public CreateAccount withSettings(Optional<? extends Settings> settings) {
        Utils.checkNotNull(settings, "settings");
        this.settings = settings;
        return this;
    }

    public CreateAccount withCapabilities(List<CapabilityID> capabilities) {
        Utils.checkNotNull(capabilities, "capabilities");
        this.capabilities = Optional.ofNullable(capabilities);
        return this;
    }

    public CreateAccount withCapabilities(Optional<? extends List<CapabilityID>> capabilities) {
        Utils.checkNotNull(capabilities, "capabilities");
        this.capabilities = capabilities;
        return this;
    }

    /**
     * The operating mode for an account.
     */
    public CreateAccount withMode(Mode mode) {
        Utils.checkNotNull(mode, "mode");
        this.mode = Optional.ofNullable(mode);
        return this;
    }

    /**
     * The operating mode for an account.
     */
    public CreateAccount withMode(Optional<? extends Mode> mode) {
        Utils.checkNotNull(mode, "mode");
        this.mode = mode;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccount other = (CreateAccount) o;
        return 
            Objects.deepEquals(this.accountType, other.accountType) &&
            Objects.deepEquals(this.profile, other.profile) &&
            Objects.deepEquals(this.metadata, other.metadata) &&
            Objects.deepEquals(this.termsOfService, other.termsOfService) &&
            Objects.deepEquals(this.foreignID, other.foreignID) &&
            Objects.deepEquals(this.customerSupport, other.customerSupport) &&
            Objects.deepEquals(this.settings, other.settings) &&
            Objects.deepEquals(this.capabilities, other.capabilities) &&
            Objects.deepEquals(this.mode, other.mode);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            accountType,
            profile,
            metadata,
            termsOfService,
            foreignID,
            customerSupport,
            settings,
            capabilities,
            mode);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateAccount.class,
                "accountType", accountType,
                "profile", profile,
                "metadata", metadata,
                "termsOfService", termsOfService,
                "foreignID", foreignID,
                "customerSupport", customerSupport,
                "settings", settings,
                "capabilities", capabilities,
                "mode", mode);
    }
    
    public final static class Builder {
 
        private CreateAccountType accountType;
 
        private CreateProfile profile;
 
        private Optional<? extends Map<String, String>> metadata = Optional.empty();
 
        private Optional<? extends CreateAccountTermsOfService> termsOfService = Optional.empty();
 
        private Optional<String> foreignID = Optional.empty();
 
        private Optional<? extends CustomerSupport> customerSupport = Optional.empty();
 
        private Optional<? extends Settings> settings = Optional.empty();
 
        private Optional<? extends List<CapabilityID>> capabilities = Optional.empty();
 
        private Optional<? extends Mode> mode = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder accountType(CreateAccountType accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = accountType;
            return this;
        }

        public Builder profile(CreateProfile profile) {
            Utils.checkNotNull(profile, "profile");
            this.profile = profile;
            return this;
        }

        /**
         * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
         */
        public Builder metadata(Map<String, String> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        /**
         * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
         */
        public Builder metadata(Optional<? extends Map<String, String>> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }

        public Builder termsOfService(CreateAccountTermsOfService termsOfService) {
            Utils.checkNotNull(termsOfService, "termsOfService");
            this.termsOfService = Optional.ofNullable(termsOfService);
            return this;
        }

        public Builder termsOfService(Optional<? extends CreateAccountTermsOfService> termsOfService) {
            Utils.checkNotNull(termsOfService, "termsOfService");
            this.termsOfService = termsOfService;
            return this;
        }

        /**
         * Optional alias from a foreign/external system which can be used to reference this resource.
         */
        public Builder foreignID(String foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = Optional.ofNullable(foreignID);
            return this;
        }

        /**
         * Optional alias from a foreign/external system which can be used to reference this resource.
         */
        public Builder foreignID(Optional<String> foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = foreignID;
            return this;
        }

        /**
         * User-provided information that can be displayed on credit card transactions for customers to use when
         * contacting a customer support team. This data is only allowed on a business account.
         */
        public Builder customerSupport(CustomerSupport customerSupport) {
            Utils.checkNotNull(customerSupport, "customerSupport");
            this.customerSupport = Optional.ofNullable(customerSupport);
            return this;
        }

        /**
         * User-provided information that can be displayed on credit card transactions for customers to use when
         * contacting a customer support team. This data is only allowed on a business account.
         */
        public Builder customerSupport(Optional<? extends CustomerSupport> customerSupport) {
            Utils.checkNotNull(customerSupport, "customerSupport");
            this.customerSupport = customerSupport;
            return this;
        }

        /**
         * User provided settings to manage an account.
         */
        public Builder settings(Settings settings) {
            Utils.checkNotNull(settings, "settings");
            this.settings = Optional.ofNullable(settings);
            return this;
        }

        /**
         * User provided settings to manage an account.
         */
        public Builder settings(Optional<? extends Settings> settings) {
            Utils.checkNotNull(settings, "settings");
            this.settings = settings;
            return this;
        }

        public Builder capabilities(List<CapabilityID> capabilities) {
            Utils.checkNotNull(capabilities, "capabilities");
            this.capabilities = Optional.ofNullable(capabilities);
            return this;
        }

        public Builder capabilities(Optional<? extends List<CapabilityID>> capabilities) {
            Utils.checkNotNull(capabilities, "capabilities");
            this.capabilities = capabilities;
            return this;
        }

        /**
         * The operating mode for an account.
         */
        public Builder mode(Mode mode) {
            Utils.checkNotNull(mode, "mode");
            this.mode = Optional.ofNullable(mode);
            return this;
        }

        /**
         * The operating mode for an account.
         */
        public Builder mode(Optional<? extends Mode> mode) {
            Utils.checkNotNull(mode, "mode");
            this.mode = mode;
            return this;
        }
        
        public CreateAccount build() {
            return new CreateAccount(
                accountType,
                profile,
                metadata,
                termsOfService,
                foreignID,
                customerSupport,
                settings,
                capabilities,
                mode);
        }
    }
}
