/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * CompleteMicroDeposits
 * 
 * <p>Request to complete the micro-deposit verification workflow.
 */
public class CompleteMicroDeposits {

    /**
     * Two positive integers, in cents, equal to the values of the micro-deposits sent to the bank account.
     */
    @JsonProperty("amounts")
    private List<Long> amounts;

    @JsonCreator
    public CompleteMicroDeposits(
            @JsonProperty("amounts") List<Long> amounts) {
        Utils.checkNotNull(amounts, "amounts");
        this.amounts = amounts;
    }

    /**
     * Two positive integers, in cents, equal to the values of the micro-deposits sent to the bank account.
     */
    @JsonIgnore
    public List<Long> amounts() {
        return amounts;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Two positive integers, in cents, equal to the values of the micro-deposits sent to the bank account.
     */
    public CompleteMicroDeposits withAmounts(List<Long> amounts) {
        Utils.checkNotNull(amounts, "amounts");
        this.amounts = amounts;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompleteMicroDeposits other = (CompleteMicroDeposits) o;
        return 
            Objects.deepEquals(this.amounts, other.amounts);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            amounts);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CompleteMicroDeposits.class,
                "amounts", amounts);
    }
    
    public final static class Builder {
 
        private List<Long> amounts;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Two positive integers, in cents, equal to the values of the micro-deposits sent to the bank account.
         */
        public Builder amounts(List<Long> amounts) {
            Utils.checkNotNull(amounts, "amounts");
            this.amounts = amounts;
            return this;
        }
        
        public CompleteMicroDeposits build() {
            return new CompleteMicroDeposits(
                amounts);
        }
    }
}
