/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

/**
 * CardAccountUpdater
 * 
 * <p>The results of the most recent card update request.
 */
public class CardAccountUpdater {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updatedOn")
    private Optional<OffsetDateTime> updatedOn;

    /**
     * The results of the card update request.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updateType")
    private Optional<? extends CardUpdateReason> updateType;

    @JsonCreator
    public CardAccountUpdater(
            @JsonProperty("updatedOn") Optional<OffsetDateTime> updatedOn,
            @JsonProperty("updateType") Optional<? extends CardUpdateReason> updateType) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        Utils.checkNotNull(updateType, "updateType");
        this.updatedOn = updatedOn;
        this.updateType = updateType;
    }
    
    public CardAccountUpdater() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<OffsetDateTime> updatedOn() {
        return updatedOn;
    }

    /**
     * The results of the card update request.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardUpdateReason> updateType() {
        return (Optional<CardUpdateReason>) updateType;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public CardAccountUpdater withUpdatedOn(OffsetDateTime updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = Optional.ofNullable(updatedOn);
        return this;
    }

    public CardAccountUpdater withUpdatedOn(Optional<OffsetDateTime> updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = updatedOn;
        return this;
    }

    /**
     * The results of the card update request.
     */
    public CardAccountUpdater withUpdateType(CardUpdateReason updateType) {
        Utils.checkNotNull(updateType, "updateType");
        this.updateType = Optional.ofNullable(updateType);
        return this;
    }

    /**
     * The results of the card update request.
     */
    public CardAccountUpdater withUpdateType(Optional<? extends CardUpdateReason> updateType) {
        Utils.checkNotNull(updateType, "updateType");
        this.updateType = updateType;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CardAccountUpdater other = (CardAccountUpdater) o;
        return 
            Objects.deepEquals(this.updatedOn, other.updatedOn) &&
            Objects.deepEquals(this.updateType, other.updateType);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            updatedOn,
            updateType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CardAccountUpdater.class,
                "updatedOn", updatedOn,
                "updateType", updateType);
    }
    
    public final static class Builder {
 
        private Optional<OffsetDateTime> updatedOn = Optional.empty();
 
        private Optional<? extends CardUpdateReason> updateType = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder updatedOn(OffsetDateTime updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = Optional.ofNullable(updatedOn);
            return this;
        }

        public Builder updatedOn(Optional<OffsetDateTime> updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = updatedOn;
            return this;
        }

        /**
         * The results of the card update request.
         */
        public Builder updateType(CardUpdateReason updateType) {
            Utils.checkNotNull(updateType, "updateType");
            this.updateType = Optional.ofNullable(updateType);
            return this;
        }

        /**
         * The results of the card update request.
         */
        public Builder updateType(Optional<? extends CardUpdateReason> updateType) {
            Utils.checkNotNull(updateType, "updateType");
            this.updateType = updateType;
            return this;
        }
        
        public CardAccountUpdater build() {
            return new CardAccountUpdater(
                updatedOn,
                updateType);
        }
    }
}
