/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * Card
 * 
 * <p>Describes a card on a Moov account.
 */
public class Card {

    /**
     * ID of the card.
     */
    @JsonProperty("cardID")
    private String cardID;

    /**
     * Uniquely identifies a linked payment card or token.
     * For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
     * This field can be used to identify specific payment methods across multiple accounts on your platform.
     */
    @JsonProperty("fingerprint")
    private String fingerprint;

    /**
     * The card brand.
     */
    @JsonProperty("brand")
    private CardBrand brand;

    /**
     * The type of the card.
     */
    @JsonProperty("cardType")
    private CardType cardType;

    /**
     * The category or level of the card defined by the issuer.
     * Examples include, but not limited to, "REWARDS", "TRADITIONAL REWARDS", "CLASSIC", and "CORPORATE PURCHASING".
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardCategory")
    private Optional<String> cardCategory;

    /**
     * Last four digits of the card number
     */
    @JsonProperty("lastFourCardNumber")
    private String lastFourCardNumber;

    /**
     * The first six to eight digits of the card number, which identifies the financial institution that issued the card.
     */
    @JsonProperty("bin")
    private String bin;

    /**
     * The expiration date of the card or token.
     */
    @JsonProperty("expiration")
    private CardExpiration expiration;

    /**
     * The name of the cardholder as it appears on the card.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("holderName")
    private Optional<String> holderName;

    @JsonProperty("billingAddress")
    private CardAddress billingAddress;

    /**
     * The results of submitting cardholder data to a card network for verification.
     */
    @JsonProperty("cardVerification")
    private CardVerification cardVerification;

    /**
     * Financial institution that issued the card.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("issuer")
    private Optional<String> issuer;

    /**
     * Country where the card was issued.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("issuerCountry")
    private Optional<String> issuerCountry;

    /**
     * URL of the issuer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("issuerURL")
    private Optional<String> issuerURL;

    /**
     * Phone number of the issuer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("issuerPhone")
    private Optional<String> issuerPhone;

    /**
     * If true, the card is for commercial use, or associated with a business.
     * If false, the card is associated with a general consumer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("commercial")
    private Optional<Boolean> commercial;

    /**
     * If true, the card issuing bank is regulated, and the scheme fees for debit transactions will be limited based on the Durbin Amendment.
     * If false, the card issuing bank is not regulated, and the scheme fees will not be limited.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("regulated")
    private Optional<Boolean> regulated;

    /**
     * Indicates cardholder has authorized card to be stored for future payments.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardOnFile")
    private Optional<Boolean> cardOnFile;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("merchantAccountID")
    private Optional<String> merchantAccountID;

    /**
     * The results of the most recent card update request.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardAccountUpdater")
    private Optional<? extends CardAccountUpdater> cardAccountUpdater;

    /**
     * Indicates which level of domestic push-to-card transfer is supported by the card, if any.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("domesticPushToCard")
    private Optional<? extends DomesticPushToCard> domesticPushToCard;

    /**
     * Indicates if the card supports domestic pull-from-card transfer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("domesticPullFromCard")
    private Optional<? extends DomesticPullFromCard> domesticPullFromCard;

    /**
     * Includes any payment methods created as a result of linking a card with the `x-wait-for` header set to `payment-method`.
     * 
     * <p>  Only returned by the link card endpoint; not included when getting or listing cards.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("paymentMethods")
    private Optional<? extends List<BasicPaymentMethod>> paymentMethods;

    @JsonCreator
    public Card(
            @JsonProperty("cardID") String cardID,
            @JsonProperty("fingerprint") String fingerprint,
            @JsonProperty("brand") CardBrand brand,
            @JsonProperty("cardType") CardType cardType,
            @JsonProperty("cardCategory") Optional<String> cardCategory,
            @JsonProperty("lastFourCardNumber") String lastFourCardNumber,
            @JsonProperty("bin") String bin,
            @JsonProperty("expiration") CardExpiration expiration,
            @JsonProperty("holderName") Optional<String> holderName,
            @JsonProperty("billingAddress") CardAddress billingAddress,
            @JsonProperty("cardVerification") CardVerification cardVerification,
            @JsonProperty("issuer") Optional<String> issuer,
            @JsonProperty("issuerCountry") Optional<String> issuerCountry,
            @JsonProperty("issuerURL") Optional<String> issuerURL,
            @JsonProperty("issuerPhone") Optional<String> issuerPhone,
            @JsonProperty("commercial") Optional<Boolean> commercial,
            @JsonProperty("regulated") Optional<Boolean> regulated,
            @JsonProperty("cardOnFile") Optional<Boolean> cardOnFile,
            @JsonProperty("merchantAccountID") Optional<String> merchantAccountID,
            @JsonProperty("cardAccountUpdater") Optional<? extends CardAccountUpdater> cardAccountUpdater,
            @JsonProperty("domesticPushToCard") Optional<? extends DomesticPushToCard> domesticPushToCard,
            @JsonProperty("domesticPullFromCard") Optional<? extends DomesticPullFromCard> domesticPullFromCard,
            @JsonProperty("paymentMethods") Optional<? extends List<BasicPaymentMethod>> paymentMethods) {
        Utils.checkNotNull(cardID, "cardID");
        Utils.checkNotNull(fingerprint, "fingerprint");
        Utils.checkNotNull(brand, "brand");
        Utils.checkNotNull(cardType, "cardType");
        Utils.checkNotNull(cardCategory, "cardCategory");
        Utils.checkNotNull(lastFourCardNumber, "lastFourCardNumber");
        Utils.checkNotNull(bin, "bin");
        Utils.checkNotNull(expiration, "expiration");
        Utils.checkNotNull(holderName, "holderName");
        Utils.checkNotNull(billingAddress, "billingAddress");
        Utils.checkNotNull(cardVerification, "cardVerification");
        Utils.checkNotNull(issuer, "issuer");
        Utils.checkNotNull(issuerCountry, "issuerCountry");
        Utils.checkNotNull(issuerURL, "issuerURL");
        Utils.checkNotNull(issuerPhone, "issuerPhone");
        Utils.checkNotNull(commercial, "commercial");
        Utils.checkNotNull(regulated, "regulated");
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        Utils.checkNotNull(cardAccountUpdater, "cardAccountUpdater");
        Utils.checkNotNull(domesticPushToCard, "domesticPushToCard");
        Utils.checkNotNull(domesticPullFromCard, "domesticPullFromCard");
        Utils.checkNotNull(paymentMethods, "paymentMethods");
        this.cardID = cardID;
        this.fingerprint = fingerprint;
        this.brand = brand;
        this.cardType = cardType;
        this.cardCategory = cardCategory;
        this.lastFourCardNumber = lastFourCardNumber;
        this.bin = bin;
        this.expiration = expiration;
        this.holderName = holderName;
        this.billingAddress = billingAddress;
        this.cardVerification = cardVerification;
        this.issuer = issuer;
        this.issuerCountry = issuerCountry;
        this.issuerURL = issuerURL;
        this.issuerPhone = issuerPhone;
        this.commercial = commercial;
        this.regulated = regulated;
        this.cardOnFile = cardOnFile;
        this.merchantAccountID = merchantAccountID;
        this.cardAccountUpdater = cardAccountUpdater;
        this.domesticPushToCard = domesticPushToCard;
        this.domesticPullFromCard = domesticPullFromCard;
        this.paymentMethods = paymentMethods;
    }
    
    public Card(
            String cardID,
            String fingerprint,
            CardBrand brand,
            CardType cardType,
            String lastFourCardNumber,
            String bin,
            CardExpiration expiration,
            CardAddress billingAddress,
            CardVerification cardVerification) {
        this(cardID, fingerprint, brand, cardType, Optional.empty(), lastFourCardNumber, bin, expiration, Optional.empty(), billingAddress, cardVerification, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * ID of the card.
     */
    @JsonIgnore
    public String cardID() {
        return cardID;
    }

    /**
     * Uniquely identifies a linked payment card or token.
     * For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
     * This field can be used to identify specific payment methods across multiple accounts on your platform.
     */
    @JsonIgnore
    public String fingerprint() {
        return fingerprint;
    }

    /**
     * The card brand.
     */
    @JsonIgnore
    public CardBrand brand() {
        return brand;
    }

    /**
     * The type of the card.
     */
    @JsonIgnore
    public CardType cardType() {
        return cardType;
    }

    /**
     * The category or level of the card defined by the issuer.
     * Examples include, but not limited to, "REWARDS", "TRADITIONAL REWARDS", "CLASSIC", and "CORPORATE PURCHASING".
     */
    @JsonIgnore
    public Optional<String> cardCategory() {
        return cardCategory;
    }

    /**
     * Last four digits of the card number
     */
    @JsonIgnore
    public String lastFourCardNumber() {
        return lastFourCardNumber;
    }

    /**
     * The first six to eight digits of the card number, which identifies the financial institution that issued the card.
     */
    @JsonIgnore
    public String bin() {
        return bin;
    }

    /**
     * The expiration date of the card or token.
     */
    @JsonIgnore
    public CardExpiration expiration() {
        return expiration;
    }

    /**
     * The name of the cardholder as it appears on the card.
     */
    @JsonIgnore
    public Optional<String> holderName() {
        return holderName;
    }

    @JsonIgnore
    public CardAddress billingAddress() {
        return billingAddress;
    }

    /**
     * The results of submitting cardholder data to a card network for verification.
     */
    @JsonIgnore
    public CardVerification cardVerification() {
        return cardVerification;
    }

    /**
     * Financial institution that issued the card.
     */
    @JsonIgnore
    public Optional<String> issuer() {
        return issuer;
    }

    /**
     * Country where the card was issued.
     */
    @JsonIgnore
    public Optional<String> issuerCountry() {
        return issuerCountry;
    }

    /**
     * URL of the issuer.
     */
    @JsonIgnore
    public Optional<String> issuerURL() {
        return issuerURL;
    }

    /**
     * Phone number of the issuer.
     */
    @JsonIgnore
    public Optional<String> issuerPhone() {
        return issuerPhone;
    }

    /**
     * If true, the card is for commercial use, or associated with a business.
     * If false, the card is associated with a general consumer.
     */
    @JsonIgnore
    public Optional<Boolean> commercial() {
        return commercial;
    }

    /**
     * If true, the card issuing bank is regulated, and the scheme fees for debit transactions will be limited based on the Durbin Amendment.
     * If false, the card issuing bank is not regulated, and the scheme fees will not be limited.
     */
    @JsonIgnore
    public Optional<Boolean> regulated() {
        return regulated;
    }

    /**
     * Indicates cardholder has authorized card to be stored for future payments.
     */
    @JsonIgnore
    public Optional<Boolean> cardOnFile() {
        return cardOnFile;
    }

    @JsonIgnore
    public Optional<String> merchantAccountID() {
        return merchantAccountID;
    }

    /**
     * The results of the most recent card update request.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardAccountUpdater> cardAccountUpdater() {
        return (Optional<CardAccountUpdater>) cardAccountUpdater;
    }

    /**
     * Indicates which level of domestic push-to-card transfer is supported by the card, if any.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<DomesticPushToCard> domesticPushToCard() {
        return (Optional<DomesticPushToCard>) domesticPushToCard;
    }

    /**
     * Indicates if the card supports domestic pull-from-card transfer.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<DomesticPullFromCard> domesticPullFromCard() {
        return (Optional<DomesticPullFromCard>) domesticPullFromCard;
    }

    /**
     * Includes any payment methods created as a result of linking a card with the `x-wait-for` header set to `payment-method`.
     * 
     * <p>  Only returned by the link card endpoint; not included when getting or listing cards.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<BasicPaymentMethod>> paymentMethods() {
        return (Optional<List<BasicPaymentMethod>>) paymentMethods;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * ID of the card.
     */
    public Card withCardID(String cardID) {
        Utils.checkNotNull(cardID, "cardID");
        this.cardID = cardID;
        return this;
    }

    /**
     * Uniquely identifies a linked payment card or token.
     * For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
     * This field can be used to identify specific payment methods across multiple accounts on your platform.
     */
    public Card withFingerprint(String fingerprint) {
        Utils.checkNotNull(fingerprint, "fingerprint");
        this.fingerprint = fingerprint;
        return this;
    }

    /**
     * The card brand.
     */
    public Card withBrand(CardBrand brand) {
        Utils.checkNotNull(brand, "brand");
        this.brand = brand;
        return this;
    }

    /**
     * The type of the card.
     */
    public Card withCardType(CardType cardType) {
        Utils.checkNotNull(cardType, "cardType");
        this.cardType = cardType;
        return this;
    }

    /**
     * The category or level of the card defined by the issuer.
     * Examples include, but not limited to, "REWARDS", "TRADITIONAL REWARDS", "CLASSIC", and "CORPORATE PURCHASING".
     */
    public Card withCardCategory(String cardCategory) {
        Utils.checkNotNull(cardCategory, "cardCategory");
        this.cardCategory = Optional.ofNullable(cardCategory);
        return this;
    }

    /**
     * The category or level of the card defined by the issuer.
     * Examples include, but not limited to, "REWARDS", "TRADITIONAL REWARDS", "CLASSIC", and "CORPORATE PURCHASING".
     */
    public Card withCardCategory(Optional<String> cardCategory) {
        Utils.checkNotNull(cardCategory, "cardCategory");
        this.cardCategory = cardCategory;
        return this;
    }

    /**
     * Last four digits of the card number
     */
    public Card withLastFourCardNumber(String lastFourCardNumber) {
        Utils.checkNotNull(lastFourCardNumber, "lastFourCardNumber");
        this.lastFourCardNumber = lastFourCardNumber;
        return this;
    }

    /**
     * The first six to eight digits of the card number, which identifies the financial institution that issued the card.
     */
    public Card withBin(String bin) {
        Utils.checkNotNull(bin, "bin");
        this.bin = bin;
        return this;
    }

    /**
     * The expiration date of the card or token.
     */
    public Card withExpiration(CardExpiration expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = expiration;
        return this;
    }

    /**
     * The name of the cardholder as it appears on the card.
     */
    public Card withHolderName(String holderName) {
        Utils.checkNotNull(holderName, "holderName");
        this.holderName = Optional.ofNullable(holderName);
        return this;
    }

    /**
     * The name of the cardholder as it appears on the card.
     */
    public Card withHolderName(Optional<String> holderName) {
        Utils.checkNotNull(holderName, "holderName");
        this.holderName = holderName;
        return this;
    }

    public Card withBillingAddress(CardAddress billingAddress) {
        Utils.checkNotNull(billingAddress, "billingAddress");
        this.billingAddress = billingAddress;
        return this;
    }

    /**
     * The results of submitting cardholder data to a card network for verification.
     */
    public Card withCardVerification(CardVerification cardVerification) {
        Utils.checkNotNull(cardVerification, "cardVerification");
        this.cardVerification = cardVerification;
        return this;
    }

    /**
     * Financial institution that issued the card.
     */
    public Card withIssuer(String issuer) {
        Utils.checkNotNull(issuer, "issuer");
        this.issuer = Optional.ofNullable(issuer);
        return this;
    }

    /**
     * Financial institution that issued the card.
     */
    public Card withIssuer(Optional<String> issuer) {
        Utils.checkNotNull(issuer, "issuer");
        this.issuer = issuer;
        return this;
    }

    /**
     * Country where the card was issued.
     */
    public Card withIssuerCountry(String issuerCountry) {
        Utils.checkNotNull(issuerCountry, "issuerCountry");
        this.issuerCountry = Optional.ofNullable(issuerCountry);
        return this;
    }

    /**
     * Country where the card was issued.
     */
    public Card withIssuerCountry(Optional<String> issuerCountry) {
        Utils.checkNotNull(issuerCountry, "issuerCountry");
        this.issuerCountry = issuerCountry;
        return this;
    }

    /**
     * URL of the issuer.
     */
    public Card withIssuerURL(String issuerURL) {
        Utils.checkNotNull(issuerURL, "issuerURL");
        this.issuerURL = Optional.ofNullable(issuerURL);
        return this;
    }

    /**
     * URL of the issuer.
     */
    public Card withIssuerURL(Optional<String> issuerURL) {
        Utils.checkNotNull(issuerURL, "issuerURL");
        this.issuerURL = issuerURL;
        return this;
    }

    /**
     * Phone number of the issuer.
     */
    public Card withIssuerPhone(String issuerPhone) {
        Utils.checkNotNull(issuerPhone, "issuerPhone");
        this.issuerPhone = Optional.ofNullable(issuerPhone);
        return this;
    }

    /**
     * Phone number of the issuer.
     */
    public Card withIssuerPhone(Optional<String> issuerPhone) {
        Utils.checkNotNull(issuerPhone, "issuerPhone");
        this.issuerPhone = issuerPhone;
        return this;
    }

    /**
     * If true, the card is for commercial use, or associated with a business.
     * If false, the card is associated with a general consumer.
     */
    public Card withCommercial(boolean commercial) {
        Utils.checkNotNull(commercial, "commercial");
        this.commercial = Optional.ofNullable(commercial);
        return this;
    }

    /**
     * If true, the card is for commercial use, or associated with a business.
     * If false, the card is associated with a general consumer.
     */
    public Card withCommercial(Optional<Boolean> commercial) {
        Utils.checkNotNull(commercial, "commercial");
        this.commercial = commercial;
        return this;
    }

    /**
     * If true, the card issuing bank is regulated, and the scheme fees for debit transactions will be limited based on the Durbin Amendment.
     * If false, the card issuing bank is not regulated, and the scheme fees will not be limited.
     */
    public Card withRegulated(boolean regulated) {
        Utils.checkNotNull(regulated, "regulated");
        this.regulated = Optional.ofNullable(regulated);
        return this;
    }

    /**
     * If true, the card issuing bank is regulated, and the scheme fees for debit transactions will be limited based on the Durbin Amendment.
     * If false, the card issuing bank is not regulated, and the scheme fees will not be limited.
     */
    public Card withRegulated(Optional<Boolean> regulated) {
        Utils.checkNotNull(regulated, "regulated");
        this.regulated = regulated;
        return this;
    }

    /**
     * Indicates cardholder has authorized card to be stored for future payments.
     */
    public Card withCardOnFile(boolean cardOnFile) {
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        this.cardOnFile = Optional.ofNullable(cardOnFile);
        return this;
    }

    /**
     * Indicates cardholder has authorized card to be stored for future payments.
     */
    public Card withCardOnFile(Optional<Boolean> cardOnFile) {
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        this.cardOnFile = cardOnFile;
        return this;
    }

    public Card withMerchantAccountID(String merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = Optional.ofNullable(merchantAccountID);
        return this;
    }

    public Card withMerchantAccountID(Optional<String> merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = merchantAccountID;
        return this;
    }

    /**
     * The results of the most recent card update request.
     */
    public Card withCardAccountUpdater(CardAccountUpdater cardAccountUpdater) {
        Utils.checkNotNull(cardAccountUpdater, "cardAccountUpdater");
        this.cardAccountUpdater = Optional.ofNullable(cardAccountUpdater);
        return this;
    }

    /**
     * The results of the most recent card update request.
     */
    public Card withCardAccountUpdater(Optional<? extends CardAccountUpdater> cardAccountUpdater) {
        Utils.checkNotNull(cardAccountUpdater, "cardAccountUpdater");
        this.cardAccountUpdater = cardAccountUpdater;
        return this;
    }

    /**
     * Indicates which level of domestic push-to-card transfer is supported by the card, if any.
     */
    public Card withDomesticPushToCard(DomesticPushToCard domesticPushToCard) {
        Utils.checkNotNull(domesticPushToCard, "domesticPushToCard");
        this.domesticPushToCard = Optional.ofNullable(domesticPushToCard);
        return this;
    }

    /**
     * Indicates which level of domestic push-to-card transfer is supported by the card, if any.
     */
    public Card withDomesticPushToCard(Optional<? extends DomesticPushToCard> domesticPushToCard) {
        Utils.checkNotNull(domesticPushToCard, "domesticPushToCard");
        this.domesticPushToCard = domesticPushToCard;
        return this;
    }

    /**
     * Indicates if the card supports domestic pull-from-card transfer.
     */
    public Card withDomesticPullFromCard(DomesticPullFromCard domesticPullFromCard) {
        Utils.checkNotNull(domesticPullFromCard, "domesticPullFromCard");
        this.domesticPullFromCard = Optional.ofNullable(domesticPullFromCard);
        return this;
    }

    /**
     * Indicates if the card supports domestic pull-from-card transfer.
     */
    public Card withDomesticPullFromCard(Optional<? extends DomesticPullFromCard> domesticPullFromCard) {
        Utils.checkNotNull(domesticPullFromCard, "domesticPullFromCard");
        this.domesticPullFromCard = domesticPullFromCard;
        return this;
    }

    /**
     * Includes any payment methods created as a result of linking a card with the `x-wait-for` header set to `payment-method`.
     * 
     * <p>  Only returned by the link card endpoint; not included when getting or listing cards.
     */
    public Card withPaymentMethods(List<BasicPaymentMethod> paymentMethods) {
        Utils.checkNotNull(paymentMethods, "paymentMethods");
        this.paymentMethods = Optional.ofNullable(paymentMethods);
        return this;
    }

    /**
     * Includes any payment methods created as a result of linking a card with the `x-wait-for` header set to `payment-method`.
     * 
     * <p>  Only returned by the link card endpoint; not included when getting or listing cards.
     */
    public Card withPaymentMethods(Optional<? extends List<BasicPaymentMethod>> paymentMethods) {
        Utils.checkNotNull(paymentMethods, "paymentMethods");
        this.paymentMethods = paymentMethods;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Card other = (Card) o;
        return 
            Objects.deepEquals(this.cardID, other.cardID) &&
            Objects.deepEquals(this.fingerprint, other.fingerprint) &&
            Objects.deepEquals(this.brand, other.brand) &&
            Objects.deepEquals(this.cardType, other.cardType) &&
            Objects.deepEquals(this.cardCategory, other.cardCategory) &&
            Objects.deepEquals(this.lastFourCardNumber, other.lastFourCardNumber) &&
            Objects.deepEquals(this.bin, other.bin) &&
            Objects.deepEquals(this.expiration, other.expiration) &&
            Objects.deepEquals(this.holderName, other.holderName) &&
            Objects.deepEquals(this.billingAddress, other.billingAddress) &&
            Objects.deepEquals(this.cardVerification, other.cardVerification) &&
            Objects.deepEquals(this.issuer, other.issuer) &&
            Objects.deepEquals(this.issuerCountry, other.issuerCountry) &&
            Objects.deepEquals(this.issuerURL, other.issuerURL) &&
            Objects.deepEquals(this.issuerPhone, other.issuerPhone) &&
            Objects.deepEquals(this.commercial, other.commercial) &&
            Objects.deepEquals(this.regulated, other.regulated) &&
            Objects.deepEquals(this.cardOnFile, other.cardOnFile) &&
            Objects.deepEquals(this.merchantAccountID, other.merchantAccountID) &&
            Objects.deepEquals(this.cardAccountUpdater, other.cardAccountUpdater) &&
            Objects.deepEquals(this.domesticPushToCard, other.domesticPushToCard) &&
            Objects.deepEquals(this.domesticPullFromCard, other.domesticPullFromCard) &&
            Objects.deepEquals(this.paymentMethods, other.paymentMethods);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            cardID,
            fingerprint,
            brand,
            cardType,
            cardCategory,
            lastFourCardNumber,
            bin,
            expiration,
            holderName,
            billingAddress,
            cardVerification,
            issuer,
            issuerCountry,
            issuerURL,
            issuerPhone,
            commercial,
            regulated,
            cardOnFile,
            merchantAccountID,
            cardAccountUpdater,
            domesticPushToCard,
            domesticPullFromCard,
            paymentMethods);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Card.class,
                "cardID", cardID,
                "fingerprint", fingerprint,
                "brand", brand,
                "cardType", cardType,
                "cardCategory", cardCategory,
                "lastFourCardNumber", lastFourCardNumber,
                "bin", bin,
                "expiration", expiration,
                "holderName", holderName,
                "billingAddress", billingAddress,
                "cardVerification", cardVerification,
                "issuer", issuer,
                "issuerCountry", issuerCountry,
                "issuerURL", issuerURL,
                "issuerPhone", issuerPhone,
                "commercial", commercial,
                "regulated", regulated,
                "cardOnFile", cardOnFile,
                "merchantAccountID", merchantAccountID,
                "cardAccountUpdater", cardAccountUpdater,
                "domesticPushToCard", domesticPushToCard,
                "domesticPullFromCard", domesticPullFromCard,
                "paymentMethods", paymentMethods);
    }
    
    public final static class Builder {
 
        private String cardID;
 
        private String fingerprint;
 
        private CardBrand brand;
 
        private CardType cardType;
 
        private Optional<String> cardCategory = Optional.empty();
 
        private String lastFourCardNumber;
 
        private String bin;
 
        private CardExpiration expiration;
 
        private Optional<String> holderName = Optional.empty();
 
        private CardAddress billingAddress;
 
        private CardVerification cardVerification;
 
        private Optional<String> issuer = Optional.empty();
 
        private Optional<String> issuerCountry = Optional.empty();
 
        private Optional<String> issuerURL = Optional.empty();
 
        private Optional<String> issuerPhone = Optional.empty();
 
        private Optional<Boolean> commercial = Optional.empty();
 
        private Optional<Boolean> regulated = Optional.empty();
 
        private Optional<Boolean> cardOnFile = Optional.empty();
 
        private Optional<String> merchantAccountID = Optional.empty();
 
        private Optional<? extends CardAccountUpdater> cardAccountUpdater = Optional.empty();
 
        private Optional<? extends DomesticPushToCard> domesticPushToCard = Optional.empty();
 
        private Optional<? extends DomesticPullFromCard> domesticPullFromCard = Optional.empty();
 
        private Optional<? extends List<BasicPaymentMethod>> paymentMethods = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * ID of the card.
         */
        public Builder cardID(String cardID) {
            Utils.checkNotNull(cardID, "cardID");
            this.cardID = cardID;
            return this;
        }

        /**
         * Uniquely identifies a linked payment card or token.
         * For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
         * This field can be used to identify specific payment methods across multiple accounts on your platform.
         */
        public Builder fingerprint(String fingerprint) {
            Utils.checkNotNull(fingerprint, "fingerprint");
            this.fingerprint = fingerprint;
            return this;
        }

        /**
         * The card brand.
         */
        public Builder brand(CardBrand brand) {
            Utils.checkNotNull(brand, "brand");
            this.brand = brand;
            return this;
        }

        /**
         * The type of the card.
         */
        public Builder cardType(CardType cardType) {
            Utils.checkNotNull(cardType, "cardType");
            this.cardType = cardType;
            return this;
        }

        /**
         * The category or level of the card defined by the issuer.
         * Examples include, but not limited to, "REWARDS", "TRADITIONAL REWARDS", "CLASSIC", and "CORPORATE PURCHASING".
         */
        public Builder cardCategory(String cardCategory) {
            Utils.checkNotNull(cardCategory, "cardCategory");
            this.cardCategory = Optional.ofNullable(cardCategory);
            return this;
        }

        /**
         * The category or level of the card defined by the issuer.
         * Examples include, but not limited to, "REWARDS", "TRADITIONAL REWARDS", "CLASSIC", and "CORPORATE PURCHASING".
         */
        public Builder cardCategory(Optional<String> cardCategory) {
            Utils.checkNotNull(cardCategory, "cardCategory");
            this.cardCategory = cardCategory;
            return this;
        }

        /**
         * Last four digits of the card number
         */
        public Builder lastFourCardNumber(String lastFourCardNumber) {
            Utils.checkNotNull(lastFourCardNumber, "lastFourCardNumber");
            this.lastFourCardNumber = lastFourCardNumber;
            return this;
        }

        /**
         * The first six to eight digits of the card number, which identifies the financial institution that issued the card.
         */
        public Builder bin(String bin) {
            Utils.checkNotNull(bin, "bin");
            this.bin = bin;
            return this;
        }

        /**
         * The expiration date of the card or token.
         */
        public Builder expiration(CardExpiration expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = expiration;
            return this;
        }

        /**
         * The name of the cardholder as it appears on the card.
         */
        public Builder holderName(String holderName) {
            Utils.checkNotNull(holderName, "holderName");
            this.holderName = Optional.ofNullable(holderName);
            return this;
        }

        /**
         * The name of the cardholder as it appears on the card.
         */
        public Builder holderName(Optional<String> holderName) {
            Utils.checkNotNull(holderName, "holderName");
            this.holderName = holderName;
            return this;
        }

        public Builder billingAddress(CardAddress billingAddress) {
            Utils.checkNotNull(billingAddress, "billingAddress");
            this.billingAddress = billingAddress;
            return this;
        }

        /**
         * The results of submitting cardholder data to a card network for verification.
         */
        public Builder cardVerification(CardVerification cardVerification) {
            Utils.checkNotNull(cardVerification, "cardVerification");
            this.cardVerification = cardVerification;
            return this;
        }

        /**
         * Financial institution that issued the card.
         */
        public Builder issuer(String issuer) {
            Utils.checkNotNull(issuer, "issuer");
            this.issuer = Optional.ofNullable(issuer);
            return this;
        }

        /**
         * Financial institution that issued the card.
         */
        public Builder issuer(Optional<String> issuer) {
            Utils.checkNotNull(issuer, "issuer");
            this.issuer = issuer;
            return this;
        }

        /**
         * Country where the card was issued.
         */
        public Builder issuerCountry(String issuerCountry) {
            Utils.checkNotNull(issuerCountry, "issuerCountry");
            this.issuerCountry = Optional.ofNullable(issuerCountry);
            return this;
        }

        /**
         * Country where the card was issued.
         */
        public Builder issuerCountry(Optional<String> issuerCountry) {
            Utils.checkNotNull(issuerCountry, "issuerCountry");
            this.issuerCountry = issuerCountry;
            return this;
        }

        /**
         * URL of the issuer.
         */
        public Builder issuerURL(String issuerURL) {
            Utils.checkNotNull(issuerURL, "issuerURL");
            this.issuerURL = Optional.ofNullable(issuerURL);
            return this;
        }

        /**
         * URL of the issuer.
         */
        public Builder issuerURL(Optional<String> issuerURL) {
            Utils.checkNotNull(issuerURL, "issuerURL");
            this.issuerURL = issuerURL;
            return this;
        }

        /**
         * Phone number of the issuer.
         */
        public Builder issuerPhone(String issuerPhone) {
            Utils.checkNotNull(issuerPhone, "issuerPhone");
            this.issuerPhone = Optional.ofNullable(issuerPhone);
            return this;
        }

        /**
         * Phone number of the issuer.
         */
        public Builder issuerPhone(Optional<String> issuerPhone) {
            Utils.checkNotNull(issuerPhone, "issuerPhone");
            this.issuerPhone = issuerPhone;
            return this;
        }

        /**
         * If true, the card is for commercial use, or associated with a business.
         * If false, the card is associated with a general consumer.
         */
        public Builder commercial(boolean commercial) {
            Utils.checkNotNull(commercial, "commercial");
            this.commercial = Optional.ofNullable(commercial);
            return this;
        }

        /**
         * If true, the card is for commercial use, or associated with a business.
         * If false, the card is associated with a general consumer.
         */
        public Builder commercial(Optional<Boolean> commercial) {
            Utils.checkNotNull(commercial, "commercial");
            this.commercial = commercial;
            return this;
        }

        /**
         * If true, the card issuing bank is regulated, and the scheme fees for debit transactions will be limited based on the Durbin Amendment.
         * If false, the card issuing bank is not regulated, and the scheme fees will not be limited.
         */
        public Builder regulated(boolean regulated) {
            Utils.checkNotNull(regulated, "regulated");
            this.regulated = Optional.ofNullable(regulated);
            return this;
        }

        /**
         * If true, the card issuing bank is regulated, and the scheme fees for debit transactions will be limited based on the Durbin Amendment.
         * If false, the card issuing bank is not regulated, and the scheme fees will not be limited.
         */
        public Builder regulated(Optional<Boolean> regulated) {
            Utils.checkNotNull(regulated, "regulated");
            this.regulated = regulated;
            return this;
        }

        /**
         * Indicates cardholder has authorized card to be stored for future payments.
         */
        public Builder cardOnFile(boolean cardOnFile) {
            Utils.checkNotNull(cardOnFile, "cardOnFile");
            this.cardOnFile = Optional.ofNullable(cardOnFile);
            return this;
        }

        /**
         * Indicates cardholder has authorized card to be stored for future payments.
         */
        public Builder cardOnFile(Optional<Boolean> cardOnFile) {
            Utils.checkNotNull(cardOnFile, "cardOnFile");
            this.cardOnFile = cardOnFile;
            return this;
        }

        public Builder merchantAccountID(String merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = Optional.ofNullable(merchantAccountID);
            return this;
        }

        public Builder merchantAccountID(Optional<String> merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = merchantAccountID;
            return this;
        }

        /**
         * The results of the most recent card update request.
         */
        public Builder cardAccountUpdater(CardAccountUpdater cardAccountUpdater) {
            Utils.checkNotNull(cardAccountUpdater, "cardAccountUpdater");
            this.cardAccountUpdater = Optional.ofNullable(cardAccountUpdater);
            return this;
        }

        /**
         * The results of the most recent card update request.
         */
        public Builder cardAccountUpdater(Optional<? extends CardAccountUpdater> cardAccountUpdater) {
            Utils.checkNotNull(cardAccountUpdater, "cardAccountUpdater");
            this.cardAccountUpdater = cardAccountUpdater;
            return this;
        }

        /**
         * Indicates which level of domestic push-to-card transfer is supported by the card, if any.
         */
        public Builder domesticPushToCard(DomesticPushToCard domesticPushToCard) {
            Utils.checkNotNull(domesticPushToCard, "domesticPushToCard");
            this.domesticPushToCard = Optional.ofNullable(domesticPushToCard);
            return this;
        }

        /**
         * Indicates which level of domestic push-to-card transfer is supported by the card, if any.
         */
        public Builder domesticPushToCard(Optional<? extends DomesticPushToCard> domesticPushToCard) {
            Utils.checkNotNull(domesticPushToCard, "domesticPushToCard");
            this.domesticPushToCard = domesticPushToCard;
            return this;
        }

        /**
         * Indicates if the card supports domestic pull-from-card transfer.
         */
        public Builder domesticPullFromCard(DomesticPullFromCard domesticPullFromCard) {
            Utils.checkNotNull(domesticPullFromCard, "domesticPullFromCard");
            this.domesticPullFromCard = Optional.ofNullable(domesticPullFromCard);
            return this;
        }

        /**
         * Indicates if the card supports domestic pull-from-card transfer.
         */
        public Builder domesticPullFromCard(Optional<? extends DomesticPullFromCard> domesticPullFromCard) {
            Utils.checkNotNull(domesticPullFromCard, "domesticPullFromCard");
            this.domesticPullFromCard = domesticPullFromCard;
            return this;
        }

        /**
         * Includes any payment methods created as a result of linking a card with the `x-wait-for` header set to `payment-method`.
         * 
         * <p>  Only returned by the link card endpoint; not included when getting or listing cards.
         */
        public Builder paymentMethods(List<BasicPaymentMethod> paymentMethods) {
            Utils.checkNotNull(paymentMethods, "paymentMethods");
            this.paymentMethods = Optional.ofNullable(paymentMethods);
            return this;
        }

        /**
         * Includes any payment methods created as a result of linking a card with the `x-wait-for` header set to `payment-method`.
         * 
         * <p>  Only returned by the link card endpoint; not included when getting or listing cards.
         */
        public Builder paymentMethods(Optional<? extends List<BasicPaymentMethod>> paymentMethods) {
            Utils.checkNotNull(paymentMethods, "paymentMethods");
            this.paymentMethods = paymentMethods;
            return this;
        }
        
        public Card build() {
            return new Card(
                cardID,
                fingerprint,
                brand,
                cardType,
                cardCategory,
                lastFourCardNumber,
                bin,
                expiration,
                holderName,
                billingAddress,
                cardVerification,
                issuer,
                issuerCountry,
                issuerURL,
                issuerPhone,
                commercial,
                regulated,
                cardOnFile,
                merchantAccountID,
                cardAccountUpdater,
                domesticPushToCard,
                domesticPullFromCard,
                paymentMethods);
        }
    }
}
