/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * CapabilityRequirement
 * 
 * <p>Represents individual and business data necessary to facilitate the enabling of a capability for an account.
 */
public class CapabilityRequirement {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("currentlyDue")
    private Optional<? extends List<RequirementID>> currentlyDue;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("errors")
    private Optional<? extends List<RequirementError>> errors;

    @JsonCreator
    public CapabilityRequirement(
            @JsonProperty("currentlyDue") Optional<? extends List<RequirementID>> currentlyDue,
            @JsonProperty("errors") Optional<? extends List<RequirementError>> errors) {
        Utils.checkNotNull(currentlyDue, "currentlyDue");
        Utils.checkNotNull(errors, "errors");
        this.currentlyDue = currentlyDue;
        this.errors = errors;
    }
    
    public CapabilityRequirement() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<RequirementID>> currentlyDue() {
        return (Optional<List<RequirementID>>) currentlyDue;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<RequirementError>> errors() {
        return (Optional<List<RequirementError>>) errors;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public CapabilityRequirement withCurrentlyDue(List<RequirementID> currentlyDue) {
        Utils.checkNotNull(currentlyDue, "currentlyDue");
        this.currentlyDue = Optional.ofNullable(currentlyDue);
        return this;
    }

    public CapabilityRequirement withCurrentlyDue(Optional<? extends List<RequirementID>> currentlyDue) {
        Utils.checkNotNull(currentlyDue, "currentlyDue");
        this.currentlyDue = currentlyDue;
        return this;
    }

    public CapabilityRequirement withErrors(List<RequirementError> errors) {
        Utils.checkNotNull(errors, "errors");
        this.errors = Optional.ofNullable(errors);
        return this;
    }

    public CapabilityRequirement withErrors(Optional<? extends List<RequirementError>> errors) {
        Utils.checkNotNull(errors, "errors");
        this.errors = errors;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CapabilityRequirement other = (CapabilityRequirement) o;
        return 
            Objects.deepEquals(this.currentlyDue, other.currentlyDue) &&
            Objects.deepEquals(this.errors, other.errors);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            currentlyDue,
            errors);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CapabilityRequirement.class,
                "currentlyDue", currentlyDue,
                "errors", errors);
    }
    
    public final static class Builder {
 
        private Optional<? extends List<RequirementID>> currentlyDue = Optional.empty();
 
        private Optional<? extends List<RequirementError>> errors = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder currentlyDue(List<RequirementID> currentlyDue) {
            Utils.checkNotNull(currentlyDue, "currentlyDue");
            this.currentlyDue = Optional.ofNullable(currentlyDue);
            return this;
        }

        public Builder currentlyDue(Optional<? extends List<RequirementID>> currentlyDue) {
            Utils.checkNotNull(currentlyDue, "currentlyDue");
            this.currentlyDue = currentlyDue;
            return this;
        }

        public Builder errors(List<RequirementError> errors) {
            Utils.checkNotNull(errors, "errors");
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public Builder errors(Optional<? extends List<RequirementError>> errors) {
            Utils.checkNotNull(errors, "errors");
            this.errors = errors;
            return this;
        }
        
        public CapabilityRequirement build() {
            return new CapabilityRequirement(
                currentlyDue,
                errors);
        }
    }
}
