/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

public class Capability {

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app` capability might appear in your list. This is a read-only capability that Moov requests and uses for account verification purposes. The capability remains active with your account and requires no additional action.
     */
    @JsonProperty("capability")
    private CapabilityID capability;

    @JsonProperty("accountID")
    private String accountID;

    /**
     * The status of the capability requested for an account.
     */
    @JsonProperty("status")
    private CapabilityStatus status;

    /**
     * Represents individual and business data necessary to facilitate the enabling of a capability for an account.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("requirements")
    private Optional<? extends CapabilityRequirement> requirements;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("disabledReason")
    private Optional<String> disabledReason;

    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonProperty("updatedOn")
    private OffsetDateTime updatedOn;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("disabledOn")
    private Optional<OffsetDateTime> disabledOn;

    @JsonCreator
    public Capability(
            @JsonProperty("capability") CapabilityID capability,
            @JsonProperty("accountID") String accountID,
            @JsonProperty("status") CapabilityStatus status,
            @JsonProperty("requirements") Optional<? extends CapabilityRequirement> requirements,
            @JsonProperty("disabledReason") Optional<String> disabledReason,
            @JsonProperty("createdOn") OffsetDateTime createdOn,
            @JsonProperty("updatedOn") OffsetDateTime updatedOn,
            @JsonProperty("disabledOn") Optional<OffsetDateTime> disabledOn) {
        Utils.checkNotNull(capability, "capability");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(requirements, "requirements");
        Utils.checkNotNull(disabledReason, "disabledReason");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(updatedOn, "updatedOn");
        Utils.checkNotNull(disabledOn, "disabledOn");
        this.capability = capability;
        this.accountID = accountID;
        this.status = status;
        this.requirements = requirements;
        this.disabledReason = disabledReason;
        this.createdOn = createdOn;
        this.updatedOn = updatedOn;
        this.disabledOn = disabledOn;
    }
    
    public Capability(
            CapabilityID capability,
            String accountID,
            CapabilityStatus status,
            OffsetDateTime createdOn,
            OffsetDateTime updatedOn) {
        this(capability, accountID, status, Optional.empty(), Optional.empty(), createdOn, updatedOn, Optional.empty());
    }

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app` capability might appear in your list. This is a read-only capability that Moov requests and uses for account verification purposes. The capability remains active with your account and requires no additional action.
     */
    @JsonIgnore
    public CapabilityID capability() {
        return capability;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * The status of the capability requested for an account.
     */
    @JsonIgnore
    public CapabilityStatus status() {
        return status;
    }

    /**
     * Represents individual and business data necessary to facilitate the enabling of a capability for an account.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CapabilityRequirement> requirements() {
        return (Optional<CapabilityRequirement>) requirements;
    }

    @JsonIgnore
    public Optional<String> disabledReason() {
        return disabledReason;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    @JsonIgnore
    public OffsetDateTime updatedOn() {
        return updatedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> disabledOn() {
        return disabledOn;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app` capability might appear in your list. This is a read-only capability that Moov requests and uses for account verification purposes. The capability remains active with your account and requires no additional action.
     */
    public Capability withCapability(CapabilityID capability) {
        Utils.checkNotNull(capability, "capability");
        this.capability = capability;
        return this;
    }

    public Capability withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * The status of the capability requested for an account.
     */
    public Capability withStatus(CapabilityStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Represents individual and business data necessary to facilitate the enabling of a capability for an account.
     */
    public Capability withRequirements(CapabilityRequirement requirements) {
        Utils.checkNotNull(requirements, "requirements");
        this.requirements = Optional.ofNullable(requirements);
        return this;
    }

    /**
     * Represents individual and business data necessary to facilitate the enabling of a capability for an account.
     */
    public Capability withRequirements(Optional<? extends CapabilityRequirement> requirements) {
        Utils.checkNotNull(requirements, "requirements");
        this.requirements = requirements;
        return this;
    }

    public Capability withDisabledReason(String disabledReason) {
        Utils.checkNotNull(disabledReason, "disabledReason");
        this.disabledReason = Optional.ofNullable(disabledReason);
        return this;
    }

    public Capability withDisabledReason(Optional<String> disabledReason) {
        Utils.checkNotNull(disabledReason, "disabledReason");
        this.disabledReason = disabledReason;
        return this;
    }

    public Capability withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    public Capability withUpdatedOn(OffsetDateTime updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = updatedOn;
        return this;
    }

    public Capability withDisabledOn(OffsetDateTime disabledOn) {
        Utils.checkNotNull(disabledOn, "disabledOn");
        this.disabledOn = Optional.ofNullable(disabledOn);
        return this;
    }

    public Capability withDisabledOn(Optional<OffsetDateTime> disabledOn) {
        Utils.checkNotNull(disabledOn, "disabledOn");
        this.disabledOn = disabledOn;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Capability other = (Capability) o;
        return 
            Objects.deepEquals(this.capability, other.capability) &&
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.requirements, other.requirements) &&
            Objects.deepEquals(this.disabledReason, other.disabledReason) &&
            Objects.deepEquals(this.createdOn, other.createdOn) &&
            Objects.deepEquals(this.updatedOn, other.updatedOn) &&
            Objects.deepEquals(this.disabledOn, other.disabledOn);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            capability,
            accountID,
            status,
            requirements,
            disabledReason,
            createdOn,
            updatedOn,
            disabledOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Capability.class,
                "capability", capability,
                "accountID", accountID,
                "status", status,
                "requirements", requirements,
                "disabledReason", disabledReason,
                "createdOn", createdOn,
                "updatedOn", updatedOn,
                "disabledOn", disabledOn);
    }
    
    public final static class Builder {
 
        private CapabilityID capability;
 
        private String accountID;
 
        private CapabilityStatus status;
 
        private Optional<? extends CapabilityRequirement> requirements = Optional.empty();
 
        private Optional<String> disabledReason = Optional.empty();
 
        private OffsetDateTime createdOn;
 
        private OffsetDateTime updatedOn;
 
        private Optional<OffsetDateTime> disabledOn = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Moov account capabilities.
         * 
         * <p>The `production-app` capability might appear in your list. This is a read-only capability that Moov requests and uses for account verification purposes. The capability remains active with your account and requires no additional action.
         */
        public Builder capability(CapabilityID capability) {
            Utils.checkNotNull(capability, "capability");
            this.capability = capability;
            return this;
        }

        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        /**
         * The status of the capability requested for an account.
         */
        public Builder status(CapabilityStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * Represents individual and business data necessary to facilitate the enabling of a capability for an account.
         */
        public Builder requirements(CapabilityRequirement requirements) {
            Utils.checkNotNull(requirements, "requirements");
            this.requirements = Optional.ofNullable(requirements);
            return this;
        }

        /**
         * Represents individual and business data necessary to facilitate the enabling of a capability for an account.
         */
        public Builder requirements(Optional<? extends CapabilityRequirement> requirements) {
            Utils.checkNotNull(requirements, "requirements");
            this.requirements = requirements;
            return this;
        }

        public Builder disabledReason(String disabledReason) {
            Utils.checkNotNull(disabledReason, "disabledReason");
            this.disabledReason = Optional.ofNullable(disabledReason);
            return this;
        }

        public Builder disabledReason(Optional<String> disabledReason) {
            Utils.checkNotNull(disabledReason, "disabledReason");
            this.disabledReason = disabledReason;
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }

        public Builder updatedOn(OffsetDateTime updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = updatedOn;
            return this;
        }

        public Builder disabledOn(OffsetDateTime disabledOn) {
            Utils.checkNotNull(disabledOn, "disabledOn");
            this.disabledOn = Optional.ofNullable(disabledOn);
            return this;
        }

        public Builder disabledOn(Optional<OffsetDateTime> disabledOn) {
            Utils.checkNotNull(disabledOn, "disabledOn");
            this.disabledOn = disabledOn;
            return this;
        }
        
        public Capability build() {
            return new Capability(
                capability,
                accountID,
                status,
                requirements,
                disabledReason,
                createdOn,
                updatedOn,
                disabledOn);
        }
    }
}
