/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class Cancellation {

    @JsonProperty("cancellationID")
    private String cancellationID;

    @JsonProperty("status")
    private CancellationStatus status;

    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonCreator
    public Cancellation(
            @JsonProperty("cancellationID") String cancellationID,
            @JsonProperty("status") CancellationStatus status,
            @JsonProperty("createdOn") OffsetDateTime createdOn) {
        Utils.checkNotNull(cancellationID, "cancellationID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(createdOn, "createdOn");
        this.cancellationID = cancellationID;
        this.status = status;
        this.createdOn = createdOn;
    }

    @JsonIgnore
    public String cancellationID() {
        return cancellationID;
    }

    @JsonIgnore
    public CancellationStatus status() {
        return status;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public Cancellation withCancellationID(String cancellationID) {
        Utils.checkNotNull(cancellationID, "cancellationID");
        this.cancellationID = cancellationID;
        return this;
    }

    public Cancellation withStatus(CancellationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Cancellation withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Cancellation other = (Cancellation) o;
        return 
            Objects.deepEquals(this.cancellationID, other.cancellationID) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.createdOn, other.createdOn);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            cancellationID,
            status,
            createdOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Cancellation.class,
                "cancellationID", cancellationID,
                "status", status,
                "createdOn", createdOn);
    }
    
    public final static class Builder {
 
        private String cancellationID;
 
        private CancellationStatus status;
 
        private OffsetDateTime createdOn;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder cancellationID(String cancellationID) {
            Utils.checkNotNull(cancellationID, "cancellationID");
            this.cancellationID = cancellationID;
            return this;
        }

        public Builder status(CancellationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }
        
        public Cancellation build() {
            return new Cancellation(
                cancellationID,
                status,
                createdOn);
        }
    }
}
