/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class BirthDate {

    @JsonProperty("day")
    private long day;

    @JsonProperty("month")
    private long month;

    @JsonProperty("year")
    private long year;

    @JsonCreator
    public BirthDate(
            @JsonProperty("day") long day,
            @JsonProperty("month") long month,
            @JsonProperty("year") long year) {
        Utils.checkNotNull(day, "day");
        Utils.checkNotNull(month, "month");
        Utils.checkNotNull(year, "year");
        this.day = day;
        this.month = month;
        this.year = year;
    }

    @JsonIgnore
    public long day() {
        return day;
    }

    @JsonIgnore
    public long month() {
        return month;
    }

    @JsonIgnore
    public long year() {
        return year;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public BirthDate withDay(long day) {
        Utils.checkNotNull(day, "day");
        this.day = day;
        return this;
    }

    public BirthDate withMonth(long month) {
        Utils.checkNotNull(month, "month");
        this.month = month;
        return this;
    }

    public BirthDate withYear(long year) {
        Utils.checkNotNull(year, "year");
        this.year = year;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BirthDate other = (BirthDate) o;
        return 
            Objects.deepEquals(this.day, other.day) &&
            Objects.deepEquals(this.month, other.month) &&
            Objects.deepEquals(this.year, other.year);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            day,
            month,
            year);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BirthDate.class,
                "day", day,
                "month", month,
                "year", year);
    }
    
    public final static class Builder {
 
        private Long day;
 
        private Long month;
 
        private Long year;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder day(long day) {
            Utils.checkNotNull(day, "day");
            this.day = day;
            return this;
        }

        public Builder month(long month) {
            Utils.checkNotNull(month, "month");
            this.month = month;
            return this;
        }

        public Builder year(long year) {
            Utils.checkNotNull(year, "year");
            this.year = year;
            return this;
        }
        
        public BirthDate build() {
            return new BirthDate(
                day,
                month,
                year);
        }
    }
}
