/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BillableFee {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("billableFeeID")
    private Optional<String> billableFeeID;

    /**
     * A unique code identifying a charge.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("billableEvent")
    private Optional<String> billableEvent;

    /**
     * Specifies the name of the fee that will be billed.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("feeName")
    private Optional<String> feeName;

    /**
     * Specifies the pricing model used for the calculation of the final fee.
     */
    @JsonProperty("feeModel")
    private FeeModel feeModel;

    @JsonProperty("feeCategory")
    private FeeCategory feeCategory;

    /**
     * Defines the specific parameters used for fee calculation.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("feeProperties")
    private Optional<? extends FeeProperties> feeProperties;

    /**
     * Defines the specific conditions that must be met for the fee to be applied.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("feeConditions")
    private Optional<? extends Map<String, Object>> feeConditions;

    @JsonCreator
    public BillableFee(
            @JsonProperty("billableFeeID") Optional<String> billableFeeID,
            @JsonProperty("billableEvent") Optional<String> billableEvent,
            @JsonProperty("feeName") Optional<String> feeName,
            @JsonProperty("feeModel") FeeModel feeModel,
            @JsonProperty("feeCategory") FeeCategory feeCategory,
            @JsonProperty("feeProperties") Optional<? extends FeeProperties> feeProperties,
            @JsonProperty("feeConditions") Optional<? extends Map<String, Object>> feeConditions) {
        Utils.checkNotNull(billableFeeID, "billableFeeID");
        Utils.checkNotNull(billableEvent, "billableEvent");
        Utils.checkNotNull(feeName, "feeName");
        Utils.checkNotNull(feeModel, "feeModel");
        Utils.checkNotNull(feeCategory, "feeCategory");
        Utils.checkNotNull(feeProperties, "feeProperties");
        Utils.checkNotNull(feeConditions, "feeConditions");
        this.billableFeeID = billableFeeID;
        this.billableEvent = billableEvent;
        this.feeName = feeName;
        this.feeModel = feeModel;
        this.feeCategory = feeCategory;
        this.feeProperties = feeProperties;
        this.feeConditions = feeConditions;
    }
    
    public BillableFee(
            FeeModel feeModel,
            FeeCategory feeCategory) {
        this(Optional.empty(), Optional.empty(), Optional.empty(), feeModel, feeCategory, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> billableFeeID() {
        return billableFeeID;
    }

    /**
     * A unique code identifying a charge.
     */
    @JsonIgnore
    public Optional<String> billableEvent() {
        return billableEvent;
    }

    /**
     * Specifies the name of the fee that will be billed.
     */
    @JsonIgnore
    public Optional<String> feeName() {
        return feeName;
    }

    /**
     * Specifies the pricing model used for the calculation of the final fee.
     */
    @JsonIgnore
    public FeeModel feeModel() {
        return feeModel;
    }

    @JsonIgnore
    public FeeCategory feeCategory() {
        return feeCategory;
    }

    /**
     * Defines the specific parameters used for fee calculation.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<FeeProperties> feeProperties() {
        return (Optional<FeeProperties>) feeProperties;
    }

    /**
     * Defines the specific conditions that must be met for the fee to be applied.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Map<String, Object>> feeConditions() {
        return (Optional<Map<String, Object>>) feeConditions;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public BillableFee withBillableFeeID(String billableFeeID) {
        Utils.checkNotNull(billableFeeID, "billableFeeID");
        this.billableFeeID = Optional.ofNullable(billableFeeID);
        return this;
    }

    public BillableFee withBillableFeeID(Optional<String> billableFeeID) {
        Utils.checkNotNull(billableFeeID, "billableFeeID");
        this.billableFeeID = billableFeeID;
        return this;
    }

    /**
     * A unique code identifying a charge.
     */
    public BillableFee withBillableEvent(String billableEvent) {
        Utils.checkNotNull(billableEvent, "billableEvent");
        this.billableEvent = Optional.ofNullable(billableEvent);
        return this;
    }

    /**
     * A unique code identifying a charge.
     */
    public BillableFee withBillableEvent(Optional<String> billableEvent) {
        Utils.checkNotNull(billableEvent, "billableEvent");
        this.billableEvent = billableEvent;
        return this;
    }

    /**
     * Specifies the name of the fee that will be billed.
     */
    public BillableFee withFeeName(String feeName) {
        Utils.checkNotNull(feeName, "feeName");
        this.feeName = Optional.ofNullable(feeName);
        return this;
    }

    /**
     * Specifies the name of the fee that will be billed.
     */
    public BillableFee withFeeName(Optional<String> feeName) {
        Utils.checkNotNull(feeName, "feeName");
        this.feeName = feeName;
        return this;
    }

    /**
     * Specifies the pricing model used for the calculation of the final fee.
     */
    public BillableFee withFeeModel(FeeModel feeModel) {
        Utils.checkNotNull(feeModel, "feeModel");
        this.feeModel = feeModel;
        return this;
    }

    public BillableFee withFeeCategory(FeeCategory feeCategory) {
        Utils.checkNotNull(feeCategory, "feeCategory");
        this.feeCategory = feeCategory;
        return this;
    }

    /**
     * Defines the specific parameters used for fee calculation.
     */
    public BillableFee withFeeProperties(FeeProperties feeProperties) {
        Utils.checkNotNull(feeProperties, "feeProperties");
        this.feeProperties = Optional.ofNullable(feeProperties);
        return this;
    }

    /**
     * Defines the specific parameters used for fee calculation.
     */
    public BillableFee withFeeProperties(Optional<? extends FeeProperties> feeProperties) {
        Utils.checkNotNull(feeProperties, "feeProperties");
        this.feeProperties = feeProperties;
        return this;
    }

    /**
     * Defines the specific conditions that must be met for the fee to be applied.
     */
    public BillableFee withFeeConditions(Map<String, Object> feeConditions) {
        Utils.checkNotNull(feeConditions, "feeConditions");
        this.feeConditions = Optional.ofNullable(feeConditions);
        return this;
    }

    /**
     * Defines the specific conditions that must be met for the fee to be applied.
     */
    public BillableFee withFeeConditions(Optional<? extends Map<String, Object>> feeConditions) {
        Utils.checkNotNull(feeConditions, "feeConditions");
        this.feeConditions = feeConditions;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BillableFee other = (BillableFee) o;
        return 
            Objects.deepEquals(this.billableFeeID, other.billableFeeID) &&
            Objects.deepEquals(this.billableEvent, other.billableEvent) &&
            Objects.deepEquals(this.feeName, other.feeName) &&
            Objects.deepEquals(this.feeModel, other.feeModel) &&
            Objects.deepEquals(this.feeCategory, other.feeCategory) &&
            Objects.deepEquals(this.feeProperties, other.feeProperties) &&
            Objects.deepEquals(this.feeConditions, other.feeConditions);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            billableFeeID,
            billableEvent,
            feeName,
            feeModel,
            feeCategory,
            feeProperties,
            feeConditions);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BillableFee.class,
                "billableFeeID", billableFeeID,
                "billableEvent", billableEvent,
                "feeName", feeName,
                "feeModel", feeModel,
                "feeCategory", feeCategory,
                "feeProperties", feeProperties,
                "feeConditions", feeConditions);
    }
    
    public final static class Builder {
 
        private Optional<String> billableFeeID = Optional.empty();
 
        private Optional<String> billableEvent = Optional.empty();
 
        private Optional<String> feeName = Optional.empty();
 
        private FeeModel feeModel;
 
        private FeeCategory feeCategory;
 
        private Optional<? extends FeeProperties> feeProperties = Optional.empty();
 
        private Optional<? extends Map<String, Object>> feeConditions = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder billableFeeID(String billableFeeID) {
            Utils.checkNotNull(billableFeeID, "billableFeeID");
            this.billableFeeID = Optional.ofNullable(billableFeeID);
            return this;
        }

        public Builder billableFeeID(Optional<String> billableFeeID) {
            Utils.checkNotNull(billableFeeID, "billableFeeID");
            this.billableFeeID = billableFeeID;
            return this;
        }

        /**
         * A unique code identifying a charge.
         */
        public Builder billableEvent(String billableEvent) {
            Utils.checkNotNull(billableEvent, "billableEvent");
            this.billableEvent = Optional.ofNullable(billableEvent);
            return this;
        }

        /**
         * A unique code identifying a charge.
         */
        public Builder billableEvent(Optional<String> billableEvent) {
            Utils.checkNotNull(billableEvent, "billableEvent");
            this.billableEvent = billableEvent;
            return this;
        }

        /**
         * Specifies the name of the fee that will be billed.
         */
        public Builder feeName(String feeName) {
            Utils.checkNotNull(feeName, "feeName");
            this.feeName = Optional.ofNullable(feeName);
            return this;
        }

        /**
         * Specifies the name of the fee that will be billed.
         */
        public Builder feeName(Optional<String> feeName) {
            Utils.checkNotNull(feeName, "feeName");
            this.feeName = feeName;
            return this;
        }

        /**
         * Specifies the pricing model used for the calculation of the final fee.
         */
        public Builder feeModel(FeeModel feeModel) {
            Utils.checkNotNull(feeModel, "feeModel");
            this.feeModel = feeModel;
            return this;
        }

        public Builder feeCategory(FeeCategory feeCategory) {
            Utils.checkNotNull(feeCategory, "feeCategory");
            this.feeCategory = feeCategory;
            return this;
        }

        /**
         * Defines the specific parameters used for fee calculation.
         */
        public Builder feeProperties(FeeProperties feeProperties) {
            Utils.checkNotNull(feeProperties, "feeProperties");
            this.feeProperties = Optional.ofNullable(feeProperties);
            return this;
        }

        /**
         * Defines the specific parameters used for fee calculation.
         */
        public Builder feeProperties(Optional<? extends FeeProperties> feeProperties) {
            Utils.checkNotNull(feeProperties, "feeProperties");
            this.feeProperties = feeProperties;
            return this;
        }

        /**
         * Defines the specific conditions that must be met for the fee to be applied.
         */
        public Builder feeConditions(Map<String, Object> feeConditions) {
            Utils.checkNotNull(feeConditions, "feeConditions");
            this.feeConditions = Optional.ofNullable(feeConditions);
            return this;
        }

        /**
         * Defines the specific conditions that must be met for the fee to be applied.
         */
        public Builder feeConditions(Optional<? extends Map<String, Object>> feeConditions) {
            Utils.checkNotNull(feeConditions, "feeConditions");
            this.feeConditions = feeConditions;
            return this;
        }
        
        public BillableFee build() {
            return new BillableFee(
                billableFeeID,
                billableEvent,
                feeName,
                feeModel,
                feeCategory,
                feeProperties,
                feeConditions);
        }
    }
}
