/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class BasicPaymentMethod {

    /**
     * ID of the payment method.
     */
    @JsonProperty("paymentMethodID")
    private String paymentMethodID;

    /**
     * The payment method type that represents a payment rail and directionality
     */
    @JsonProperty("paymentMethodType")
    private PaymentMethodType paymentMethodType;

    @JsonCreator
    public BasicPaymentMethod(
            @JsonProperty("paymentMethodID") String paymentMethodID,
            @JsonProperty("paymentMethodType") PaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodID = paymentMethodID;
        this.paymentMethodType = paymentMethodType;
    }

    /**
     * ID of the payment method.
     */
    @JsonIgnore
    public String paymentMethodID() {
        return paymentMethodID;
    }

    /**
     * The payment method type that represents a payment rail and directionality
     */
    @JsonIgnore
    public PaymentMethodType paymentMethodType() {
        return paymentMethodType;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * ID of the payment method.
     */
    public BasicPaymentMethod withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    /**
     * The payment method type that represents a payment rail and directionality
     */
    public BasicPaymentMethod withPaymentMethodType(PaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BasicPaymentMethod other = (BasicPaymentMethod) o;
        return 
            Objects.deepEquals(this.paymentMethodID, other.paymentMethodID) &&
            Objects.deepEquals(this.paymentMethodType, other.paymentMethodType);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            paymentMethodID,
            paymentMethodType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BasicPaymentMethod.class,
                "paymentMethodID", paymentMethodID,
                "paymentMethodType", paymentMethodType);
    }
    
    public final static class Builder {
 
        private String paymentMethodID;
 
        private PaymentMethodType paymentMethodType;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * ID of the payment method.
         */
        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }

        /**
         * The payment method type that represents a payment rail and directionality
         */
        public Builder paymentMethodType(PaymentMethodType paymentMethodType) {
            Utils.checkNotNull(paymentMethodType, "paymentMethodType");
            this.paymentMethodType = paymentMethodType;
            return this;
        }
        
        public BasicPaymentMethod build() {
            return new BasicPaymentMethod(
                paymentMethodID,
                paymentMethodType);
        }
    }
}
