/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BankAccountPayload
 * 
 * <p>Describes the bank account to link to the Moov account.
 */
public class BankAccountPayload {

    @JsonProperty("account")
    private BankAccountIntegration account;

    @JsonCreator
    public BankAccountPayload(
            @JsonProperty("account") BankAccountIntegration account) {
        Utils.checkNotNull(account, "account");
        this.account = account;
    }

    @JsonIgnore
    public BankAccountIntegration account() {
        return account;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public BankAccountPayload withAccount(BankAccountIntegration account) {
        Utils.checkNotNull(account, "account");
        this.account = account;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BankAccountPayload other = (BankAccountPayload) o;
        return 
            Objects.deepEquals(this.account, other.account);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            account);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BankAccountPayload.class,
                "account", account);
    }
    
    public final static class Builder {
 
        private BankAccountIntegration account;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder account(BankAccountIntegration account) {
            Utils.checkNotNull(account, "account");
            this.account = account;
            return this;
        }
        
        public BankAccountPayload build() {
            return new BankAccountPayload(
                account);
        }
    }
}
