/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class BankAccountIntegration {

    @JsonProperty("holderName")
    private String holderName;

    /**
     * The type of holder on a funding source.
     */
    @JsonProperty("holderType")
    private BankAccountHolderType holderType;

    @JsonProperty("accountNumber")
    private String accountNumber;

    /**
     * The bank account type.
     */
    @JsonProperty("bankAccountType")
    private BankAccountType bankAccountType;

    @JsonProperty("routingNumber")
    private String routingNumber;

    @JsonCreator
    public BankAccountIntegration(
            @JsonProperty("holderName") String holderName,
            @JsonProperty("holderType") BankAccountHolderType holderType,
            @JsonProperty("accountNumber") String accountNumber,
            @JsonProperty("bankAccountType") BankAccountType bankAccountType,
            @JsonProperty("routingNumber") String routingNumber) {
        Utils.checkNotNull(holderName, "holderName");
        Utils.checkNotNull(holderType, "holderType");
        Utils.checkNotNull(accountNumber, "accountNumber");
        Utils.checkNotNull(bankAccountType, "bankAccountType");
        Utils.checkNotNull(routingNumber, "routingNumber");
        this.holderName = holderName;
        this.holderType = holderType;
        this.accountNumber = accountNumber;
        this.bankAccountType = bankAccountType;
        this.routingNumber = routingNumber;
    }

    @JsonIgnore
    public String holderName() {
        return holderName;
    }

    /**
     * The type of holder on a funding source.
     */
    @JsonIgnore
    public BankAccountHolderType holderType() {
        return holderType;
    }

    @JsonIgnore
    public String accountNumber() {
        return accountNumber;
    }

    /**
     * The bank account type.
     */
    @JsonIgnore
    public BankAccountType bankAccountType() {
        return bankAccountType;
    }

    @JsonIgnore
    public String routingNumber() {
        return routingNumber;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public BankAccountIntegration withHolderName(String holderName) {
        Utils.checkNotNull(holderName, "holderName");
        this.holderName = holderName;
        return this;
    }

    /**
     * The type of holder on a funding source.
     */
    public BankAccountIntegration withHolderType(BankAccountHolderType holderType) {
        Utils.checkNotNull(holderType, "holderType");
        this.holderType = holderType;
        return this;
    }

    public BankAccountIntegration withAccountNumber(String accountNumber) {
        Utils.checkNotNull(accountNumber, "accountNumber");
        this.accountNumber = accountNumber;
        return this;
    }

    /**
     * The bank account type.
     */
    public BankAccountIntegration withBankAccountType(BankAccountType bankAccountType) {
        Utils.checkNotNull(bankAccountType, "bankAccountType");
        this.bankAccountType = bankAccountType;
        return this;
    }

    public BankAccountIntegration withRoutingNumber(String routingNumber) {
        Utils.checkNotNull(routingNumber, "routingNumber");
        this.routingNumber = routingNumber;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BankAccountIntegration other = (BankAccountIntegration) o;
        return 
            Objects.deepEquals(this.holderName, other.holderName) &&
            Objects.deepEquals(this.holderType, other.holderType) &&
            Objects.deepEquals(this.accountNumber, other.accountNumber) &&
            Objects.deepEquals(this.bankAccountType, other.bankAccountType) &&
            Objects.deepEquals(this.routingNumber, other.routingNumber);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            holderName,
            holderType,
            accountNumber,
            bankAccountType,
            routingNumber);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BankAccountIntegration.class,
                "holderName", holderName,
                "holderType", holderType,
                "accountNumber", accountNumber,
                "bankAccountType", bankAccountType,
                "routingNumber", routingNumber);
    }
    
    public final static class Builder {
 
        private String holderName;
 
        private BankAccountHolderType holderType;
 
        private String accountNumber;
 
        private BankAccountType bankAccountType;
 
        private String routingNumber;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder holderName(String holderName) {
            Utils.checkNotNull(holderName, "holderName");
            this.holderName = holderName;
            return this;
        }

        /**
         * The type of holder on a funding source.
         */
        public Builder holderType(BankAccountHolderType holderType) {
            Utils.checkNotNull(holderType, "holderType");
            this.holderType = holderType;
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            Utils.checkNotNull(accountNumber, "accountNumber");
            this.accountNumber = accountNumber;
            return this;
        }

        /**
         * The bank account type.
         */
        public Builder bankAccountType(BankAccountType bankAccountType) {
            Utils.checkNotNull(bankAccountType, "bankAccountType");
            this.bankAccountType = bankAccountType;
            return this;
        }

        public Builder routingNumber(String routingNumber) {
            Utils.checkNotNull(routingNumber, "routingNumber");
            this.routingNumber = routingNumber;
            return this;
        }
        
        public BankAccountIntegration build() {
            return new BankAccountIntegration(
                holderName,
                holderType,
                accountNumber,
                bankAccountType,
                routingNumber);
        }
    }
}
