/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AuthToken {

    /**
     * An [RFC 6750](https://www.rfc-editor.org/rfc/rfc6750#section-6.1) token type.
     */
    @JsonProperty("token_type")
    private TokenType tokenType;

    /**
     * A value passed to the authorization server to gain access to the system.
     */
    @JsonProperty("access_token")
    private String accessToken;

    /**
     * A value passed to the authorization server to obtain a new access token.
     */
    @JsonProperty("refresh_token")
    private String refreshToken;

    /**
     * Unix timestamp indicating when this token expires.
     */
    @JsonProperty("expires_in")
    private int expiresIn;

    /**
     * A space-delimited list of [scopes](https://docs.moov.io/api/authentication/scopes/) that are allowed.
     */
    @JsonProperty("scope")
    private String scope;

    @JsonCreator
    public AuthToken(
            @JsonProperty("token_type") TokenType tokenType,
            @JsonProperty("access_token") String accessToken,
            @JsonProperty("refresh_token") String refreshToken,
            @JsonProperty("expires_in") int expiresIn,
            @JsonProperty("scope") String scope) {
        Utils.checkNotNull(tokenType, "tokenType");
        Utils.checkNotNull(accessToken, "accessToken");
        Utils.checkNotNull(refreshToken, "refreshToken");
        Utils.checkNotNull(expiresIn, "expiresIn");
        Utils.checkNotNull(scope, "scope");
        this.tokenType = tokenType;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
        this.scope = scope;
    }

    /**
     * An [RFC 6750](https://www.rfc-editor.org/rfc/rfc6750#section-6.1) token type.
     */
    @JsonIgnore
    public TokenType tokenType() {
        return tokenType;
    }

    /**
     * A value passed to the authorization server to gain access to the system.
     */
    @JsonIgnore
    public String accessToken() {
        return accessToken;
    }

    /**
     * A value passed to the authorization server to obtain a new access token.
     */
    @JsonIgnore
    public String refreshToken() {
        return refreshToken;
    }

    /**
     * Unix timestamp indicating when this token expires.
     */
    @JsonIgnore
    public int expiresIn() {
        return expiresIn;
    }

    /**
     * A space-delimited list of [scopes](https://docs.moov.io/api/authentication/scopes/) that are allowed.
     */
    @JsonIgnore
    public String scope() {
        return scope;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * An [RFC 6750](https://www.rfc-editor.org/rfc/rfc6750#section-6.1) token type.
     */
    public AuthToken withTokenType(TokenType tokenType) {
        Utils.checkNotNull(tokenType, "tokenType");
        this.tokenType = tokenType;
        return this;
    }

    /**
     * A value passed to the authorization server to gain access to the system.
     */
    public AuthToken withAccessToken(String accessToken) {
        Utils.checkNotNull(accessToken, "accessToken");
        this.accessToken = accessToken;
        return this;
    }

    /**
     * A value passed to the authorization server to obtain a new access token.
     */
    public AuthToken withRefreshToken(String refreshToken) {
        Utils.checkNotNull(refreshToken, "refreshToken");
        this.refreshToken = refreshToken;
        return this;
    }

    /**
     * Unix timestamp indicating when this token expires.
     */
    public AuthToken withExpiresIn(int expiresIn) {
        Utils.checkNotNull(expiresIn, "expiresIn");
        this.expiresIn = expiresIn;
        return this;
    }

    /**
     * A space-delimited list of [scopes](https://docs.moov.io/api/authentication/scopes/) that are allowed.
     */
    public AuthToken withScope(String scope) {
        Utils.checkNotNull(scope, "scope");
        this.scope = scope;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthToken other = (AuthToken) o;
        return 
            Objects.deepEquals(this.tokenType, other.tokenType) &&
            Objects.deepEquals(this.accessToken, other.accessToken) &&
            Objects.deepEquals(this.refreshToken, other.refreshToken) &&
            Objects.deepEquals(this.expiresIn, other.expiresIn) &&
            Objects.deepEquals(this.scope, other.scope);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            tokenType,
            accessToken,
            refreshToken,
            expiresIn,
            scope);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AuthToken.class,
                "tokenType", tokenType,
                "accessToken", accessToken,
                "refreshToken", refreshToken,
                "expiresIn", expiresIn,
                "scope", scope);
    }
    
    public final static class Builder {
 
        private TokenType tokenType;
 
        private String accessToken;
 
        private String refreshToken;
 
        private Integer expiresIn;
 
        private String scope;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * An [RFC 6750](https://www.rfc-editor.org/rfc/rfc6750#section-6.1) token type.
         */
        public Builder tokenType(TokenType tokenType) {
            Utils.checkNotNull(tokenType, "tokenType");
            this.tokenType = tokenType;
            return this;
        }

        /**
         * A value passed to the authorization server to gain access to the system.
         */
        public Builder accessToken(String accessToken) {
            Utils.checkNotNull(accessToken, "accessToken");
            this.accessToken = accessToken;
            return this;
        }

        /**
         * A value passed to the authorization server to obtain a new access token.
         */
        public Builder refreshToken(String refreshToken) {
            Utils.checkNotNull(refreshToken, "refreshToken");
            this.refreshToken = refreshToken;
            return this;
        }

        /**
         * Unix timestamp indicating when this token expires.
         */
        public Builder expiresIn(int expiresIn) {
            Utils.checkNotNull(expiresIn, "expiresIn");
            this.expiresIn = expiresIn;
            return this;
        }

        /**
         * A space-delimited list of [scopes](https://docs.moov.io/api/authentication/scopes/) that are allowed.
         */
        public Builder scope(String scope) {
            Utils.checkNotNull(scope, "scope");
            this.scope = scope;
            return this;
        }
        
        public AuthToken build() {
            return new AuthToken(
                tokenType,
                accessToken,
                refreshToken,
                expiresIn,
                scope);
        }
    }
}
