/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class AsyncTransfer {

    @JsonProperty("transferID")
    private String transferID;

    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonCreator
    public AsyncTransfer(
            @JsonProperty("transferID") String transferID,
            @JsonProperty("createdOn") OffsetDateTime createdOn) {
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(createdOn, "createdOn");
        this.transferID = transferID;
        this.createdOn = createdOn;
    }

    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public AsyncTransfer withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public AsyncTransfer withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AsyncTransfer other = (AsyncTransfer) o;
        return 
            Objects.deepEquals(this.transferID, other.transferID) &&
            Objects.deepEquals(this.createdOn, other.createdOn);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            transferID,
            createdOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AsyncTransfer.class,
                "transferID", transferID,
                "createdOn", createdOn);
    }
    
    public final static class Builder {
 
        private String transferID;
 
        private OffsetDateTime createdOn;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }
        
        public AsyncTransfer build() {
            return new AsyncTransfer(
                transferID,
                createdOn);
        }
    }
}
