/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class AchParticipant {

    @JsonProperty("achLocation")
    private AchLocation achLocation;

    @JsonProperty("customerName")
    private String customerName;

    @JsonProperty("newRoutingNumber")
    private String newRoutingNumber;

    @JsonProperty("officeCode")
    private String officeCode;

    @JsonProperty("phoneNumber")
    private String phoneNumber;

    @JsonProperty("recordTypeCode")
    private String recordTypeCode;

    @JsonProperty("revised")
    private String revised;

    @JsonProperty("routingNumber")
    private String routingNumber;

    @JsonProperty("servicingFRBNumber")
    private String servicingFRBNumber;

    @JsonProperty("statusCode")
    private String statusCode;

    @JsonProperty("viewCode")
    private String viewCode;

    @JsonProperty("cleanName")
    private String cleanName;

    @JsonInclude(Include.ALWAYS)
    @JsonProperty("logo")
    private Optional<? extends Logo> logo;

    @JsonCreator
    public AchParticipant(
            @JsonProperty("achLocation") AchLocation achLocation,
            @JsonProperty("customerName") String customerName,
            @JsonProperty("newRoutingNumber") String newRoutingNumber,
            @JsonProperty("officeCode") String officeCode,
            @JsonProperty("phoneNumber") String phoneNumber,
            @JsonProperty("recordTypeCode") String recordTypeCode,
            @JsonProperty("revised") String revised,
            @JsonProperty("routingNumber") String routingNumber,
            @JsonProperty("servicingFRBNumber") String servicingFRBNumber,
            @JsonProperty("statusCode") String statusCode,
            @JsonProperty("viewCode") String viewCode,
            @JsonProperty("cleanName") String cleanName,
            @JsonProperty("logo") Optional<? extends Logo> logo) {
        Utils.checkNotNull(achLocation, "achLocation");
        Utils.checkNotNull(customerName, "customerName");
        Utils.checkNotNull(newRoutingNumber, "newRoutingNumber");
        Utils.checkNotNull(officeCode, "officeCode");
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        Utils.checkNotNull(recordTypeCode, "recordTypeCode");
        Utils.checkNotNull(revised, "revised");
        Utils.checkNotNull(routingNumber, "routingNumber");
        Utils.checkNotNull(servicingFRBNumber, "servicingFRBNumber");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(viewCode, "viewCode");
        Utils.checkNotNull(cleanName, "cleanName");
        Utils.checkNotNull(logo, "logo");
        this.achLocation = achLocation;
        this.customerName = customerName;
        this.newRoutingNumber = newRoutingNumber;
        this.officeCode = officeCode;
        this.phoneNumber = phoneNumber;
        this.recordTypeCode = recordTypeCode;
        this.revised = revised;
        this.routingNumber = routingNumber;
        this.servicingFRBNumber = servicingFRBNumber;
        this.statusCode = statusCode;
        this.viewCode = viewCode;
        this.cleanName = cleanName;
        this.logo = logo;
    }
    
    public AchParticipant(
            AchLocation achLocation,
            String customerName,
            String newRoutingNumber,
            String officeCode,
            String phoneNumber,
            String recordTypeCode,
            String revised,
            String routingNumber,
            String servicingFRBNumber,
            String statusCode,
            String viewCode,
            String cleanName) {
        this(achLocation, customerName, newRoutingNumber, officeCode, phoneNumber, recordTypeCode, revised, routingNumber, servicingFRBNumber, statusCode, viewCode, cleanName, Optional.empty());
    }

    @JsonIgnore
    public AchLocation achLocation() {
        return achLocation;
    }

    @JsonIgnore
    public String customerName() {
        return customerName;
    }

    @JsonIgnore
    public String newRoutingNumber() {
        return newRoutingNumber;
    }

    @JsonIgnore
    public String officeCode() {
        return officeCode;
    }

    @JsonIgnore
    public String phoneNumber() {
        return phoneNumber;
    }

    @JsonIgnore
    public String recordTypeCode() {
        return recordTypeCode;
    }

    @JsonIgnore
    public String revised() {
        return revised;
    }

    @JsonIgnore
    public String routingNumber() {
        return routingNumber;
    }

    @JsonIgnore
    public String servicingFRBNumber() {
        return servicingFRBNumber;
    }

    @JsonIgnore
    public String statusCode() {
        return statusCode;
    }

    @JsonIgnore
    public String viewCode() {
        return viewCode;
    }

    @JsonIgnore
    public String cleanName() {
        return cleanName;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Logo> logo() {
        return (Optional<Logo>) logo;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public AchParticipant withAchLocation(AchLocation achLocation) {
        Utils.checkNotNull(achLocation, "achLocation");
        this.achLocation = achLocation;
        return this;
    }

    public AchParticipant withCustomerName(String customerName) {
        Utils.checkNotNull(customerName, "customerName");
        this.customerName = customerName;
        return this;
    }

    public AchParticipant withNewRoutingNumber(String newRoutingNumber) {
        Utils.checkNotNull(newRoutingNumber, "newRoutingNumber");
        this.newRoutingNumber = newRoutingNumber;
        return this;
    }

    public AchParticipant withOfficeCode(String officeCode) {
        Utils.checkNotNull(officeCode, "officeCode");
        this.officeCode = officeCode;
        return this;
    }

    public AchParticipant withPhoneNumber(String phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = phoneNumber;
        return this;
    }

    public AchParticipant withRecordTypeCode(String recordTypeCode) {
        Utils.checkNotNull(recordTypeCode, "recordTypeCode");
        this.recordTypeCode = recordTypeCode;
        return this;
    }

    public AchParticipant withRevised(String revised) {
        Utils.checkNotNull(revised, "revised");
        this.revised = revised;
        return this;
    }

    public AchParticipant withRoutingNumber(String routingNumber) {
        Utils.checkNotNull(routingNumber, "routingNumber");
        this.routingNumber = routingNumber;
        return this;
    }

    public AchParticipant withServicingFRBNumber(String servicingFRBNumber) {
        Utils.checkNotNull(servicingFRBNumber, "servicingFRBNumber");
        this.servicingFRBNumber = servicingFRBNumber;
        return this;
    }

    public AchParticipant withStatusCode(String statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AchParticipant withViewCode(String viewCode) {
        Utils.checkNotNull(viewCode, "viewCode");
        this.viewCode = viewCode;
        return this;
    }

    public AchParticipant withCleanName(String cleanName) {
        Utils.checkNotNull(cleanName, "cleanName");
        this.cleanName = cleanName;
        return this;
    }

    public AchParticipant withLogo(Logo logo) {
        Utils.checkNotNull(logo, "logo");
        this.logo = Optional.ofNullable(logo);
        return this;
    }

    public AchParticipant withLogo(Optional<? extends Logo> logo) {
        Utils.checkNotNull(logo, "logo");
        this.logo = logo;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AchParticipant other = (AchParticipant) o;
        return 
            Objects.deepEquals(this.achLocation, other.achLocation) &&
            Objects.deepEquals(this.customerName, other.customerName) &&
            Objects.deepEquals(this.newRoutingNumber, other.newRoutingNumber) &&
            Objects.deepEquals(this.officeCode, other.officeCode) &&
            Objects.deepEquals(this.phoneNumber, other.phoneNumber) &&
            Objects.deepEquals(this.recordTypeCode, other.recordTypeCode) &&
            Objects.deepEquals(this.revised, other.revised) &&
            Objects.deepEquals(this.routingNumber, other.routingNumber) &&
            Objects.deepEquals(this.servicingFRBNumber, other.servicingFRBNumber) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.viewCode, other.viewCode) &&
            Objects.deepEquals(this.cleanName, other.cleanName) &&
            Objects.deepEquals(this.logo, other.logo);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            achLocation,
            customerName,
            newRoutingNumber,
            officeCode,
            phoneNumber,
            recordTypeCode,
            revised,
            routingNumber,
            servicingFRBNumber,
            statusCode,
            viewCode,
            cleanName,
            logo);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AchParticipant.class,
                "achLocation", achLocation,
                "customerName", customerName,
                "newRoutingNumber", newRoutingNumber,
                "officeCode", officeCode,
                "phoneNumber", phoneNumber,
                "recordTypeCode", recordTypeCode,
                "revised", revised,
                "routingNumber", routingNumber,
                "servicingFRBNumber", servicingFRBNumber,
                "statusCode", statusCode,
                "viewCode", viewCode,
                "cleanName", cleanName,
                "logo", logo);
    }
    
    public final static class Builder {
 
        private AchLocation achLocation;
 
        private String customerName;
 
        private String newRoutingNumber;
 
        private String officeCode;
 
        private String phoneNumber;
 
        private String recordTypeCode;
 
        private String revised;
 
        private String routingNumber;
 
        private String servicingFRBNumber;
 
        private String statusCode;
 
        private String viewCode;
 
        private String cleanName;
 
        private Optional<? extends Logo> logo = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder achLocation(AchLocation achLocation) {
            Utils.checkNotNull(achLocation, "achLocation");
            this.achLocation = achLocation;
            return this;
        }

        public Builder customerName(String customerName) {
            Utils.checkNotNull(customerName, "customerName");
            this.customerName = customerName;
            return this;
        }

        public Builder newRoutingNumber(String newRoutingNumber) {
            Utils.checkNotNull(newRoutingNumber, "newRoutingNumber");
            this.newRoutingNumber = newRoutingNumber;
            return this;
        }

        public Builder officeCode(String officeCode) {
            Utils.checkNotNull(officeCode, "officeCode");
            this.officeCode = officeCode;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder recordTypeCode(String recordTypeCode) {
            Utils.checkNotNull(recordTypeCode, "recordTypeCode");
            this.recordTypeCode = recordTypeCode;
            return this;
        }

        public Builder revised(String revised) {
            Utils.checkNotNull(revised, "revised");
            this.revised = revised;
            return this;
        }

        public Builder routingNumber(String routingNumber) {
            Utils.checkNotNull(routingNumber, "routingNumber");
            this.routingNumber = routingNumber;
            return this;
        }

        public Builder servicingFRBNumber(String servicingFRBNumber) {
            Utils.checkNotNull(servicingFRBNumber, "servicingFRBNumber");
            this.servicingFRBNumber = servicingFRBNumber;
            return this;
        }

        public Builder statusCode(String statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder viewCode(String viewCode) {
            Utils.checkNotNull(viewCode, "viewCode");
            this.viewCode = viewCode;
            return this;
        }

        public Builder cleanName(String cleanName) {
            Utils.checkNotNull(cleanName, "cleanName");
            this.cleanName = cleanName;
            return this;
        }

        public Builder logo(Logo logo) {
            Utils.checkNotNull(logo, "logo");
            this.logo = Optional.ofNullable(logo);
            return this;
        }

        public Builder logo(Optional<? extends Logo> logo) {
            Utils.checkNotNull(logo, "logo");
            this.logo = logo;
            return this;
        }
        
        public AchParticipant build() {
            return new AchParticipant(
                achLocation,
                customerName,
                newRoutingNumber,
                officeCode,
                phoneNumber,
                recordTypeCode,
                revised,
                routingNumber,
                servicingFRBNumber,
                statusCode,
                viewCode,
                cleanName,
                logo);
        }
    }
}
