/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * AccountCountries
 * 
 * <p>The countries in which an account operates.
 */
public class AccountCountries {

    @JsonProperty("countries")
    private List<String> countries;

    @JsonCreator
    public AccountCountries(
            @JsonProperty("countries") List<String> countries) {
        Utils.checkNotNull(countries, "countries");
        this.countries = countries;
    }

    @JsonIgnore
    public List<String> countries() {
        return countries;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public AccountCountries withCountries(List<String> countries) {
        Utils.checkNotNull(countries, "countries");
        this.countries = countries;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountCountries other = (AccountCountries) o;
        return 
            Objects.deepEquals(this.countries, other.countries);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            countries);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountCountries.class,
                "countries", countries);
    }
    
    public final static class Builder {
 
        private List<String> countries;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder countries(List<String> countries) {
            Utils.checkNotNull(countries, "countries");
            this.countries = countries;
            return this;
        }
        
        public AccountCountries build() {
            return new AccountCountries(
                countries);
        }
    }
}
