/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Account {

    /**
     * Unique identifier for this account.
     */
    @JsonProperty("accountID")
    private String accountID;

    /**
     * The operating mode for an account.
     */
    @JsonProperty("mode")
    private Mode mode;

    /**
     * The type of entity represented by this account.
     */
    @JsonProperty("accountType")
    private AccountType accountType;

    @JsonProperty("displayName")
    private String displayName;

    /**
     * Describes a Moov account profile. A profile will have a business or an individual, depending on the account's type.
     */
    @JsonProperty("profile")
    private Profile profile;

    /**
     * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("metadata")
    private Optional<? extends Map<String, String>> metadata;

    /**
     * Describes the acceptance of the Terms of Service.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("termsOfService")
    private Optional<? extends TermsOfService> termsOfService;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("capabilities")
    private Optional<? extends List<AccountCapability>> capabilities;

    /**
     * Describes identity verification status and relevant identity verification documents.
     */
    @JsonProperty("verification")
    private Verification verification;

    /**
     * Optional alias from a foreign/external system which can be used to reference this resource.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("foreignID")
    private Optional<String> foreignID;

    /**
     * User-provided information that can be displayed on credit card transactions for customers to use when
     * contacting a customer support team. This data is only allowed on a business account.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("customerSupport")
    private Optional<? extends CustomerSupport> customerSupport;

    /**
     * User provided settings to manage an account.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("settings")
    private Optional<? extends Settings> settings;

    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonProperty("updatedOn")
    private OffsetDateTime updatedOn;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("disconnectedOn")
    private Optional<OffsetDateTime> disconnectedOn;

    @JsonCreator
    public Account(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("mode") Mode mode,
            @JsonProperty("accountType") AccountType accountType,
            @JsonProperty("displayName") String displayName,
            @JsonProperty("profile") Profile profile,
            @JsonProperty("metadata") Optional<? extends Map<String, String>> metadata,
            @JsonProperty("termsOfService") Optional<? extends TermsOfService> termsOfService,
            @JsonProperty("capabilities") Optional<? extends List<AccountCapability>> capabilities,
            @JsonProperty("verification") Verification verification,
            @JsonProperty("foreignID") Optional<String> foreignID,
            @JsonProperty("customerSupport") Optional<? extends CustomerSupport> customerSupport,
            @JsonProperty("settings") Optional<? extends Settings> settings,
            @JsonProperty("createdOn") OffsetDateTime createdOn,
            @JsonProperty("updatedOn") OffsetDateTime updatedOn,
            @JsonProperty("disconnectedOn") Optional<OffsetDateTime> disconnectedOn) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(mode, "mode");
        Utils.checkNotNull(accountType, "accountType");
        Utils.checkNotNull(displayName, "displayName");
        Utils.checkNotNull(profile, "profile");
        Utils.checkNotNull(metadata, "metadata");
        Utils.checkNotNull(termsOfService, "termsOfService");
        Utils.checkNotNull(capabilities, "capabilities");
        Utils.checkNotNull(verification, "verification");
        Utils.checkNotNull(foreignID, "foreignID");
        Utils.checkNotNull(customerSupport, "customerSupport");
        Utils.checkNotNull(settings, "settings");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(updatedOn, "updatedOn");
        Utils.checkNotNull(disconnectedOn, "disconnectedOn");
        this.accountID = accountID;
        this.mode = mode;
        this.accountType = accountType;
        this.displayName = displayName;
        this.profile = profile;
        this.metadata = metadata;
        this.termsOfService = termsOfService;
        this.capabilities = capabilities;
        this.verification = verification;
        this.foreignID = foreignID;
        this.customerSupport = customerSupport;
        this.settings = settings;
        this.createdOn = createdOn;
        this.updatedOn = updatedOn;
        this.disconnectedOn = disconnectedOn;
    }
    
    public Account(
            String accountID,
            Mode mode,
            AccountType accountType,
            String displayName,
            Profile profile,
            Verification verification,
            OffsetDateTime createdOn,
            OffsetDateTime updatedOn) {
        this(accountID, mode, accountType, displayName, profile, Optional.empty(), Optional.empty(), Optional.empty(), verification, Optional.empty(), Optional.empty(), Optional.empty(), createdOn, updatedOn, Optional.empty());
    }

    /**
     * Unique identifier for this account.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * The operating mode for an account.
     */
    @JsonIgnore
    public Mode mode() {
        return mode;
    }

    /**
     * The type of entity represented by this account.
     */
    @JsonIgnore
    public AccountType accountType() {
        return accountType;
    }

    @JsonIgnore
    public String displayName() {
        return displayName;
    }

    /**
     * Describes a Moov account profile. A profile will have a business or an individual, depending on the account's type.
     */
    @JsonIgnore
    public Profile profile() {
        return profile;
    }

    /**
     * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Map<String, String>> metadata() {
        return (Optional<Map<String, String>>) metadata;
    }

    /**
     * Describes the acceptance of the Terms of Service.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TermsOfService> termsOfService() {
        return (Optional<TermsOfService>) termsOfService;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<AccountCapability>> capabilities() {
        return (Optional<List<AccountCapability>>) capabilities;
    }

    /**
     * Describes identity verification status and relevant identity verification documents.
     */
    @JsonIgnore
    public Verification verification() {
        return verification;
    }

    /**
     * Optional alias from a foreign/external system which can be used to reference this resource.
     */
    @JsonIgnore
    public Optional<String> foreignID() {
        return foreignID;
    }

    /**
     * User-provided information that can be displayed on credit card transactions for customers to use when
     * contacting a customer support team. This data is only allowed on a business account.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CustomerSupport> customerSupport() {
        return (Optional<CustomerSupport>) customerSupport;
    }

    /**
     * User provided settings to manage an account.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Settings> settings() {
        return (Optional<Settings>) settings;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    @JsonIgnore
    public OffsetDateTime updatedOn() {
        return updatedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> disconnectedOn() {
        return disconnectedOn;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier for this account.
     */
    public Account withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * The operating mode for an account.
     */
    public Account withMode(Mode mode) {
        Utils.checkNotNull(mode, "mode");
        this.mode = mode;
        return this;
    }

    /**
     * The type of entity represented by this account.
     */
    public Account withAccountType(AccountType accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = accountType;
        return this;
    }

    public Account withDisplayName(String displayName) {
        Utils.checkNotNull(displayName, "displayName");
        this.displayName = displayName;
        return this;
    }

    /**
     * Describes a Moov account profile. A profile will have a business or an individual, depending on the account's type.
     */
    public Account withProfile(Profile profile) {
        Utils.checkNotNull(profile, "profile");
        this.profile = profile;
        return this;
    }

    /**
     * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
     */
    public Account withMetadata(Map<String, String> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = Optional.ofNullable(metadata);
        return this;
    }

    /**
     * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
     */
    public Account withMetadata(Optional<? extends Map<String, String>> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }

    /**
     * Describes the acceptance of the Terms of Service.
     */
    public Account withTermsOfService(TermsOfService termsOfService) {
        Utils.checkNotNull(termsOfService, "termsOfService");
        this.termsOfService = Optional.ofNullable(termsOfService);
        return this;
    }

    /**
     * Describes the acceptance of the Terms of Service.
     */
    public Account withTermsOfService(Optional<? extends TermsOfService> termsOfService) {
        Utils.checkNotNull(termsOfService, "termsOfService");
        this.termsOfService = termsOfService;
        return this;
    }

    public Account withCapabilities(List<AccountCapability> capabilities) {
        Utils.checkNotNull(capabilities, "capabilities");
        this.capabilities = Optional.ofNullable(capabilities);
        return this;
    }

    public Account withCapabilities(Optional<? extends List<AccountCapability>> capabilities) {
        Utils.checkNotNull(capabilities, "capabilities");
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Describes identity verification status and relevant identity verification documents.
     */
    public Account withVerification(Verification verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = verification;
        return this;
    }

    /**
     * Optional alias from a foreign/external system which can be used to reference this resource.
     */
    public Account withForeignID(String foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = Optional.ofNullable(foreignID);
        return this;
    }

    /**
     * Optional alias from a foreign/external system which can be used to reference this resource.
     */
    public Account withForeignID(Optional<String> foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = foreignID;
        return this;
    }

    /**
     * User-provided information that can be displayed on credit card transactions for customers to use when
     * contacting a customer support team. This data is only allowed on a business account.
     */
    public Account withCustomerSupport(CustomerSupport customerSupport) {
        Utils.checkNotNull(customerSupport, "customerSupport");
        this.customerSupport = Optional.ofNullable(customerSupport);
        return this;
    }

    /**
     * User-provided information that can be displayed on credit card transactions for customers to use when
     * contacting a customer support team. This data is only allowed on a business account.
     */
    public Account withCustomerSupport(Optional<? extends CustomerSupport> customerSupport) {
        Utils.checkNotNull(customerSupport, "customerSupport");
        this.customerSupport = customerSupport;
        return this;
    }

    /**
     * User provided settings to manage an account.
     */
    public Account withSettings(Settings settings) {
        Utils.checkNotNull(settings, "settings");
        this.settings = Optional.ofNullable(settings);
        return this;
    }

    /**
     * User provided settings to manage an account.
     */
    public Account withSettings(Optional<? extends Settings> settings) {
        Utils.checkNotNull(settings, "settings");
        this.settings = settings;
        return this;
    }

    public Account withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    public Account withUpdatedOn(OffsetDateTime updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = updatedOn;
        return this;
    }

    public Account withDisconnectedOn(OffsetDateTime disconnectedOn) {
        Utils.checkNotNull(disconnectedOn, "disconnectedOn");
        this.disconnectedOn = Optional.ofNullable(disconnectedOn);
        return this;
    }

    public Account withDisconnectedOn(Optional<OffsetDateTime> disconnectedOn) {
        Utils.checkNotNull(disconnectedOn, "disconnectedOn");
        this.disconnectedOn = disconnectedOn;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Account other = (Account) o;
        return 
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.mode, other.mode) &&
            Objects.deepEquals(this.accountType, other.accountType) &&
            Objects.deepEquals(this.displayName, other.displayName) &&
            Objects.deepEquals(this.profile, other.profile) &&
            Objects.deepEquals(this.metadata, other.metadata) &&
            Objects.deepEquals(this.termsOfService, other.termsOfService) &&
            Objects.deepEquals(this.capabilities, other.capabilities) &&
            Objects.deepEquals(this.verification, other.verification) &&
            Objects.deepEquals(this.foreignID, other.foreignID) &&
            Objects.deepEquals(this.customerSupport, other.customerSupport) &&
            Objects.deepEquals(this.settings, other.settings) &&
            Objects.deepEquals(this.createdOn, other.createdOn) &&
            Objects.deepEquals(this.updatedOn, other.updatedOn) &&
            Objects.deepEquals(this.disconnectedOn, other.disconnectedOn);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            accountID,
            mode,
            accountType,
            displayName,
            profile,
            metadata,
            termsOfService,
            capabilities,
            verification,
            foreignID,
            customerSupport,
            settings,
            createdOn,
            updatedOn,
            disconnectedOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Account.class,
                "accountID", accountID,
                "mode", mode,
                "accountType", accountType,
                "displayName", displayName,
                "profile", profile,
                "metadata", metadata,
                "termsOfService", termsOfService,
                "capabilities", capabilities,
                "verification", verification,
                "foreignID", foreignID,
                "customerSupport", customerSupport,
                "settings", settings,
                "createdOn", createdOn,
                "updatedOn", updatedOn,
                "disconnectedOn", disconnectedOn);
    }
    
    public final static class Builder {
 
        private String accountID;
 
        private Mode mode;
 
        private AccountType accountType;
 
        private String displayName;
 
        private Profile profile;
 
        private Optional<? extends Map<String, String>> metadata = Optional.empty();
 
        private Optional<? extends TermsOfService> termsOfService = Optional.empty();
 
        private Optional<? extends List<AccountCapability>> capabilities = Optional.empty();
 
        private Verification verification;
 
        private Optional<String> foreignID = Optional.empty();
 
        private Optional<? extends CustomerSupport> customerSupport = Optional.empty();
 
        private Optional<? extends Settings> settings = Optional.empty();
 
        private OffsetDateTime createdOn;
 
        private OffsetDateTime updatedOn;
 
        private Optional<OffsetDateTime> disconnectedOn = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier for this account.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        /**
         * The operating mode for an account.
         */
        public Builder mode(Mode mode) {
            Utils.checkNotNull(mode, "mode");
            this.mode = mode;
            return this;
        }

        /**
         * The type of entity represented by this account.
         */
        public Builder accountType(AccountType accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = accountType;
            return this;
        }

        public Builder displayName(String displayName) {
            Utils.checkNotNull(displayName, "displayName");
            this.displayName = displayName;
            return this;
        }

        /**
         * Describes a Moov account profile. A profile will have a business or an individual, depending on the account's type.
         */
        public Builder profile(Profile profile) {
            Utils.checkNotNull(profile, "profile");
            this.profile = profile;
            return this;
        }

        /**
         * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
         */
        public Builder metadata(Map<String, String> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        /**
         * Free-form key-value pair list. Useful for storing information that is not captured elsewhere.
         */
        public Builder metadata(Optional<? extends Map<String, String>> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }

        /**
         * Describes the acceptance of the Terms of Service.
         */
        public Builder termsOfService(TermsOfService termsOfService) {
            Utils.checkNotNull(termsOfService, "termsOfService");
            this.termsOfService = Optional.ofNullable(termsOfService);
            return this;
        }

        /**
         * Describes the acceptance of the Terms of Service.
         */
        public Builder termsOfService(Optional<? extends TermsOfService> termsOfService) {
            Utils.checkNotNull(termsOfService, "termsOfService");
            this.termsOfService = termsOfService;
            return this;
        }

        public Builder capabilities(List<AccountCapability> capabilities) {
            Utils.checkNotNull(capabilities, "capabilities");
            this.capabilities = Optional.ofNullable(capabilities);
            return this;
        }

        public Builder capabilities(Optional<? extends List<AccountCapability>> capabilities) {
            Utils.checkNotNull(capabilities, "capabilities");
            this.capabilities = capabilities;
            return this;
        }

        /**
         * Describes identity verification status and relevant identity verification documents.
         */
        public Builder verification(Verification verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = verification;
            return this;
        }

        /**
         * Optional alias from a foreign/external system which can be used to reference this resource.
         */
        public Builder foreignID(String foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = Optional.ofNullable(foreignID);
            return this;
        }

        /**
         * Optional alias from a foreign/external system which can be used to reference this resource.
         */
        public Builder foreignID(Optional<String> foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = foreignID;
            return this;
        }

        /**
         * User-provided information that can be displayed on credit card transactions for customers to use when
         * contacting a customer support team. This data is only allowed on a business account.
         */
        public Builder customerSupport(CustomerSupport customerSupport) {
            Utils.checkNotNull(customerSupport, "customerSupport");
            this.customerSupport = Optional.ofNullable(customerSupport);
            return this;
        }

        /**
         * User-provided information that can be displayed on credit card transactions for customers to use when
         * contacting a customer support team. This data is only allowed on a business account.
         */
        public Builder customerSupport(Optional<? extends CustomerSupport> customerSupport) {
            Utils.checkNotNull(customerSupport, "customerSupport");
            this.customerSupport = customerSupport;
            return this;
        }

        /**
         * User provided settings to manage an account.
         */
        public Builder settings(Settings settings) {
            Utils.checkNotNull(settings, "settings");
            this.settings = Optional.ofNullable(settings);
            return this;
        }

        /**
         * User provided settings to manage an account.
         */
        public Builder settings(Optional<? extends Settings> settings) {
            Utils.checkNotNull(settings, "settings");
            this.settings = settings;
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }

        public Builder updatedOn(OffsetDateTime updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = updatedOn;
            return this;
        }

        public Builder disconnectedOn(OffsetDateTime disconnectedOn) {
            Utils.checkNotNull(disconnectedOn, "disconnectedOn");
            this.disconnectedOn = Optional.ofNullable(disconnectedOn);
            return this;
        }

        public Builder disconnectedOn(Optional<OffsetDateTime> disconnectedOn) {
            Utils.checkNotNull(disconnectedOn, "disconnectedOn");
            this.disconnectedOn = disconnectedOn;
            return this;
        }
        
        public Account build() {
            return new Account(
                accountID,
                mode,
                accountType,
                displayName,
                profile,
                metadata,
                termsOfService,
                capabilities,
                verification,
                foreignID,
                customerSupport,
                settings,
                createdOn,
                updatedOn,
                disconnectedOn);
        }
    }
}
