/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

/**
 * ACHTransactionDetails
 * 
 * <p>ACH specific details about the transaction.
 */
public class ACHTransactionDetails {

    /**
     * Status of a transaction within the ACH lifecycle.
     */
    @JsonProperty("status")
    private ACHTransactionStatus status;

    @JsonProperty("traceNumber")
    private String traceNumber;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("return")
    private Optional<? extends ACHException> return_;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("correction")
    private Optional<? extends ACHException> correction;

    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("companyEntryDescription")
    private Optional<String> companyEntryDescription;

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("originatingCompanyName")
    private Optional<String> originatingCompanyName;

    /**
     * Code used to identify the ACH authorization method.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("secCode")
    private Optional<? extends SECCode> secCode;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("canceledOn")
    private Optional<OffsetDateTime> canceledOn;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("initiatedOn")
    private Optional<OffsetDateTime> initiatedOn;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("originatedOn")
    private Optional<OffsetDateTime> originatedOn;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("correctedOn")
    private Optional<OffsetDateTime> correctedOn;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("returnedOn")
    private Optional<OffsetDateTime> returnedOn;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("failedOn")
    private Optional<OffsetDateTime> failedOn;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("completedOn")
    private Optional<OffsetDateTime> completedOn;

    /**
     * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("debitHoldPeriod")
    private Optional<? extends DebitHoldPeriod> debitHoldPeriod;

    @JsonCreator
    public ACHTransactionDetails(
            @JsonProperty("status") ACHTransactionStatus status,
            @JsonProperty("traceNumber") String traceNumber,
            @JsonProperty("return") Optional<? extends ACHException> return_,
            @JsonProperty("correction") Optional<? extends ACHException> correction,
            @JsonProperty("companyEntryDescription") Optional<String> companyEntryDescription,
            @JsonProperty("originatingCompanyName") Optional<String> originatingCompanyName,
            @JsonProperty("secCode") Optional<? extends SECCode> secCode,
            @JsonProperty("canceledOn") Optional<OffsetDateTime> canceledOn,
            @JsonProperty("initiatedOn") Optional<OffsetDateTime> initiatedOn,
            @JsonProperty("originatedOn") Optional<OffsetDateTime> originatedOn,
            @JsonProperty("correctedOn") Optional<OffsetDateTime> correctedOn,
            @JsonProperty("returnedOn") Optional<OffsetDateTime> returnedOn,
            @JsonProperty("failedOn") Optional<OffsetDateTime> failedOn,
            @JsonProperty("completedOn") Optional<OffsetDateTime> completedOn,
            @JsonProperty("debitHoldPeriod") Optional<? extends DebitHoldPeriod> debitHoldPeriod) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(traceNumber, "traceNumber");
        Utils.checkNotNull(return_, "return_");
        Utils.checkNotNull(correction, "correction");
        Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
        Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
        Utils.checkNotNull(secCode, "secCode");
        Utils.checkNotNull(canceledOn, "canceledOn");
        Utils.checkNotNull(initiatedOn, "initiatedOn");
        Utils.checkNotNull(originatedOn, "originatedOn");
        Utils.checkNotNull(correctedOn, "correctedOn");
        Utils.checkNotNull(returnedOn, "returnedOn");
        Utils.checkNotNull(failedOn, "failedOn");
        Utils.checkNotNull(completedOn, "completedOn");
        Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
        this.status = status;
        this.traceNumber = traceNumber;
        this.return_ = return_;
        this.correction = correction;
        this.companyEntryDescription = companyEntryDescription;
        this.originatingCompanyName = originatingCompanyName;
        this.secCode = secCode;
        this.canceledOn = canceledOn;
        this.initiatedOn = initiatedOn;
        this.originatedOn = originatedOn;
        this.correctedOn = correctedOn;
        this.returnedOn = returnedOn;
        this.failedOn = failedOn;
        this.completedOn = completedOn;
        this.debitHoldPeriod = debitHoldPeriod;
    }
    
    public ACHTransactionDetails(
            ACHTransactionStatus status,
            String traceNumber) {
        this(status, traceNumber, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Status of a transaction within the ACH lifecycle.
     */
    @JsonIgnore
    public ACHTransactionStatus status() {
        return status;
    }

    @JsonIgnore
    public String traceNumber() {
        return traceNumber;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<ACHException> return_() {
        return (Optional<ACHException>) return_;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<ACHException> correction() {
        return (Optional<ACHException>) correction;
    }

    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    @JsonIgnore
    public Optional<String> companyEntryDescription() {
        return companyEntryDescription;
    }

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    @JsonIgnore
    public Optional<String> originatingCompanyName() {
        return originatingCompanyName;
    }

    /**
     * Code used to identify the ACH authorization method.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<SECCode> secCode() {
        return (Optional<SECCode>) secCode;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> canceledOn() {
        return canceledOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> initiatedOn() {
        return initiatedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> originatedOn() {
        return originatedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> correctedOn() {
        return correctedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> returnedOn() {
        return returnedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> failedOn() {
        return failedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> completedOn() {
        return completedOn;
    }

    /**
     * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<DebitHoldPeriod> debitHoldPeriod() {
        return (Optional<DebitHoldPeriod>) debitHoldPeriod;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Status of a transaction within the ACH lifecycle.
     */
    public ACHTransactionDetails withStatus(ACHTransactionStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public ACHTransactionDetails withTraceNumber(String traceNumber) {
        Utils.checkNotNull(traceNumber, "traceNumber");
        this.traceNumber = traceNumber;
        return this;
    }

    public ACHTransactionDetails withReturn(ACHException return_) {
        Utils.checkNotNull(return_, "return_");
        this.return_ = Optional.ofNullable(return_);
        return this;
    }

    public ACHTransactionDetails withReturn(Optional<? extends ACHException> return_) {
        Utils.checkNotNull(return_, "return_");
        this.return_ = return_;
        return this;
    }

    public ACHTransactionDetails withCorrection(ACHException correction) {
        Utils.checkNotNull(correction, "correction");
        this.correction = Optional.ofNullable(correction);
        return this;
    }

    public ACHTransactionDetails withCorrection(Optional<? extends ACHException> correction) {
        Utils.checkNotNull(correction, "correction");
        this.correction = correction;
        return this;
    }

    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    public ACHTransactionDetails withCompanyEntryDescription(String companyEntryDescription) {
        Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
        this.companyEntryDescription = Optional.ofNullable(companyEntryDescription);
        return this;
    }

    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    public ACHTransactionDetails withCompanyEntryDescription(Optional<String> companyEntryDescription) {
        Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
        this.companyEntryDescription = companyEntryDescription;
        return this;
    }

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    public ACHTransactionDetails withOriginatingCompanyName(String originatingCompanyName) {
        Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
        this.originatingCompanyName = Optional.ofNullable(originatingCompanyName);
        return this;
    }

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    public ACHTransactionDetails withOriginatingCompanyName(Optional<String> originatingCompanyName) {
        Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
        this.originatingCompanyName = originatingCompanyName;
        return this;
    }

    /**
     * Code used to identify the ACH authorization method.
     */
    public ACHTransactionDetails withSecCode(SECCode secCode) {
        Utils.checkNotNull(secCode, "secCode");
        this.secCode = Optional.ofNullable(secCode);
        return this;
    }

    /**
     * Code used to identify the ACH authorization method.
     */
    public ACHTransactionDetails withSecCode(Optional<? extends SECCode> secCode) {
        Utils.checkNotNull(secCode, "secCode");
        this.secCode = secCode;
        return this;
    }

    public ACHTransactionDetails withCanceledOn(OffsetDateTime canceledOn) {
        Utils.checkNotNull(canceledOn, "canceledOn");
        this.canceledOn = Optional.ofNullable(canceledOn);
        return this;
    }

    public ACHTransactionDetails withCanceledOn(Optional<OffsetDateTime> canceledOn) {
        Utils.checkNotNull(canceledOn, "canceledOn");
        this.canceledOn = canceledOn;
        return this;
    }

    public ACHTransactionDetails withInitiatedOn(OffsetDateTime initiatedOn) {
        Utils.checkNotNull(initiatedOn, "initiatedOn");
        this.initiatedOn = Optional.ofNullable(initiatedOn);
        return this;
    }

    public ACHTransactionDetails withInitiatedOn(Optional<OffsetDateTime> initiatedOn) {
        Utils.checkNotNull(initiatedOn, "initiatedOn");
        this.initiatedOn = initiatedOn;
        return this;
    }

    public ACHTransactionDetails withOriginatedOn(OffsetDateTime originatedOn) {
        Utils.checkNotNull(originatedOn, "originatedOn");
        this.originatedOn = Optional.ofNullable(originatedOn);
        return this;
    }

    public ACHTransactionDetails withOriginatedOn(Optional<OffsetDateTime> originatedOn) {
        Utils.checkNotNull(originatedOn, "originatedOn");
        this.originatedOn = originatedOn;
        return this;
    }

    public ACHTransactionDetails withCorrectedOn(OffsetDateTime correctedOn) {
        Utils.checkNotNull(correctedOn, "correctedOn");
        this.correctedOn = Optional.ofNullable(correctedOn);
        return this;
    }

    public ACHTransactionDetails withCorrectedOn(Optional<OffsetDateTime> correctedOn) {
        Utils.checkNotNull(correctedOn, "correctedOn");
        this.correctedOn = correctedOn;
        return this;
    }

    public ACHTransactionDetails withReturnedOn(OffsetDateTime returnedOn) {
        Utils.checkNotNull(returnedOn, "returnedOn");
        this.returnedOn = Optional.ofNullable(returnedOn);
        return this;
    }

    public ACHTransactionDetails withReturnedOn(Optional<OffsetDateTime> returnedOn) {
        Utils.checkNotNull(returnedOn, "returnedOn");
        this.returnedOn = returnedOn;
        return this;
    }

    public ACHTransactionDetails withFailedOn(OffsetDateTime failedOn) {
        Utils.checkNotNull(failedOn, "failedOn");
        this.failedOn = Optional.ofNullable(failedOn);
        return this;
    }

    public ACHTransactionDetails withFailedOn(Optional<OffsetDateTime> failedOn) {
        Utils.checkNotNull(failedOn, "failedOn");
        this.failedOn = failedOn;
        return this;
    }

    public ACHTransactionDetails withCompletedOn(OffsetDateTime completedOn) {
        Utils.checkNotNull(completedOn, "completedOn");
        this.completedOn = Optional.ofNullable(completedOn);
        return this;
    }

    public ACHTransactionDetails withCompletedOn(Optional<OffsetDateTime> completedOn) {
        Utils.checkNotNull(completedOn, "completedOn");
        this.completedOn = completedOn;
        return this;
    }

    /**
     * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
     */
    public ACHTransactionDetails withDebitHoldPeriod(DebitHoldPeriod debitHoldPeriod) {
        Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
        this.debitHoldPeriod = Optional.ofNullable(debitHoldPeriod);
        return this;
    }

    /**
     * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
     */
    public ACHTransactionDetails withDebitHoldPeriod(Optional<? extends DebitHoldPeriod> debitHoldPeriod) {
        Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
        this.debitHoldPeriod = debitHoldPeriod;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ACHTransactionDetails other = (ACHTransactionDetails) o;
        return 
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.traceNumber, other.traceNumber) &&
            Objects.deepEquals(this.return_, other.return_) &&
            Objects.deepEquals(this.correction, other.correction) &&
            Objects.deepEquals(this.companyEntryDescription, other.companyEntryDescription) &&
            Objects.deepEquals(this.originatingCompanyName, other.originatingCompanyName) &&
            Objects.deepEquals(this.secCode, other.secCode) &&
            Objects.deepEquals(this.canceledOn, other.canceledOn) &&
            Objects.deepEquals(this.initiatedOn, other.initiatedOn) &&
            Objects.deepEquals(this.originatedOn, other.originatedOn) &&
            Objects.deepEquals(this.correctedOn, other.correctedOn) &&
            Objects.deepEquals(this.returnedOn, other.returnedOn) &&
            Objects.deepEquals(this.failedOn, other.failedOn) &&
            Objects.deepEquals(this.completedOn, other.completedOn) &&
            Objects.deepEquals(this.debitHoldPeriod, other.debitHoldPeriod);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            status,
            traceNumber,
            return_,
            correction,
            companyEntryDescription,
            originatingCompanyName,
            secCode,
            canceledOn,
            initiatedOn,
            originatedOn,
            correctedOn,
            returnedOn,
            failedOn,
            completedOn,
            debitHoldPeriod);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ACHTransactionDetails.class,
                "status", status,
                "traceNumber", traceNumber,
                "return_", return_,
                "correction", correction,
                "companyEntryDescription", companyEntryDescription,
                "originatingCompanyName", originatingCompanyName,
                "secCode", secCode,
                "canceledOn", canceledOn,
                "initiatedOn", initiatedOn,
                "originatedOn", originatedOn,
                "correctedOn", correctedOn,
                "returnedOn", returnedOn,
                "failedOn", failedOn,
                "completedOn", completedOn,
                "debitHoldPeriod", debitHoldPeriod);
    }
    
    public final static class Builder {
 
        private ACHTransactionStatus status;
 
        private String traceNumber;
 
        private Optional<? extends ACHException> return_ = Optional.empty();
 
        private Optional<? extends ACHException> correction = Optional.empty();
 
        private Optional<String> companyEntryDescription = Optional.empty();
 
        private Optional<String> originatingCompanyName = Optional.empty();
 
        private Optional<? extends SECCode> secCode = Optional.empty();
 
        private Optional<OffsetDateTime> canceledOn = Optional.empty();
 
        private Optional<OffsetDateTime> initiatedOn = Optional.empty();
 
        private Optional<OffsetDateTime> originatedOn = Optional.empty();
 
        private Optional<OffsetDateTime> correctedOn = Optional.empty();
 
        private Optional<OffsetDateTime> returnedOn = Optional.empty();
 
        private Optional<OffsetDateTime> failedOn = Optional.empty();
 
        private Optional<OffsetDateTime> completedOn = Optional.empty();
 
        private Optional<? extends DebitHoldPeriod> debitHoldPeriod = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Status of a transaction within the ACH lifecycle.
         */
        public Builder status(ACHTransactionStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder traceNumber(String traceNumber) {
            Utils.checkNotNull(traceNumber, "traceNumber");
            this.traceNumber = traceNumber;
            return this;
        }

        public Builder return_(ACHException return_) {
            Utils.checkNotNull(return_, "return_");
            this.return_ = Optional.ofNullable(return_);
            return this;
        }

        public Builder return_(Optional<? extends ACHException> return_) {
            Utils.checkNotNull(return_, "return_");
            this.return_ = return_;
            return this;
        }

        public Builder correction(ACHException correction) {
            Utils.checkNotNull(correction, "correction");
            this.correction = Optional.ofNullable(correction);
            return this;
        }

        public Builder correction(Optional<? extends ACHException> correction) {
            Utils.checkNotNull(correction, "correction");
            this.correction = correction;
            return this;
        }

        /**
         * An optional override of the default NACHA company entry description for a transfer.
         */
        public Builder companyEntryDescription(String companyEntryDescription) {
            Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
            this.companyEntryDescription = Optional.ofNullable(companyEntryDescription);
            return this;
        }

        /**
         * An optional override of the default NACHA company entry description for a transfer.
         */
        public Builder companyEntryDescription(Optional<String> companyEntryDescription) {
            Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
            this.companyEntryDescription = companyEntryDescription;
            return this;
        }

        /**
         * An optional override of the default NACHA company name for a transfer.
         */
        public Builder originatingCompanyName(String originatingCompanyName) {
            Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
            this.originatingCompanyName = Optional.ofNullable(originatingCompanyName);
            return this;
        }

        /**
         * An optional override of the default NACHA company name for a transfer.
         */
        public Builder originatingCompanyName(Optional<String> originatingCompanyName) {
            Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
            this.originatingCompanyName = originatingCompanyName;
            return this;
        }

        /**
         * Code used to identify the ACH authorization method.
         */
        public Builder secCode(SECCode secCode) {
            Utils.checkNotNull(secCode, "secCode");
            this.secCode = Optional.ofNullable(secCode);
            return this;
        }

        /**
         * Code used to identify the ACH authorization method.
         */
        public Builder secCode(Optional<? extends SECCode> secCode) {
            Utils.checkNotNull(secCode, "secCode");
            this.secCode = secCode;
            return this;
        }

        public Builder canceledOn(OffsetDateTime canceledOn) {
            Utils.checkNotNull(canceledOn, "canceledOn");
            this.canceledOn = Optional.ofNullable(canceledOn);
            return this;
        }

        public Builder canceledOn(Optional<OffsetDateTime> canceledOn) {
            Utils.checkNotNull(canceledOn, "canceledOn");
            this.canceledOn = canceledOn;
            return this;
        }

        public Builder initiatedOn(OffsetDateTime initiatedOn) {
            Utils.checkNotNull(initiatedOn, "initiatedOn");
            this.initiatedOn = Optional.ofNullable(initiatedOn);
            return this;
        }

        public Builder initiatedOn(Optional<OffsetDateTime> initiatedOn) {
            Utils.checkNotNull(initiatedOn, "initiatedOn");
            this.initiatedOn = initiatedOn;
            return this;
        }

        public Builder originatedOn(OffsetDateTime originatedOn) {
            Utils.checkNotNull(originatedOn, "originatedOn");
            this.originatedOn = Optional.ofNullable(originatedOn);
            return this;
        }

        public Builder originatedOn(Optional<OffsetDateTime> originatedOn) {
            Utils.checkNotNull(originatedOn, "originatedOn");
            this.originatedOn = originatedOn;
            return this;
        }

        public Builder correctedOn(OffsetDateTime correctedOn) {
            Utils.checkNotNull(correctedOn, "correctedOn");
            this.correctedOn = Optional.ofNullable(correctedOn);
            return this;
        }

        public Builder correctedOn(Optional<OffsetDateTime> correctedOn) {
            Utils.checkNotNull(correctedOn, "correctedOn");
            this.correctedOn = correctedOn;
            return this;
        }

        public Builder returnedOn(OffsetDateTime returnedOn) {
            Utils.checkNotNull(returnedOn, "returnedOn");
            this.returnedOn = Optional.ofNullable(returnedOn);
            return this;
        }

        public Builder returnedOn(Optional<OffsetDateTime> returnedOn) {
            Utils.checkNotNull(returnedOn, "returnedOn");
            this.returnedOn = returnedOn;
            return this;
        }

        public Builder failedOn(OffsetDateTime failedOn) {
            Utils.checkNotNull(failedOn, "failedOn");
            this.failedOn = Optional.ofNullable(failedOn);
            return this;
        }

        public Builder failedOn(Optional<OffsetDateTime> failedOn) {
            Utils.checkNotNull(failedOn, "failedOn");
            this.failedOn = failedOn;
            return this;
        }

        public Builder completedOn(OffsetDateTime completedOn) {
            Utils.checkNotNull(completedOn, "completedOn");
            this.completedOn = Optional.ofNullable(completedOn);
            return this;
        }

        public Builder completedOn(Optional<OffsetDateTime> completedOn) {
            Utils.checkNotNull(completedOn, "completedOn");
            this.completedOn = completedOn;
            return this;
        }

        /**
         * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
         */
        public Builder debitHoldPeriod(DebitHoldPeriod debitHoldPeriod) {
            Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
            this.debitHoldPeriod = Optional.ofNullable(debitHoldPeriod);
            return this;
        }

        /**
         * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
         */
        public Builder debitHoldPeriod(Optional<? extends DebitHoldPeriod> debitHoldPeriod) {
            Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
            this.debitHoldPeriod = debitHoldPeriod;
            return this;
        }
        
        public ACHTransactionDetails build() {
            return new ACHTransactionDetails(
                status,
                traceNumber,
                return_,
                correction,
                companyEntryDescription,
                originatingCompanyName,
                secCode,
                canceledOn,
                initiatedOn,
                originatedOn,
                correctedOn,
                returnedOn,
                failedOn,
                completedOn,
                debitHoldPeriod);
        }
    }
}
