/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class ACHInstitution {

    /**
     * Name of the financial institution.
     */
    @JsonProperty("name")
    private String name;

    @JsonProperty("routingNumber")
    private String routingNumber;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("address")
    private Optional<? extends Address> address;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("contact")
    private Optional<? extends Contact> contact;

    @JsonCreator
    public ACHInstitution(
            @JsonProperty("name") String name,
            @JsonProperty("routingNumber") String routingNumber,
            @JsonProperty("address") Optional<? extends Address> address,
            @JsonProperty("contact") Optional<? extends Contact> contact) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(routingNumber, "routingNumber");
        Utils.checkNotNull(address, "address");
        Utils.checkNotNull(contact, "contact");
        this.name = name;
        this.routingNumber = routingNumber;
        this.address = address;
        this.contact = contact;
    }
    
    public ACHInstitution(
            String name,
            String routingNumber) {
        this(name, routingNumber, Optional.empty(), Optional.empty());
    }

    /**
     * Name of the financial institution.
     */
    @JsonIgnore
    public String name() {
        return name;
    }

    @JsonIgnore
    public String routingNumber() {
        return routingNumber;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Address> address() {
        return (Optional<Address>) address;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Contact> contact() {
        return (Optional<Contact>) contact;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Name of the financial institution.
     */
    public ACHInstitution withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public ACHInstitution withRoutingNumber(String routingNumber) {
        Utils.checkNotNull(routingNumber, "routingNumber");
        this.routingNumber = routingNumber;
        return this;
    }

    public ACHInstitution withAddress(Address address) {
        Utils.checkNotNull(address, "address");
        this.address = Optional.ofNullable(address);
        return this;
    }

    public ACHInstitution withAddress(Optional<? extends Address> address) {
        Utils.checkNotNull(address, "address");
        this.address = address;
        return this;
    }

    public ACHInstitution withContact(Contact contact) {
        Utils.checkNotNull(contact, "contact");
        this.contact = Optional.ofNullable(contact);
        return this;
    }

    public ACHInstitution withContact(Optional<? extends Contact> contact) {
        Utils.checkNotNull(contact, "contact");
        this.contact = contact;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ACHInstitution other = (ACHInstitution) o;
        return 
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.routingNumber, other.routingNumber) &&
            Objects.deepEquals(this.address, other.address) &&
            Objects.deepEquals(this.contact, other.contact);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            name,
            routingNumber,
            address,
            contact);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ACHInstitution.class,
                "name", name,
                "routingNumber", routingNumber,
                "address", address,
                "contact", contact);
    }
    
    public final static class Builder {
 
        private String name;
 
        private String routingNumber;
 
        private Optional<? extends Address> address = Optional.empty();
 
        private Optional<? extends Contact> contact = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Name of the financial institution.
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder routingNumber(String routingNumber) {
            Utils.checkNotNull(routingNumber, "routingNumber");
            this.routingNumber = routingNumber;
            return this;
        }

        public Builder address(Address address) {
            Utils.checkNotNull(address, "address");
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Optional<? extends Address> address) {
            Utils.checkNotNull(address, "address");
            this.address = address;
            return this;
        }

        public Builder contact(Contact contact) {
            Utils.checkNotNull(contact, "contact");
            this.contact = Optional.ofNullable(contact);
            return this;
        }

        public Builder contact(Optional<? extends Contact> contact) {
            Utils.checkNotNull(contact, "contact");
            this.contact = contact;
            return this;
        }
        
        public ACHInstitution build() {
            return new ACHInstitution(
                name,
                routingNumber,
                address,
                contact);
        }
    }
}
