/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.subjects;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.reactive.Observable$;
import monix.reactive.internal.util.PromiseCounter;
import monix.reactive.internal.util.PromiseCounter$;
import monix.reactive.observers.ConnectableSubscriber;
import monix.reactive.observers.ConnectableSubscriber$;
import monix.reactive.observers.Subscriber;
import monix.reactive.subjects.ReplaySubject$;
import monix.reactive.subjects.ReplaySubject$State$;
import monix.reactive.subjects.Subject;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class ReplaySubject<A>
extends Subject<A, A> {
    private final AtomicAny<State<A>> stateRef;

    public static <A> ReplaySubject<A> apply(Seq<A> seq) {
        return ReplaySubject$.MODULE$.apply(seq);
    }

    public static <A> ReplaySubject<A> create(Seq<A> seq) {
        return ReplaySubject$.MODULE$.create(seq);
    }

    public static <A> ReplaySubject<A> createLimited(int n) {
        return ReplaySubject$.MODULE$.createLimited(n);
    }

    public static <A> ReplaySubject<A> createLimited(int n, Seq<A> seq) {
        return ReplaySubject$.MODULE$.createLimited(n, seq);
    }

    public ReplaySubject(State<A> initialState) {
        AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
        this.stateRef = (AtomicAny)builder$proxy1.buildInstance(initialState, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    }

    @Override
    public int size() {
        return ((State)this.stateRef.get()).subscribers().size();
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        return this.subscribeLoop$1(subscriber);
    }

    @Override
    public Future<Ack> onNext(A elem) {
        Future future;
        block9: {
            State<A> newState;
            State state;
            ReplaySubject replaySubject = this;
            do {
                if (!(state = (State)replaySubject.stateRef.get()).isDone()) continue;
                future = Ack.Stop$.MODULE$;
                break block9;
            } while (!replaySubject.stateRef.compareAndSet((Object)state, newState = state.appendElem(elem)));
            Iterator iterator = state.subscribers().iterator();
            ObjectRef result = ObjectRef.create(null);
            while (iterator.hasNext()) {
                Future future2;
                ConnectableSubscriber subscriber = (ConnectableSubscriber)iterator.next();
                try {
                    future2 = subscriber.onNext(elem);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        future2 = Future$.MODULE$.failed(ex);
                    }
                    throw throwable;
                }
                Future ack = future2;
                if (ack.isCompleted()) {
                    Future future3 = ack;
                    Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                    if (!(future3 == null ? continue$ != null : !future3.equals(continue$))) continue;
                    Object object = ack.value().get();
                    Success success = Ack.Continue$.MODULE$.AsSuccess();
                    if (!(object == null ? success != null : !object.equals(success))) continue;
                    replaySubject.removeSubscriber(subscriber);
                    continue;
                }
                if ((PromiseCounter)result.elem == null) {
                    PromiseCounter promiseCounter;
                    result.elem = promiseCounter = PromiseCounter$.MODULE$.apply(Ack.Continue$.MODULE$, 1);
                    promiseCounter = null;
                }
                ((PromiseCounter)result.elem).acquire();
                ack.onComplete((Function1 & Serializable)x$1 -> {
                    ReplaySubject.onNext$$anonfun$1(result, subscriber, replaySubject, x$1);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)subscriber.scheduler());
            }
            if ((PromiseCounter)result.elem == null) {
                future = Ack.Continue$.MODULE$;
            } else {
                ((PromiseCounter)result.elem).countdown();
                future = ((PromiseCounter)result.elem).future();
            }
        }
        return future;
    }

    @Override
    public void onError(Throwable ex) {
        this.onCompleteOrError(ex);
    }

    @Override
    public void onComplete() {
        this.onCompleteOrError(null);
    }

    private void onCompleteOrError(Throwable ex) {
        State state;
        ReplaySubject replaySubject = this;
        while (!(state = (State)replaySubject.stateRef.get()).isDone()) {
            if (!replaySubject.stateRef.compareAndSet((Object)state, state.markDone(ex))) continue;
            for (ConnectableSubscriber ref : state.subscribers()) {
                if (ex != null) {
                    ref.onError(ex);
                    continue;
                }
                ref.onComplete();
            }
        }
    }

    private void removeSubscriber(ConnectableSubscriber<A> s) {
        State<A> newState;
        State state;
        ReplaySubject replaySubject = this;
        while (!replaySubject.stateRef.compareAndSet((Object)(state = (State)replaySubject.stateRef.get()), newState = state.removeSubscriber(s))) {
        }
    }

    private static final Cancelable streamOnDone$1(Subscriber subscriber$1, Iterable buffer, Throwable errorThrown) {
        return Observable$.MODULE$.fromIterable(buffer).unsafeSubscribeFn(new Subscriber<A>(subscriber$1, errorThrown){
            private final Subscriber subscriber$3;
            private final Throwable errorThrown$4;
            private final Scheduler scheduler;
            {
                this.subscriber$3 = subscriber$2;
                this.errorThrown$4 = errorThrown$3;
                this.scheduler = subscriber$2.scheduler();
            }

            public Scheduler scheduler() {
                return this.scheduler;
            }

            public Future onNext(Object elem) {
                return this.subscriber$3.onNext(elem);
            }

            public void onError(Throwable ex) {
                this.subscriber$3.onError(ex);
            }

            public void onComplete() {
                if (this.errorThrown$4 != null) {
                    this.subscriber$3.onError(this.errorThrown$4);
                } else {
                    this.subscriber$3.onComplete();
                }
            }
        });
    }

    private final /* synthetic */ void subscribeLoop$1$$anonfun$1(ConnectableSubscriber c$1, Option _$1) {
        this.removeSubscriber(c$1);
    }

    private final /* synthetic */ void subscribeLoop$1$$anonfun$2(ConnectableSubscriber c$2, CancelableFuture connecting$1) {
        try {
            this.removeSubscriber(c$2);
        }
        finally {
            connecting$1.cancel();
        }
    }

    private final Cancelable subscribeLoop$1(Subscriber subscriber$4) {
        Cancelable cancelable;
        block1: {
            Seq buffer;
            ConnectableSubscriber c;
            State newState;
            State state;
            do {
                state = (State)this.stateRef.get();
                buffer = state.buffer();
                if (!state.isDone()) continue;
                cancelable = ReplaySubject.streamOnDone$1(subscriber$4, buffer, state.errorThrown());
                break block1;
            } while (!this.stateRef.compareAndSet((Object)state, newState = state.addNewSubscriber(c = ConnectableSubscriber$.MODULE$.apply(subscriber$4))));
            c.pushFirstAll(buffer);
            CancelableFuture<Ack> connecting = c.connect();
            CancelableFuture cancelableFuture = (CancelableFuture)Ack$.MODULE$.AckExtensions(connecting);
            Ack.AckExtensions$.MODULE$.syncOnStopOrFailure$extension((Future)cancelableFuture, (Function1 & Serializable)_$1 -> {
                this.subscribeLoop$1$$anonfun$1(c, (Option)_$1);
                return BoxedUnit.UNIT;
            }, (UncaughtExceptionReporter)subscriber$4.scheduler());
            cancelable = Cancelable$.MODULE$.apply((Function0 & Serializable)() -> {
                this.subscribeLoop$1$$anonfun$2(c, connecting);
                return BoxedUnit.UNIT;
            });
        }
        return cancelable;
    }

    private static final /* synthetic */ void onNext$$anonfun$1(ObjectRef result$1, ConnectableSubscriber subscriber$5, ReplaySubject $this$1, Try x$1) {
        Try try_ = x$1;
        Success success = Ack.Continue$.MODULE$.AsSuccess();
        Try try_2 = try_;
        if (!(success != null ? !success.equals(try_2) : try_2 != null)) {
            ((PromiseCounter)result$1.elem).countdown();
        } else {
            $this$1.removeSubscriber(subscriber$5);
            ((PromiseCounter)result$1.elem).countdown();
        }
    }

    private static final class State<A>
    implements Product,
    Serializable {
        private final Seq buffer;
        private final int capacity;
        private final Set subscribers;
        private final int length;
        private final boolean isDone;
        private final Throwable errorThrown;

        public static <A> State<A> apply(Seq<A> seq, int n, Set<ConnectableSubscriber<A>> set, int n2, boolean bl, Throwable throwable) {
            return ReplaySubject$State$.MODULE$.apply(seq, n, set, n2, bl, throwable);
        }

        public static State<?> fromProduct(Product product) {
            return ReplaySubject$State$.MODULE$.fromProduct(product);
        }

        public static <A> State<A> unapply(State<A> state) {
            return ReplaySubject$State$.MODULE$.unapply(state);
        }

        public static <A> Set<ConnectableSubscriber<A>> $lessinit$greater$default$3() {
            return ReplaySubject$State$.MODULE$.$lessinit$greater$default$3();
        }

        public static <A> int $lessinit$greater$default$4() {
            return ReplaySubject$State$.MODULE$.$lessinit$greater$default$4();
        }

        public static <A> boolean $lessinit$greater$default$5() {
            return ReplaySubject$State$.MODULE$.$lessinit$greater$default$5();
        }

        public static <A> Throwable $lessinit$greater$default$6() {
            return ReplaySubject$State$.MODULE$.$lessinit$greater$default$6();
        }

        public State(Seq<A> buffer, int capacity, Set<ConnectableSubscriber<A>> subscribers, int length, boolean isDone, Throwable errorThrown) {
            this.buffer = buffer;
            this.capacity = capacity;
            this.subscribers = subscribers;
            this.length = length;
            this.isDone = isDone;
            this.errorThrown = errorThrown;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.buffer()));
            n = Statics.mix((int)n, (int)this.capacity());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.subscribers()));
            n = Statics.mix((int)n, (int)this.length());
            n = Statics.mix((int)n, (int)(this.isDone() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.errorThrown()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.capacity() != state.capacity()) return false;
            if (this.length() != state.length()) return false;
            if (this.isDone() != state.isDone()) return false;
            Seq<A> seq = this.buffer();
            Seq<A> seq2 = state.buffer();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Set<ConnectableSubscriber<A>> set = this.subscribers();
            Set<ConnectableSubscriber<A>> set2 = state.subscribers();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Throwable throwable = this.errorThrown();
            Throwable throwable2 = state.errorThrown();
            if (throwable == null) {
                if (throwable2 == null) return true;
                return false;
            } else {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this._4());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._5());
                    break;
                }
                case 5: {
                    object = this._6();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "buffer";
                    break;
                }
                case 1: {
                    string = "capacity";
                    break;
                }
                case 2: {
                    string = "subscribers";
                    break;
                }
                case 3: {
                    string = "length";
                    break;
                }
                case 4: {
                    string = "isDone";
                    break;
                }
                case 5: {
                    string = "errorThrown";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Seq<A> buffer() {
            return this.buffer;
        }

        public int capacity() {
            return this.capacity;
        }

        public Set<ConnectableSubscriber<A>> subscribers() {
            return this.subscribers;
        }

        public int length() {
            return this.length;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public Throwable errorThrown() {
            return this.errorThrown;
        }

        public State<A> appendElem(A elem) {
            State<A> state;
            if (this.capacity() == 0) {
                state = this.copy((Seq)this.buffer().$colon$plus(elem), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
            } else if (this.length() >= this.capacity()) {
                state = this.copy((Seq)((SeqOps)this.buffer().tail()).$colon$plus(elem), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
            } else {
                Seq seq = (Seq)this.buffer().$colon$plus(elem);
                int n = this.length() + 1;
                int n2 = this.copy$default$2();
                Set<ConnectableSubscriber<A>> set = this.copy$default$3();
                boolean bl = this.copy$default$5();
                Throwable throwable = this.copy$default$6();
                state = this.copy(seq, n2, set, n, bl, throwable);
            }
            return state;
        }

        public State<A> addNewSubscriber(ConnectableSubscriber<A> s) {
            Set set = (Set)this.subscribers().$plus(s);
            Seq<A> seq = this.copy$default$1();
            int n = this.copy$default$2();
            int n2 = this.copy$default$4();
            boolean bl = this.copy$default$5();
            Throwable throwable = this.copy$default$6();
            return this.copy(seq, n, set, n2, bl, throwable);
        }

        public State<A> removeSubscriber(ConnectableSubscriber<A> toRemove) {
            Set newSet = (Set)this.subscribers().$minus(toRemove);
            return this.copy(this.copy$default$1(), this.copy$default$2(), newSet, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }

        public State<A> markDone(Throwable ex) {
            Set set = Predef$.MODULE$.Set().empty();
            Seq<A> seq = this.copy$default$1();
            int n = this.copy$default$2();
            int n2 = this.copy$default$4();
            return this.copy(seq, n, set, n2, true, ex);
        }

        public <A> State<A> copy(Seq<A> buffer, int capacity, Set<ConnectableSubscriber<A>> subscribers, int length, boolean isDone, Throwable errorThrown) {
            return new State<A>(buffer, capacity, subscribers, length, isDone, errorThrown);
        }

        public <A> Seq<A> copy$default$1() {
            return this.buffer();
        }

        public int copy$default$2() {
            return this.capacity();
        }

        public <A> Set<ConnectableSubscriber<A>> copy$default$3() {
            return this.subscribers();
        }

        public int copy$default$4() {
            return this.length();
        }

        public boolean copy$default$5() {
            return this.isDone();
        }

        public <A> Throwable copy$default$6() {
            return this.errorThrown();
        }

        public Seq<A> _1() {
            return this.buffer();
        }

        public int _2() {
            return this.capacity();
        }

        public Set<ConnectableSubscriber<A>> _3() {
            return this.subscribers();
        }

        public int _4() {
            return this.length();
        }

        public boolean _5() {
            return this.isDone();
        }

        public Throwable _6() {
            return this.errorThrown();
        }
    }
}

