/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.subjects;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.reactive.internal.util.PromiseCounter;
import monix.reactive.internal.util.PromiseCounter$;
import monix.reactive.observers.Subscriber;
import monix.reactive.subjects.PublishSubject$;
import monix.reactive.subjects.PublishSubject$State$;
import monix.reactive.subjects.Subject;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class PublishSubject<A>
extends Subject<A, A> {
    private final AtomicAny<State<A>> stateRef;

    public static <A> PublishSubject<A> apply() {
        return PublishSubject$.MODULE$.apply();
    }

    public PublishSubject() {
        State initialValue$proxy1 = PublishSubject$State$.MODULE$.apply(PublishSubject$State$.MODULE$.$lessinit$greater$default$1(), (Subscriber[])PublishSubject$State$.MODULE$.$lessinit$greater$default$2(), PublishSubject$State$.MODULE$.$lessinit$greater$default$3());
        AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
        this.stateRef = (AtomicAny)builder$proxy1.buildInstance(initialValue$proxy1, (PaddingStrategy)PaddingStrategy.LeftRight128$.MODULE$, true);
    }

    private Cancelable onSubscribeCompleted(Subscriber<A> subscriber, Throwable ex) {
        if (ex != null) {
            subscriber.onError(ex);
        } else {
            subscriber.onComplete();
        }
        return Cancelable$.MODULE$.empty();
    }

    @Override
    public int size() {
        return ((State)this.stateRef.get()).subscribers().size();
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        Cancelable cancelable;
        block1: {
            Set subscribers;
            State update;
            State state;
            PublishSubject publishSubject = this;
            do {
                if ((subscribers = (state = (State)publishSubject.stateRef.get()).subscribers()) != null) continue;
                cancelable = publishSubject.onSubscribeCompleted(subscriber, state.errorThrown());
                break block1;
            } while (!publishSubject.stateRef.compareAndSet((Object)state, update = PublishSubject$State$.MODULE$.apply((Set)subscribers.$plus(subscriber), (Subscriber[])PublishSubject$State$.MODULE$.$lessinit$greater$default$2(), PublishSubject$State$.MODULE$.$lessinit$greater$default$3())));
            cancelable = Cancelable$.MODULE$.apply((Function0 & Serializable)() -> {
                publishSubject.unsubscribe(subscriber);
                return BoxedUnit.UNIT;
            });
        }
        return cancelable;
    }

    @Override
    public Future<Ack> onNext(A elem) {
        Future<Ack> future;
        State state = (State)this.stateRef.get();
        Subscriber<A>[] subscribersArray = state.cache();
        if (subscribersArray == null) {
            Set set = state.subscribers();
            if (set == null) {
                future = Ack.Stop$.MODULE$;
            } else {
                State update = state.refresh();
                this.stateRef.compareAndSet((Object)state, update);
                future = this.sendOnNextToAll(update.cache(), elem);
            }
        } else {
            future = this.sendOnNextToAll(subscribersArray, elem);
        }
        return future;
    }

    @Override
    public void onError(Throwable ex) {
        this.sendOnCompleteOrError(ex);
    }

    @Override
    public void onComplete() {
        this.sendOnCompleteOrError(null);
    }

    private Future<Ack> sendOnNextToAll(Subscriber<A>[] subscribers, A elem) {
        Future future;
        ObjectRef result = ObjectRef.create(null);
        int index = 0;
        while (index < subscribers.length) {
            Future future2;
            Subscriber<A> subscriber = subscribers[index];
            ++index;
            try {
                future2 = subscriber.onNext(elem);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable ex = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(ex)) {
                    future2 = Future$.MODULE$.failed(ex);
                }
                throw throwable;
            }
            Future ack = future2;
            if (ack.isCompleted()) {
                Future future3 = ack;
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(future3 == null ? continue$ != null : !future3.equals(continue$))) continue;
                Object object = ack.value().get();
                Success success = Ack.Continue$.MODULE$.AsSuccess();
                if (!(object == null ? success != null : !object.equals(success))) continue;
                this.unsubscribe(subscriber);
                continue;
            }
            if ((PromiseCounter)result.elem == null) {
                PromiseCounter promiseCounter;
                result.elem = promiseCounter = PromiseCounter$.MODULE$.apply(Ack.Continue$.MODULE$, 1);
                promiseCounter = null;
            }
            ((PromiseCounter)result.elem).acquire();
            ack.onComplete((Function1 & Serializable)x$1 -> {
                this.sendOnNextToAll$$anonfun$1(result, subscriber, (Try)x$1);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)subscriber.scheduler());
        }
        if ((PromiseCounter)result.elem == null) {
            future = Ack.Continue$.MODULE$;
        } else {
            ((PromiseCounter)result.elem).countdown();
            future = ((PromiseCounter)result.elem).future();
        }
        return future;
    }

    private void sendOnCompleteOrError(Throwable ex) {
        block5: {
            Seq set;
            State state;
            PublishSubject publishSubject = this;
            do {
                Seq seq;
                state = (State)publishSubject.stateRef.get();
                set = state.subscribers();
                if (state.cache() != null) {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])state.cache());
                    seq = ArrayOps$.MODULE$.toSeq$extension(object);
                } else {
                    seq = set;
                }
                Iterable subscribers = (Iterable)seq;
                if (subscribers == null) break block5;
            } while (!publishSubject.stateRef.compareAndSet((Object)state, state.complete(ex)));
            for (Subscriber ref : set) {
                if (ex != null) {
                    ref.onError(ex);
                    continue;
                }
                ref.onComplete();
            }
        }
    }

    private Ack unsubscribe(Subscriber<A> subscriber) {
        Ack.Continue$ continue$;
        block1: {
            Set subscribers;
            State update;
            State state;
            PublishSubject publishSubject = this;
            do {
                if ((subscribers = (state = (State)publishSubject.stateRef.get()).subscribers()) != null) continue;
                continue$ = Ack.Continue$.MODULE$;
                break block1;
            } while (!publishSubject.stateRef.compareAndSet((Object)state, update = PublishSubject$State$.MODULE$.apply((Set)subscribers.$minus(subscriber), (Subscriber[])PublishSubject$State$.MODULE$.$lessinit$greater$default$2(), PublishSubject$State$.MODULE$.$lessinit$greater$default$3())));
            continue$ = Ack.Continue$.MODULE$;
        }
        return continue$;
    }

    private final /* synthetic */ void sendOnNextToAll$$anonfun$1(ObjectRef result$1, Subscriber subscriber$2, Try x$1) {
        Try try_ = x$1;
        Success success = Ack.Continue$.MODULE$.AsSuccess();
        Try try_2 = try_;
        if (!(success != null ? !success.equals(try_2) : try_2 != null)) {
            ((PromiseCounter)result$1.elem).countdown();
        } else {
            this.unsubscribe(subscriber$2);
            ((PromiseCounter)result$1.elem).countdown();
        }
    }

    public static final class State<A>
    implements Product,
    Serializable {
        private final Set subscribers;
        private final Subscriber[] cache;
        private final Throwable errorThrown;

        public static <A> State<A> apply(Set<Subscriber<A>> set, Subscriber<A>[] subscriberArray, Throwable throwable) {
            return PublishSubject$State$.MODULE$.apply(set, subscriberArray, throwable);
        }

        public static State<?> fromProduct(Product product) {
            return PublishSubject$State$.MODULE$.fromProduct(product);
        }

        public static <A> State<A> unapply(State<A> state) {
            return PublishSubject$State$.MODULE$.unapply(state);
        }

        public static <A> Set<Subscriber<A>> $lessinit$greater$default$1() {
            return PublishSubject$State$.MODULE$.$lessinit$greater$default$1();
        }

        public static <A> Null$ $lessinit$greater$default$2() {
            return PublishSubject$State$.MODULE$.$lessinit$greater$default$2();
        }

        public static <A> Throwable $lessinit$greater$default$3() {
            return PublishSubject$State$.MODULE$.$lessinit$greater$default$3();
        }

        public State(Set<Subscriber<A>> subscribers, Subscriber<A>[] cache, Throwable errorThrown) {
            this.subscribers = subscribers;
            this.cache = cache;
            this.errorThrown = errorThrown;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            Set<Subscriber<A>> set = this.subscribers();
            Set<Subscriber<A>> set2 = state.subscribers();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (this.cache() != state.cache()) return false;
            Throwable throwable = this.errorThrown();
            Throwable throwable2 = state.errorThrown();
            if (throwable == null) {
                if (throwable2 == null) return true;
                return false;
            } else {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "subscribers";
                    break;
                }
                case 1: {
                    string = "cache";
                    break;
                }
                case 2: {
                    string = "errorThrown";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Set<Subscriber<A>> subscribers() {
            return this.subscribers;
        }

        public Subscriber<A>[] cache() {
            return this.cache;
        }

        public Throwable errorThrown() {
            return this.errorThrown;
        }

        public State<A> refresh() {
            Subscriber[] subscriberArray = (Subscriber[])this.subscribers().toArray(ClassTag$.MODULE$.apply(Subscriber.class));
            Set<Subscriber<A>> set = this.copy$default$1();
            Throwable throwable = this.copy$default$3();
            return this.copy(set, subscriberArray, throwable);
        }

        public boolean isDone() {
            return this.subscribers() == null;
        }

        public State<A> complete(Throwable errorThrown) {
            return this.subscribers() == null ? this : PublishSubject$State$.MODULE$.apply(null, null, errorThrown);
        }

        public <A> State<A> copy(Set<Subscriber<A>> subscribers, Subscriber<A>[] cache, Throwable errorThrown) {
            return new State<A>(subscribers, cache, errorThrown);
        }

        public <A> Set<Subscriber<A>> copy$default$1() {
            return this.subscribers();
        }

        public <A> Subscriber<A>[] copy$default$2() {
            return this.cache();
        }

        public <A> Throwable copy$default$3() {
            return this.errorThrown();
        }

        public Set<Subscriber<A>> _1() {
            return this.subscribers();
        }

        public Subscriber<A>[] _2() {
            return this.cache();
        }

        public Throwable _3() {
            return this.errorThrown();
        }
    }
}

