/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.subscribers;

import monix.execution.Ack;
import monix.execution.Callback;
import monix.execution.Scheduler;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class ForeachSubscriber<A>
implements Subscriber.Sync<A> {
    private final Function1<A, BoxedUnit> f;
    private final Callback<Throwable, BoxedUnit> onFinish;
    private final Scheduler scheduler;
    private boolean isDone;

    public ForeachSubscriber(Function1<A, BoxedUnit> f, Callback<Throwable, BoxedUnit> onFinish, Scheduler s) {
        this.f = f;
        this.onFinish = onFinish;
        this.scheduler = s;
        this.isDone = false;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public Ack onNext(A elem) {
        Ack.Continue$ continue$;
        try {
            this.f.apply(elem);
            continue$ = Ack.Continue$.MODULE$;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                this.onError(ex);
                continue$ = Ack.Stop$.MODULE$;
            }
            throw throwable;
        }
        return (Ack)continue$;
    }

    @Override
    public void onError(Throwable ex) {
        if (!this.isDone) {
            this.isDone = true;
            this.onFinish.onError((Object)ex);
        }
    }

    @Override
    public void onComplete() {
        if (!this.isDone) {
            this.isDone = true;
            this.onFinish.onSuccess((Object)BoxedUnit.UNIT);
        }
    }
}

