/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.cancelables.SingleAssignCancelable;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.reactive.Observable;
import monix.reactive.Pipe;
import monix.reactive.observables.ConnectableObservable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

public final class PipeThroughSelectorObservable<A, B, C>
extends Observable<C> {
    private final Observable<A> source;
    private final Pipe<A, B> pipe;
    private final Function1<Observable<B>, Observable<C>> f;

    public PipeThroughSelectorObservable(Observable<A> source, Pipe<A, B> pipe, Function1<Observable<B>, Observable<C>> f) {
        this.source = source;
        this.pipe = pipe;
        this.f = f;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<C> out) {
        Cancelable cancelable;
        boolean streamErrors = true;
        SingleAssignCancelable upstream = SingleAssignCancelable$.MODULE$.apply();
        try {
            ConnectableObservable<B> connectable = this.source.multicast(this.pipe, out.scheduler());
            Observable observable = (Observable)this.f.apply(connectable);
            streamErrors = false;
            Cancelable downstream = observable.unsafeSubscribeFn(new Subscriber<C>(out, upstream){
                private final Subscriber out$2;
                private final SingleAssignCancelable upstream$2;
                private final Scheduler scheduler;
                {
                    this.out$2 = out$1;
                    this.upstream$2 = upstream$1;
                    this.scheduler = out$1.scheduler();
                }

                public Scheduler scheduler() {
                    return this.scheduler;
                }

                public void onError(Throwable ex) {
                    this.out$2.onError(ex);
                }

                public void onComplete() {
                    this.out$2.onComplete();
                }

                public Future onNext(Object elem) {
                    Future future = Ack$.MODULE$.AckExtensions(this.out$2.onNext(elem));
                    return Ack.AckExtensions$.MODULE$.syncOnStopOrFailure$extension(future, (Function1 & Serializable)_$1 -> {
                        this.onNext$$anonfun$1((Option)_$1);
                        return BoxedUnit.UNIT;
                    }, (UncaughtExceptionReporter)this.scheduler());
                }

                private final /* synthetic */ void onNext$$anonfun$1(Option _$1) {
                    this.upstream$2.cancel();
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onNext$$anonfun$adapted$1(scala.Option )}, serializedLambda);
                }
            });
            upstream.$colon$eq(connectable.connect());
            cancelable = Cancelable$.MODULE$.apply((Function0 & Serializable)() -> {
                PipeThroughSelectorObservable.unsafeSubscribeFn$$anonfun$1(upstream, downstream);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                upstream.cancel();
                if (streamErrors) {
                    out.onError(ex);
                } else {
                    out.scheduler().reportFailure(ex);
                }
                cancelable = Cancelable$.MODULE$.empty();
            }
            throw throwable;
        }
        return cancelable;
    }

    private static final /* synthetic */ void unsafeSubscribeFn$$anonfun$1(SingleAssignCancelable upstream$3, Cancelable downstream$1) {
        upstream$3.cancel();
        downstream$1.cancel();
    }
}

