/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.execution.internal.Platform$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class LinesReaderObservable
extends Observable<String> {
    private final BufferedReader in;
    private final AtomicBoolean wasSubscribed;

    public LinesReaderObservable(Reader reader) {
        this.in = !(reader instanceof BufferedReader) ? new BufferedReader(reader) : (BufferedReader)reader;
        this.wasSubscribed = (AtomicBoolean)AtomicBuilder$.MODULE$.AtomicBooleanBuilder().buildInstance((Object)BoxesRunTime.boxToBoolean((boolean)false), (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<String> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            out.onError((Throwable)APIContractViolationException$.MODULE$.apply("LinesReaderObservable does not support multiple subscribers"));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            void var2_2;
            BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
            ExecutionModel em = out.scheduler().executionModel();
            this.reschedule((Future<Ack>)Ack.Continue$.MODULE$, out, cancelable2, em, out.scheduler());
            cancelable = var2_2;
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, Subscriber<String> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1 & Serializable)x$1 -> {
            this.reschedule$$anonfun$1(out, c, em, s, (Try)x$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)s);
    }

    private void fastLoop(Subscriber<String> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block12: {
            boolean streamErrors;
            Throwable errorThrown;
            LinesReaderObservable linesReaderObservable;
            block11: {
                int nextIndex;
                Ack.Continue$ ack;
                linesReaderObservable = this;
                int n = syncIndex;
                while (true) {
                    int n2;
                    errorThrown = null;
                    ack = Ack.Continue$.MODULE$;
                    streamErrors = true;
                    try {
                        Ack.Stop$ stop$;
                        String next = linesReaderObservable.in.readLine();
                        streamErrors = false;
                        if (next != null) {
                            stop$ = out.onNext(next);
                        } else {
                            out.onComplete();
                            stop$ = Ack.Stop$.MODULE$;
                        }
                        ack = stop$;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            errorThrown = ex;
                        }
                        throw throwable;
                    }
                    if (errorThrown != null) break block11;
                    Ack.Continue$ continue$ = ack;
                    Ack.Continue$ continue$2 = Ack.Continue$.MODULE$;
                    if (!(continue$ != null ? !continue$.equals(continue$2) : continue$2 != null)) {
                        n2 = em.nextFrameIndex(n);
                    } else {
                        Ack.Continue$ continue$3 = ack;
                        Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                        n2 = !(continue$3 != null ? !continue$3.equals(stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                    }
                    if (c.isCanceled()) break block12;
                    if (nextIndex <= 0) break;
                    LinesReaderObservable linesReaderObservable2 = linesReaderObservable;
                    int n3 = nextIndex;
                    linesReaderObservable = linesReaderObservable2;
                    n = n3;
                }
                if (nextIndex >= 0) {
                    linesReaderObservable.reschedule((Future<Ack>)ack, out, c, em, s);
                }
                break block12;
            }
            if (streamErrors) {
                linesReaderObservable.sendError(out, errorThrown, (UncaughtExceptionReporter)s);
            } else {
                linesReaderObservable.reportFailure(errorThrown, (UncaughtExceptionReporter)s);
            }
        }
    }

    private void sendError(Subscriber<Nothing$> out, Throwable e, UncaughtExceptionReporter s) {
        try {
            out.onError(e);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e2 = throwable3 = (Throwable)option.get();
                this.reportFailure(Platform$.MODULE$.composeErrors(e, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{e2})), s);
            }
            throw throwable;
        }
    }

    private void reportFailure(Throwable e, UncaughtExceptionReporter s) {
        s.reportFailure(e);
        try {
            this.in.close();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
            }
            throw throwable;
        }
    }

    private final void reschedule$$anonfun$1$$anonfun$1(Subscriber out$2, BooleanCancelable c$2, ExecutionModel em$2, Scheduler s$2) {
        this.fastLoop(out$2, c$2, em$2, 0, s$2);
    }

    private final /* synthetic */ void reschedule$$anonfun$1(Subscriber out$1, BooleanCancelable c$1, ExecutionModel em$1, Scheduler s$1, Try x$1) {
        Try try_ = x$1;
        if (try_ instanceof Success) {
            Ack next;
            Ack ack = next = (Ack)((Success)try_).value();
            Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
            if (!(ack != null ? !ack.equals(continue$) : continue$ != null) && !c$1.isCanceled()) {
                package$.MODULE$.blocking((Function0 & Serializable)() -> {
                    this.reschedule$$anonfun$1$$anonfun$1(out$1, c$1, em$1, s$1);
                    return BoxedUnit.UNIT;
                });
            }
        } else if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            this.reportFailure(ex, (UncaughtExceptionReporter)s$1);
        } else {
            throw new MatchError((Object)try_);
        }
    }
}

