/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive;

import java.io.Serializable;
import monix.execution.Scheduler;
import monix.reactive.MulticastStrategy;
import monix.reactive.MulticastStrategy$Async$;
import monix.reactive.MulticastStrategy$Behavior$;
import monix.reactive.MulticastStrategy$Publish$;
import monix.reactive.MulticastStrategy$Replay$;
import monix.reactive.MulticastStrategy$ReplayLimited$;
import monix.reactive.Pipe;
import monix.reactive.subjects.AsyncSubject;
import monix.reactive.subjects.AsyncSubject$;
import monix.reactive.subjects.BehaviorSubject;
import monix.reactive.subjects.BehaviorSubject$;
import monix.reactive.subjects.PublishSubject;
import monix.reactive.subjects.PublishSubject$;
import monix.reactive.subjects.PublishToOneSubject;
import monix.reactive.subjects.PublishToOneSubject$;
import monix.reactive.subjects.ReplaySubject;
import monix.reactive.subjects.ReplaySubject$;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

public final class Pipe$
implements Serializable {
    public static final Pipe$ MODULE$ = new Pipe$();

    private Pipe$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Pipe$.class);
    }

    public <A> Pipe<A, A> apply(MulticastStrategy<A> strategy) {
        Pipe<A, A> pipe;
        MulticastStrategy<A> multicastStrategy = strategy;
        if (MulticastStrategy$Publish$.MODULE$.equals(multicastStrategy)) {
            pipe = this.publish();
        } else if (multicastStrategy instanceof MulticastStrategy.Behavior) {
            Object a;
            MulticastStrategy.Behavior behavior = MulticastStrategy$Behavior$.MODULE$.unapply((MulticastStrategy.Behavior)multicastStrategy);
            Object initial = a = behavior._1();
            pipe = this.behavior(initial);
        } else if (MulticastStrategy$Async$.MODULE$.equals(multicastStrategy)) {
            pipe = this.async();
        } else if (multicastStrategy instanceof MulticastStrategy.Replay) {
            Seq seq;
            MulticastStrategy.Replay replay = MulticastStrategy$Replay$.MODULE$.unapply((MulticastStrategy.Replay)multicastStrategy);
            Seq initial = seq = replay._1();
            pipe = this.replay(initial);
        } else if (multicastStrategy instanceof MulticastStrategy.ReplayLimited) {
            MulticastStrategy.ReplayLimited replayLimited = MulticastStrategy$ReplayLimited$.MODULE$.unapply((MulticastStrategy.ReplayLimited)multicastStrategy);
            int n = replayLimited._1();
            Seq seq = replayLimited._2();
            int capacity = n;
            Seq initial = seq;
            pipe = this.replayLimited(capacity, initial);
        } else {
            throw new MatchError(multicastStrategy);
        }
        return pipe;
    }

    public <A> Pipe<A, A> publish() {
        return new Pipe<A, A>(){

            public Tuple2 unicast() {
                PublishSubject<A> p = PublishSubject$.MODULE$.apply();
                return Tuple2$.MODULE$.apply(p, p);
            }

            public Tuple2 multicast(Scheduler s) {
                return this.unicast();
            }
        };
    }

    public <A> Pipe<A, A> publishToOne() {
        return new Pipe<A, A>(){

            public Tuple2 unicast() {
                PublishToOneSubject<A> p = PublishToOneSubject$.MODULE$.apply();
                return Tuple2$.MODULE$.apply(p, p);
            }
        };
    }

    public <A> Pipe<A, A> behavior(A initial) {
        return new Pipe<A, A>(initial){
            private final Object initial$1;
            {
                this.initial$1 = initial$4;
            }

            public Tuple2 unicast() {
                BehaviorSubject<Object> p = BehaviorSubject$.MODULE$.apply(this.initial$1);
                return Tuple2$.MODULE$.apply(p, p);
            }

            public Tuple2 multicast(Scheduler s) {
                return this.unicast();
            }
        };
    }

    public <A> Pipe<A, A> async() {
        return new Pipe<A, A>(){

            public Tuple2 unicast() {
                AsyncSubject<A> p = AsyncSubject$.MODULE$.apply();
                return Tuple2$.MODULE$.apply(p, p);
            }

            public Tuple2 multicast(Scheduler s) {
                return this.unicast();
            }
        };
    }

    public <A> Pipe<A, A> replay() {
        return this.replay((Seq)package$.MODULE$.Seq().empty());
    }

    public <A> Pipe<A, A> replay(Seq<A> initial) {
        return new Pipe<A, A>(initial){
            private final Seq initial$2;
            {
                this.initial$2 = initial$5;
            }

            public Tuple2 unicast() {
                ReplaySubject<A> p = ReplaySubject$.MODULE$.create(this.initial$2);
                return Tuple2$.MODULE$.apply(p, p);
            }

            public Tuple2 multicast(Scheduler s) {
                return this.unicast();
            }
        };
    }

    public <A> Pipe<A, A> replayLimited(int capacity) {
        return this.replayLimited(capacity, (Seq)package$.MODULE$.Seq().empty());
    }

    public <A> Pipe<A, A> replayLimited(int capacity, Seq<A> initial) {
        return new Pipe<A, A>(capacity, initial){
            private final int capacity$1;
            private final Seq initial$3;
            {
                this.capacity$1 = capacity$2;
                this.initial$3 = initial$6;
            }

            public Tuple2 unicast() {
                ReplaySubject<A> p = ReplaySubject$.MODULE$.createLimited(this.capacity$1, this.initial$3);
                return Tuple2$.MODULE$.apply(p, p);
            }

            public Tuple2 multicast(Scheduler s) {
                return this.unicast();
            }
        };
    }
}

