/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive;

import cats.Apply;
import cats.FlatMap;
import cats.NonEmptyParallel;
import cats.arrow.FunctionK;
import cats.effect.ExitCase;
import cats.effect.Resource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import monix.eval.Coeval;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.TaskLike;
import monix.eval.TaskLike$;
import monix.execution.Cancelable;
import monix.execution.ChannelType;
import monix.execution.Scheduler;
import monix.reactive.MulticastStrategy;
import monix.reactive.Observable;
import monix.reactive.Observable$DeprecatedExtensions$;
import monix.reactive.ObservableLike;
import monix.reactive.ObservableLike$;
import monix.reactive.Observer;
import monix.reactive.OverflowStrategy;
import monix.reactive.internal.builders.AsyncStateActionObservable;
import monix.reactive.internal.builders.BufferedIteratorAsObservable;
import monix.reactive.internal.builders.CharsReaderObservable;
import monix.reactive.internal.builders.CombineLatest2Observable;
import monix.reactive.internal.builders.CombineLatest3Observable;
import monix.reactive.internal.builders.CombineLatest4Observable;
import monix.reactive.internal.builders.CombineLatest5Observable;
import monix.reactive.internal.builders.CombineLatest6Observable;
import monix.reactive.internal.builders.CombineLatestListObservable;
import monix.reactive.internal.builders.ConsObservable;
import monix.reactive.internal.builders.CreateObservable;
import monix.reactive.internal.builders.DeferObservable;
import monix.reactive.internal.builders.EmptyObservable$;
import monix.reactive.internal.builders.ErrorObservable;
import monix.reactive.internal.builders.EvalAlwaysObservable;
import monix.reactive.internal.builders.EvalOnceObservable;
import monix.reactive.internal.builders.FirstStartedObservable;
import monix.reactive.internal.builders.FutureAsObservable;
import monix.reactive.internal.builders.InputStreamObservable;
import monix.reactive.internal.builders.Interleave2Observable;
import monix.reactive.internal.builders.IntervalFixedDelayObservable;
import monix.reactive.internal.builders.IntervalFixedRateObservable;
import monix.reactive.internal.builders.IterableAsObservable;
import monix.reactive.internal.builders.IteratorAsObservable;
import monix.reactive.internal.builders.LinesReaderObservable;
import monix.reactive.internal.builders.MergePrioritizedListObservable;
import monix.reactive.internal.builders.NeverObservable$;
import monix.reactive.internal.builders.NowObservable;
import monix.reactive.internal.builders.PaginateEvalObservable;
import monix.reactive.internal.builders.PaginateObservable;
import monix.reactive.internal.builders.RangeObservable;
import monix.reactive.internal.builders.ReactiveObservable;
import monix.reactive.internal.builders.RepeatEvalObservable;
import monix.reactive.internal.builders.RepeatObservable;
import monix.reactive.internal.builders.RepeatedValueObservable;
import monix.reactive.internal.builders.ResourceCaseObservable;
import monix.reactive.internal.builders.StateActionObservable;
import monix.reactive.internal.builders.TailRecMObservable;
import monix.reactive.internal.builders.TaskAsObservable;
import monix.reactive.internal.builders.UnfoldEvalObservable;
import monix.reactive.internal.builders.UnfoldObservable;
import monix.reactive.internal.builders.UnsafeCreateObservable;
import monix.reactive.internal.builders.Zip2Observable;
import monix.reactive.internal.builders.Zip3Observable;
import monix.reactive.internal.builders.Zip4Observable;
import monix.reactive.internal.builders.Zip5Observable;
import monix.reactive.internal.builders.Zip6Observable;
import monix.reactive.internal.deprecated.ObservableDeprecatedBuilders;
import monix.reactive.observables.CombineObservable$;
import monix.reactive.observers.Subscriber;
import monix.reactive.subjects.ConcurrentSubject;
import monix.reactive.subjects.ConcurrentSubject$;
import org.reactivestreams.Publisher;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.Tuple6;
import scala.Tuple6$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Observable$
implements ObservableDeprecatedBuilders,
Serializable {
    private static final Observable unit;
    private static final Observable.CatsInstances catsInstances;
    private static final NonEmptyParallel observableNonEmptyParallel;
    public static final Observable$DeprecatedExtensions$ DeprecatedExtensions;
    public static final Observable$ MODULE$;

    private Observable$() {
    }

    static {
        MODULE$ = new Observable$();
        unit = MODULE$.now(BoxedUnit.UNIT);
        catsInstances = new Observable.CatsInstances();
        observableNonEmptyParallel = new NonEmptyParallel<Observable>(){
            private final FunctionK sequential;
            private final FunctionK parallel;
            {
                this.sequential = new FunctionK<Object, Observable>(){

                    public Observable apply(Object fa) {
                        return (Observable)CombineObservable$.MODULE$.unwrap(fa);
                    }
                };
                this.parallel = new FunctionK<Observable, Object>(){

                    public Object apply(Observable fa) {
                        return CombineObservable$.MODULE$.apply(fa);
                    }
                };
            }

            public FlatMap flatMap() {
                return (FlatMap)Predef$.MODULE$.implicitly((Object)Observable$.MODULE$.catsInstances());
            }

            public Apply apply() {
                return CombineObservable$.MODULE$.combineObservableApplicative();
            }

            public FunctionK sequential() {
                return this.sequential;
            }

            public FunctionK parallel() {
                return this.parallel;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Observable$.class);
    }

    public <A> Observable<A> apply(Seq<A> elems) {
        return this.fromIterable((Iterable<A>)elems);
    }

    public <A> Observable<A> pure(A elem) {
        return new NowObservable<A>(elem);
    }

    public <A> Observable<A> delay(Function0<A> a) {
        return this.eval(a);
    }

    public <A> Observable<A> evalOnce(Function0<A> f) {
        return new EvalOnceObservable<A>(f);
    }

    public <A> Observable<A> now(A elem) {
        return new NowObservable<A>(elem);
    }

    public <A> Observable<A> raiseError(Throwable ex) {
        return new ErrorObservable(ex);
    }

    public <A> Observable<A> eval(Function0<A> a) {
        return new EvalAlwaysObservable<A>(a);
    }

    public <A> Observable<A> evalDelayed(FiniteDuration delay, Function0<A> a) {
        return this.eval(a).delayExecution(delay);
    }

    public <A> Observable<A> never() {
        return NeverObservable$.MODULE$;
    }

    public Observable<BoxedUnit> unit() {
        return unit;
    }

    public <A, B> Observable<B> tailRecM(A a, Function1<A, Observable<Either<A, B>>> f) {
        return new TailRecMObservable<A, B>(a, f);
    }

    public <A> Observable<A> unsafeCreate(Function1<Subscriber<A>, Cancelable> f) {
        return new UnsafeCreateObservable<A>(f);
    }

    public <A> Observable<A> create(OverflowStrategy.Synchronous<A> overflowStrategy, ChannelType.ProducerSide producerType, Function1<Subscriber.Sync<A>, Cancelable> f) {
        return new CreateObservable<A>(overflowStrategy, producerType, f);
    }

    public <A> ChannelType.ProducerSide create$default$2() {
        return ChannelType.MultiProducer$.MODULE$;
    }

    public <A> Tuple2<Observer.Sync<A>, Observable<A>> multicast(MulticastStrategy<A> multicast, Scheduler s) {
        ConcurrentSubject<A, A> ref = ConcurrentSubject$.MODULE$.apply(multicast, s);
        return Tuple2$.MODULE$.apply(ref, ref);
    }

    public <A> Tuple2<Observer.Sync<A>, Observable<A>> multicast(MulticastStrategy<A> multicast, OverflowStrategy.Synchronous<A> overflow, Scheduler s) {
        ConcurrentSubject<A, A> ref = ConcurrentSubject$.MODULE$.apply(multicast, overflow, s);
        return Tuple2$.MODULE$.apply(ref, ref);
    }

    public <F, A> Observable<A> from(Object fa, ObservableLike<F> F) {
        return F.apply(fa);
    }

    public <A> Observable<A> fromIterable(Iterable<A> iterable) {
        return new IterableAsObservable<A>(iterable);
    }

    public <A> Observable<A> fromIterator(Task<Iterator<A>> task) {
        return this.fromTask(task.map((Function1 & Serializable)iterator -> this.fromIteratorUnsafe((Iterator)iterator))).flatten($less$colon$less$.MODULE$.refl());
    }

    public <A> Observable<A> fromIterator(Resource<Task, Iterator<A>> resource) {
        return this.fromResource(resource, TaskLike$.MODULE$.fromTask()).flatMap((Function1 & Serializable)iterator -> this.fromIteratorUnsafe((Iterator)iterator));
    }

    public <F, A> Observable<A> fromIteratorF(Object iteratorF, TaskLike<F> F) {
        return this.fromIterator(F.apply(iteratorF));
    }

    public <A> Observable<A> fromIteratorUnsafe(Iterator<A> iterator) {
        return new IteratorAsObservable<A>(iterator);
    }

    public <A> Observable<Seq<A>> fromIteratorBuffered(Task<Iterator<A>> task, int bufferSize) {
        return this.fromTask(task.map((Function1 & Serializable)_$45 -> this.fromIteratorBufferedUnsafe((Iterator)_$45, bufferSize))).flatten($less$colon$less$.MODULE$.refl());
    }

    public <A> Observable<Seq<A>> fromIteratorBuffered(Resource<Task, Iterator<A>> resource, int bufferSize) {
        return this.fromResource(resource, TaskLike$.MODULE$.fromTask()).flatMap((Function1 & Serializable)_$46 -> this.fromIteratorBufferedUnsafe((Iterator)_$46, bufferSize));
    }

    public <A> Observable<Seq<A>> fromIteratorBufferedUnsafe(Iterator<A> iterator, int bufferSize) {
        return new BufferedIteratorAsObservable<A>(iterator, bufferSize);
    }

    public <F, A> Observable<A> fromResource(Resource<F, A> resource, TaskLike<F> F) {
        Observable observable;
        Resource<F, A> resource2 = resource;
        if (resource2 instanceof Resource.Allocate) {
            Resource.Allocate ra = (Resource.Allocate)resource2;
            observable = this.resourceCase(F.apply(ra.resource()), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                    throw new MatchError((Object)tuple22);
                }
                Function1 release = (Function1)tuple2._2();
                ExitCase exitCase = (ExitCase)tuple22._2();
                return F.apply(release.apply((Object)exitCase));
            }).map((Function1 & Serializable)_$48 -> _$48._1());
        } else if (resource2 instanceof Resource.Suspend) {
            Resource.Suspend ra = (Resource.Suspend)resource2;
            observable = this.from(ra.resource(), ObservableLike$.MODULE$.fromTaskLike(F)).flatMap((Function1 & Serializable)res -> this.fromResource((Resource)res, F));
        } else if (resource2 instanceof Resource.Bind) {
            Resource.Bind ra = (Resource.Bind)resource2;
            observable = this.fromResource(ra.source(), F).flatMap((Function1 & Serializable)s -> this.fromResource((Resource)ra.fs().apply(s), F));
        } else {
            throw new MatchError(resource2);
        }
        return observable;
    }

    public Observable<byte[]> fromInputStream(Task<InputStream> in, int chunkSize) {
        return this.resource(in, (Function1 & Serializable)h -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.fromInputStream$$anonfun$1$$anonfun$1((InputStream)h);
            return BoxedUnit.UNIT;
        })).flatMap((Function1 & Serializable)_$49 -> this.fromInputStreamUnsafe((InputStream)_$49, chunkSize)).executeAsync();
    }

    public int fromInputStream$default$2() {
        return 4096;
    }

    public <F> Observable<byte[]> fromInputStreamF(Object in, int chunkSize, TaskLike<F> F) {
        return this.fromInputStream((Task<InputStream>)F.apply(in), chunkSize);
    }

    public int fromInputStreamF$default$2() {
        return 4096;
    }

    public Observable<byte[]> fromInputStreamUnsafe(InputStream in, int chunkSize) {
        return new InputStreamObservable(in, chunkSize);
    }

    public int fromInputStreamUnsafe$default$2() {
        return 4096;
    }

    public Observable<char[]> fromCharsReader(Task<Reader> in, int chunkSize) {
        return this.resource(in, (Function1 & Serializable)h -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.fromCharsReader$$anonfun$1$$anonfun$1((Reader)h);
            return BoxedUnit.UNIT;
        })).flatMap((Function1 & Serializable)_$51 -> this.fromCharsReaderUnsafe((Reader)_$51, chunkSize)).executeAsync();
    }

    public int fromCharsReader$default$2() {
        return 4096;
    }

    public <F> Observable<char[]> fromCharsReaderF(Object in, int chunkSize, TaskLike<F> F) {
        return this.fromCharsReader((Task<Reader>)F.apply(in), chunkSize);
    }

    public int fromCharsReaderF$default$2() {
        return 4096;
    }

    public Observable<char[]> fromCharsReaderUnsafe(Reader in, int chunkSize) {
        return new CharsReaderObservable(in, chunkSize);
    }

    public int fromCharsReaderUnsafe$default$2() {
        return 4096;
    }

    public Observable<String> fromLinesReader(Task<BufferedReader> in2) {
        return this.resource(in2, (Function1 & Serializable)h -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.fromLinesReader$$anonfun$1$$anonfun$1((BufferedReader)h);
            return BoxedUnit.UNIT;
        })).flatMap((Function1 & Serializable)in -> this.fromLinesReaderUnsafe((BufferedReader)in)).executeAsync();
    }

    public <F> Observable<String> fromLinesReaderF(Object in, TaskLike<F> F) {
        return this.fromLinesReader((Task<BufferedReader>)F.apply(in));
    }

    public Observable<String> fromLinesReaderUnsafe(BufferedReader in) {
        return new LinesReaderObservable(in);
    }

    public <A> Observable<A> fromReactivePublisher(Publisher<A> publisher) {
        return new ReactiveObservable<A>(publisher, 0);
    }

    public <A> Observable<A> fromReactivePublisher(Publisher<A> publisher, int requestCount) {
        return new ReactiveObservable<A>(publisher, requestCount);
    }

    public <A> Observable<A> coeval(Coeval<A> value) {
        Observable<Object> observable;
        Coeval<A> coeval = value;
        if (coeval instanceof Coeval.Now) {
            Object object;
            Coeval.Now now = Coeval.Now$.MODULE$.unapply((Coeval.Now)coeval);
            Object a = object = now._1();
            observable = this.now(a);
        } else if (coeval instanceof Coeval.Error) {
            Throwable throwable;
            Coeval.Error error = Coeval.Error$.MODULE$.unapply((Coeval.Error)coeval);
            Throwable e = throwable = error._1();
            observable = this.raiseError(e);
        } else {
            Coeval<A> other = coeval;
            observable = this.eval(() -> this.coeval$$anonfun$1(other));
        }
        return observable;
    }

    public <A> Observable<A> fromTry(Try<A> a) {
        Observable<Object> observable;
        Try<A> try_ = a;
        if (try_ instanceof Success) {
            Object v = ((Success)try_).value();
            observable = this.now(v);
        } else if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            observable = this.raiseError(e);
        } else {
            throw new MatchError(try_);
        }
        return observable;
    }

    public <E extends Throwable, A> Observable<A> fromEither(Either<E, A> a) {
        Observable<Object> observable;
        Either<E, A> either = a;
        if (either instanceof Right) {
            Object v = ((Right)either).value();
            observable = this.now(v);
        } else if (either instanceof Left) {
            Throwable ex = (Throwable)((Left)either).value();
            observable = this.raiseError(ex);
        } else {
            throw new MatchError(either);
        }
        return observable;
    }

    public <E, A> Observable<A> fromEither(Function1<E, Throwable> f, Either<E, A> a) {
        Observable<Object> observable;
        Either<E, A> either = a;
        if (either instanceof Right) {
            Object v = ((Right)either).value();
            observable = this.now(v);
        } else if (either instanceof Left) {
            Object ex = ((Left)either).value();
            observable = this.raiseError((Throwable)f.apply(ex));
        } else {
            throw new MatchError(either);
        }
        return observable;
    }

    public <A> Observable<A> fromFuture(Function0<Future<A>> factory) {
        return new FutureAsObservable<A>(factory);
    }

    public <F, A> Observable<A> fromTaskLike(Object fa, TaskLike<F> F) {
        return this.fromTask(F.apply(fa));
    }

    public <A> Observable<A> fromTask(Task<A> task) {
        return new TaskAsObservable<A>(task);
    }

    public <F> FunctionK<F, Observable> liftFrom(ObservableLike<F> F) {
        return F;
    }

    public <A> Observable<A> suspend(Function0<Observable<A>> fa) {
        return this.defer(fa);
    }

    public <A> Observable<A> defer(Function0<Observable<A>> fa) {
        return new DeferObservable((Function0 & Serializable)() -> (Observable)fa.apply());
    }

    public <A> Observable<A> cons(A head, Observable<A> tail) {
        return new ConsObservable<A>(head, tail);
    }

    public <A> Observable<A> interleave2(Observable<A> oa1, Observable<A> oa2) {
        return new Interleave2Observable<A>(oa1, oa2);
    }

    public Observable<Object> intervalWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay) {
        return new IntervalFixedDelayObservable(initialDelay, delay);
    }

    public Observable<Object> interval(FiniteDuration delay) {
        return this.intervalWithFixedDelay(delay);
    }

    public Observable<Object> intervalWithFixedDelay(FiniteDuration delay) {
        return new IntervalFixedDelayObservable(Duration$.MODULE$.Zero(), delay);
    }

    public Observable<Object> intervalAtFixedRate(FiniteDuration period) {
        return new IntervalFixedRateObservable(Duration$.MODULE$.Zero(), period);
    }

    public Observable<Object> intervalAtFixedRate(FiniteDuration initialDelay, FiniteDuration period) {
        return new IntervalFixedRateObservable(initialDelay, period);
    }

    public <A> Observable<A> repeat(Seq<A> elems) {
        return new RepeatObservable<A>(elems);
    }

    public <A> Observable<A> repeatEval(Function0<A> task) {
        return new RepeatEvalObservable<A>(task);
    }

    public <F, A> Observable<A> repeatEvalF(Object fa, TaskLike<F> F) {
        return this.repeat((Seq<A>)ScalaRunTime$.MODULE$.wrapUnitArray(new BoxedUnit[]{BoxedUnit.UNIT})).mapEvalF((Function1 & Serializable)_$57 -> fa, F);
    }

    public Observable<Object> range(long from, long until, long step) {
        return new RangeObservable(from, until, step);
    }

    public long range$default$3() {
        return 1L;
    }

    public <S, A> Observable<A> fromStateAction(Function1<S, Tuple2<A, S>> f, Function0<S> seed) {
        return new StateActionObservable<S, A>(seed, f);
    }

    public <S, A> Observable<A> unfold(Function0<S> seed, Function1<S, Option<Tuple2<A, S>>> f) {
        return new UnfoldObservable<S, A>(seed, f);
    }

    public <S, A> Observable<A> unfoldEval(Function0<S> seed, Function1<S, Task<Option<Tuple2<A, S>>>> f) {
        return new UnfoldEvalObservable<Object, A>(seed.apply(), f);
    }

    public <S, A> Observable<A> paginate(Function0<S> seed, Function1<S, Tuple2<A, Option<S>>> f) {
        return new PaginateObservable<S, A>(seed, f);
    }

    public <S, A> Observable<A> paginateEval(Function0<S> seed, Function1<S, Task<Tuple2<A, Option<S>>>> f) {
        return new PaginateEvalObservable<Object, A>(seed.apply(), f);
    }

    public <F, S, A> Observable<A> unfoldEvalF(Function0<S> seed, Function1<S, Object> f, TaskLike<F> F) {
        return this.unfoldEval(seed, (Function1 & Serializable)a -> Task$.MODULE$.from(f.apply(a), F));
    }

    public <S, A> Observable<A> fromAsyncStateAction(Function1<S, Task<Tuple2<A, S>>> f, Function0<S> seed) {
        return new AsyncStateActionObservable<S, A>(seed, f);
    }

    public <F, S, A> Observable<A> fromAsyncStateActionF(Function1<S, Object> f, Function0<S> seed, TaskLike<F> F) {
        return this.fromAsyncStateAction((Function1 & Serializable)a -> Task$.MODULE$.from(f.apply(a), F), seed);
    }

    public <A> Publisher<A> toReactive(Observable<A> source, Scheduler s) {
        return source.toReactivePublisher(s);
    }

    public <A> Observable<A> timerRepeated(FiniteDuration initialDelay, FiniteDuration period, A unit) {
        return new RepeatedValueObservable<A>(initialDelay, period, unit);
    }

    public <A1, A2> Observable<Tuple2<A1, A2>> zip2(Observable<A1> oa1, Observable<A2> oa2) {
        return new Zip2Observable(oa1, oa2, (Function2 & Serializable)(a1, a2) -> Tuple2$.MODULE$.apply(a1, a2));
    }

    public <A1, A2, R> Observable<R> zipMap2(Observable<A1> oa1, Observable<A2> oa2, Function2<A1, A2, R> f) {
        return new Zip2Observable<A1, A2, R>(oa1, oa2, f);
    }

    public <A1, A2, A3> Observable<Tuple3<A1, A2, A3>> zip3(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3) {
        return new Zip3Observable(oa1, oa2, oa3, (Function3 & Serializable)(a1, a2, a3) -> Tuple3$.MODULE$.apply(a1, a2, a3));
    }

    public <A1, A2, A3, R> Observable<R> zipMap3(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Function3<A1, A2, A3, R> f) {
        return new Zip3Observable<A1, A2, A3, R>(oa1, oa2, oa3, f);
    }

    public <A1, A2, A3, A4> Observable<Tuple4<A1, A2, A3, A4>> zip4(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4) {
        return new Zip4Observable(oa1, oa2, oa3, oa4, (Function4 & Serializable)(a1, a2, a3, a4) -> Tuple4$.MODULE$.apply(a1, a2, a3, a4));
    }

    public <A1, A2, A3, A4, R> Observable<R> zipMap4(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Function4<A1, A2, A3, A4, R> f) {
        return new Zip4Observable<A1, A2, A3, A4, R>(oa1, oa2, oa3, oa4, f);
    }

    public <A1, A2, A3, A4, A5> Observable<Tuple5<A1, A2, A3, A4, A5>> zip5(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5) {
        return new Zip5Observable(oa1, oa2, oa3, oa4, oa5, (Function5 & Serializable)(a1, a2, a3, a4, a5) -> Tuple5$.MODULE$.apply(a1, a2, a3, a4, a5));
    }

    public <A1, A2, A3, A4, A5, R> Observable<R> zipMap5(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5, Function5<A1, A2, A3, A4, A5, R> f) {
        return new Zip5Observable<A1, A2, A3, A4, A5, R>(oa1, oa2, oa3, oa4, oa5, f);
    }

    public <A1, A2, A3, A4, A5, A6> Observable<Tuple6<A1, A2, A3, A4, A5, A6>> zip6(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5, Observable<A6> oa6) {
        return new Zip6Observable(oa1, oa2, oa3, oa4, oa5, oa6, (Function6 & Serializable)(a1, a2, a3, a4, a5, a6) -> Tuple6$.MODULE$.apply(a1, a2, a3, a4, a5, a6));
    }

    public <A1, A2, A3, A4, A5, A6, R> Observable<R> zipMap6(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5, Observable<A6> oa6, Function6<A1, A2, A3, A4, A5, A6, R> f) {
        return new Zip6Observable<A1, A2, A3, A4, A5, A6, R>(oa1, oa2, oa3, oa4, oa5, oa6, f);
    }

    public <A> Observable<Seq<A>> zipList(Seq<Observable<A>> sources) {
        Observable observable;
        if (sources.isEmpty()) {
            observable = this.empty();
        } else {
            Observable seed = ((Observable)sources.head()).map((Function1 & Serializable)t -> (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{t})));
            observable = (Observable)((IterableOnceOps)sources.tail()).foldLeft(seed, (Function2 & Serializable)(acc, obs) -> acc.zipMap(obs, (Function2 & Serializable)(seq, elem) -> (Vector)seq.$colon$plus(elem)));
        }
        return observable;
    }

    public <A> Observable<A> empty() {
        return EmptyObservable$.MODULE$;
    }

    public <A> Observable<A> resource(Task<A> acquire, Function1<A, Task<BoxedUnit>> release) {
        return this.resourceCase(acquire, (Function2 & Serializable)(a, _$60) -> (Task)release.apply(a));
    }

    public <F, A> Observable<A> resourceF(Object acquire, Function1<A, Object> release, TaskLike<F> F) {
        return this.resource(F.apply(acquire), (Function1 & Serializable)a -> F.apply(release.apply(a)));
    }

    public <A> Observable<A> resourceCase(Task<A> acquire, Function2<A, ExitCase<Throwable>, Task<BoxedUnit>> release) {
        return new ResourceCaseObservable<A>(acquire, release);
    }

    public <F, A> Observable<A> resourceCaseF(Object acquire, Function2<A, ExitCase<Throwable>, Object> release, TaskLike<F> F) {
        return this.resourceCase(F.apply(acquire), (Function2 & Serializable)(a, e) -> F.apply(release.apply(a, e)));
    }

    public <A1, A2> Observable<Tuple2<A1, A2>> combineLatest2(Observable<A1> oa1, Observable<A2> oa2) {
        return new CombineLatest2Observable(oa1, oa2, (Function2 & Serializable)(a1, a2) -> Tuple2$.MODULE$.apply(a1, a2));
    }

    public <A1, A2, R> Observable<R> combineLatestMap2(Observable<A1> oa1, Observable<A2> oa2, Function2<A1, A2, R> f) {
        return new CombineLatest2Observable<A1, A2, R>(oa1, oa2, f);
    }

    public <A1, A2, A3> Observable<Tuple3<A1, A2, A3>> combineLatest3(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3) {
        return new CombineLatest3Observable(oa1, oa2, oa3, (Function3 & Serializable)(a1, a2, a3) -> Tuple3$.MODULE$.apply(a1, a2, a3));
    }

    public <A1, A2, A3, R> Observable<R> combineLatestMap3(Observable<A1> a1, Observable<A2> a2, Observable<A3> a3, Function3<A1, A2, A3, R> f) {
        return new CombineLatest3Observable<A1, A2, A3, R>(a1, a2, a3, f);
    }

    public <A1, A2, A3, A4> Observable<Tuple4<A1, A2, A3, A4>> combineLatest4(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4) {
        return new CombineLatest4Observable(oa1, oa2, oa3, oa4, (Function4 & Serializable)(a1, a2, a3, a4) -> Tuple4$.MODULE$.apply(a1, a2, a3, a4));
    }

    public <A1, A2, A3, A4, R> Observable<R> combineLatestMap4(Observable<A1> a1, Observable<A2> a2, Observable<A3> a3, Observable<A4> a4, Function4<A1, A2, A3, A4, R> f) {
        return new CombineLatest4Observable<A1, A2, A3, A4, R>(a1, a2, a3, a4, f);
    }

    public <A1, A2, A3, A4, A5> Observable<Tuple5<A1, A2, A3, A4, A5>> combineLatest5(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5) {
        return new CombineLatest5Observable(oa1, oa2, oa3, oa4, oa5, (Function5 & Serializable)(a1, a2, a3, a4, a5) -> Tuple5$.MODULE$.apply(a1, a2, a3, a4, a5));
    }

    public <A1, A2, A3, A4, A5, R> Observable<R> combineLatestMap5(Observable<A1> a1, Observable<A2> a2, Observable<A3> a3, Observable<A4> a4, Observable<A5> a5, Function5<A1, A2, A3, A4, A5, R> f) {
        return new CombineLatest5Observable<A1, A2, A3, A4, A5, R>(a1, a2, a3, a4, a5, f);
    }

    public <A1, A2, A3, A4, A5, A6> Observable<Tuple6<A1, A2, A3, A4, A5, A6>> combineLatest6(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5, Observable<A6> oa6) {
        return new CombineLatest6Observable(oa1, oa2, oa3, oa4, oa5, oa6, (Function6 & Serializable)(a1, a2, a3, a4, a5, a6) -> Tuple6$.MODULE$.apply(a1, a2, a3, a4, a5, a6));
    }

    public <A1, A2, A3, A4, A5, A6, R> Observable<R> combineLatestMap6(Observable<A1> a1, Observable<A2> a2, Observable<A3> a3, Observable<A4> a4, Observable<A5> a5, Observable<A6> a6, Function6<A1, A2, A3, A4, A5, A6, R> f) {
        return new CombineLatest6Observable<A1, A2, A3, A4, A5, A6, R>(a1, a2, a3, a4, a5, a6, f);
    }

    public <A> Observable<Seq<A>> combineLatestList(Seq<Observable<A>> sources) {
        return sources.isEmpty() ? this.empty() : new CombineLatestListObservable<A>(sources);
    }

    public <A> Observable<A> mergePrioritizedList(Seq<Tuple2<Object, Observable<A>>> sources) {
        return sources.isEmpty() ? this.empty() : new MergePrioritizedListObservable<A>(sources);
    }

    public <A> Observable<A> firstStartedOf(Seq<Observable<A>> source) {
        return new FirstStartedObservable<A>(source);
    }

    public Observable.CatsInstances catsInstances() {
        return catsInstances;
    }

    public NonEmptyParallel observableNonEmptyParallel() {
        return observableNonEmptyParallel;
    }

    public final <A> Observable DeprecatedExtensions(Observable<A> self) {
        return self;
    }

    private final void fromInputStream$$anonfun$1$$anonfun$1(InputStream h$1) {
        h$1.close();
    }

    private final void fromCharsReader$$anonfun$1$$anonfun$1(Reader h$2) {
        h$2.close();
    }

    private final void fromLinesReader$$anonfun$1$$anonfun$1(BufferedReader h$3) {
        h$3.close();
    }

    private final Object coeval$$anonfun$1(Coeval other$1) {
        return other$1.value();
    }
}

