/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.schedulers;

import java.util.concurrent.TimeUnit;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.schedulers.ExecutionModel;
import monix.execution.schedulers.ReferenceScheduler;
import monix.execution.schedulers.Timer$;
import monix.execution.schedulers.TrampolineScheduler$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.scalajs.js.Dynamic;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0005%\u00111\u0003\u0016:b[B|G.\u001b8f'\u000eDW\rZ;mKJT!a\u0001\u0003\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u00148O\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0002\u000f\u0005)Qn\u001c8jq\u000e\u00011C\u0001\u0001\u000b!\tYA\"D\u0001\u0003\u0013\ti!A\u0001\nSK\u001a,'/\u001a8dKN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0002C\b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002\u0011I,\u0007o\u001c:uKJ\u0004\"!\u0005\n\u000e\u0003\u0011I!a\u0005\u0003\u00033Us7-Y;hQR,\u0005pY3qi&|gNU3q_J$XM\u001d\u0005\t+\u0001\u0011)\u0019!C!-\u0005qQ\r_3dkRLwN\\'pI\u0016dW#A\f\u0011\u0005-A\u0012BA\r\u0003\u00059)\u00050Z2vi&|g.T8eK2D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0010Kb,7-\u001e;j_:lu\u000eZ3mA!)Q\u0004\u0001C\u0005=\u00051A(\u001b8jiz\"2a\b\u0011\"!\tY\u0001\u0001C\u0003\u00109\u0001\u0007\u0001\u0003C\u0003\u00169\u0001\u0007q\u0003\u0003\u0004$\u0001\u0001\u0006I\u0001J\u0001\u000fS6lW\rZ5bi\u0016\fV/Z;f!\r)CFL\u0007\u0002M)\u0011q\u0005K\u0001\b[V$\u0018M\u00197f\u0015\tI#&\u0001\u0006d_2dWm\u0019;j_:T\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[\u0019\u0012Q!U;fk\u0016\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\t1\fgn\u001a\u0006\u0002g\u0005!!.\u0019<b\u0013\t)\u0004G\u0001\u0005Sk:t\u0017M\u00197f\u0011\u00199\u0004\u0001)Q\u0005q\u0005Qq/\u001b;iS:dun\u001c9\u0011\u0005eRT\"\u0001\u0016\n\u0005mR#a\u0002\"p_2,\u0017M\u001c\u0005\u0006{\u0001!\tEP\u0001\rg\u000eDW\rZ;mK>s7-\u001a\u000b\u0005\u007f\t;\u0015\u000b\u0005\u0002\u0012\u0001&\u0011\u0011\t\u0002\u0002\u000b\u0007\u0006t7-\u001a7bE2,\u0007\"B\"=\u0001\u0004!\u0015\u0001D5oSRL\u0017\r\u001c#fY\u0006L\bCA\u001dF\u0013\t1%F\u0001\u0003M_:<\u0007\"\u0002%=\u0001\u0004I\u0015\u0001B;oSR\u0004\"AS(\u000e\u0003-S!\u0001T'\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002Oe\u0005!Q\u000f^5m\u0013\t\u00016J\u0001\u0005US6,WK\\5u\u0011\u0015\u0011F\b1\u0001/\u0003\u0005\u0011\b\"\u0002+\u0001\t\u0003*\u0016aB3yK\u000e,H/\u001a\u000b\u0003-f\u0003\"!O,\n\u0005aS#\u0001B+oSRDQAW*A\u00029\n\u0001B];o]\u0006\u0014G.\u001a\u0005\u00079\u0002\u0001K\u0011B/\u0002\u001b%lW.\u001a3jCR,Gj\\8q)\u00051\u0006FA.`!\t\u00017-D\u0001b\u0015\t\u0011'&\u0001\u0006b]:|G/\u0019;j_:L!\u0001Z1\u0003\u000fQ\f\u0017\u000e\u001c:fG\")a\r\u0001C!O\u0006i!/\u001a9peR4\u0015-\u001b7ve\u0016$\"A\u00165\t\u000b%,\u0007\u0019\u00016\u0002\u0003Q\u0004\"a[:\u000f\u00051\fhBA7q\u001b\u0005q'BA8\t\u0003\u0019a$o\\8u}%\t1&\u0003\u0002sU\u00059\u0001/Y2lC\u001e,\u0017B\u0001;v\u0005%!\u0006N]8xC\ndWM\u0003\u0002sU\u001d)qO\u0001E\u0001q\u0006\u0019BK]1na>d\u0017N\\3TG\",G-\u001e7feB\u00111\"\u001f\u0004\u0006\u0003\tA\tA_\n\u0004snt\bCA\u001d}\u0013\ti(F\u0001\u0004B]f\u0014VM\u001a\t\u0003s}L1!!\u0001+\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0019i\u0012\u0010\"\u0001\u0002\u0006Q\t\u0001\u0010C\u0004\u0002\ne$\t!a\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b}\ti!a\u0004\t\r=\t9\u00011\u0001\u0011\u0011\u0019)\u0012q\u0001a\u0001/!I\u00111C=\u0002\u0002\u0013%\u0011QC\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0018A\u0019q&!\u0007\n\u0007\u0005m\u0001G\u0001\u0004PE*,7\r\u001e")
public final class TrampolineScheduler
extends ReferenceScheduler {
    private final UncaughtExceptionReporter reporter;
    private final ExecutionModel executionModel;
    private final Queue<Runnable> immediateQueue;
    private boolean withinLoop;

    public static TrampolineScheduler apply(UncaughtExceptionReporter uncaughtExceptionReporter, ExecutionModel executionModel) {
        return TrampolineScheduler$.MODULE$.apply(uncaughtExceptionReporter, executionModel);
    }

    @Override
    public ExecutionModel executionModel() {
        return this.executionModel;
    }

    @Override
    public Cancelable scheduleOnce(long initialDelay, TimeUnit unit, Runnable r) {
        long v = TimeUnit.MILLISECONDS.convert(initialDelay, unit);
        long millis = v < 0L ? 0L : v;
        Dynamic task = Timer$.MODULE$.setTimeout(millis, r, this.reporter);
        return Cancelable$.MODULE$.apply((Function0<BoxedUnit>)new Serializable(this, task){
            public static final long serialVersionUID = 0L;
            private final Dynamic task$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Timer$.MODULE$.clearTimeout(this.task$1);
            }
            {
                this.task$1 = task$1;
            }
        });
    }

    @Override
    public void execute(Runnable runnable) {
        this.immediateQueue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Runnable[]{runnable}));
        if (!this.withinLoop) {
            this.withinLoop = true;
            this.immediateLoop();
        }
        return;
        finally {
            this.withinLoop = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void immediateLoop() {
        while (this.immediateQueue.nonEmpty()) {
            Runnable task = (Runnable)this.immediateQueue.dequeue();
            try {
                task.run();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable ex = (Throwable)option.get();
                this.reportFailure(ex);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            break;
        }
        return;
    }

    @Override
    public void reportFailure(Throwable t) {
        this.reporter.reportFailure(t);
    }

    public TrampolineScheduler(UncaughtExceptionReporter reporter, ExecutionModel executionModel) {
        this.reporter = reporter;
        this.executionModel = executionModel;
        this.immediateQueue = (Queue)Queue$.MODULE$.empty();
        this.withinLoop = false;
    }
}

