/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.json.gson;

import com.google.gson.stream.JsonWriter;
import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomHandler;
import io.markdom.util.ObjectHelper;
import java.util.Optional;

public final class GsonJsonWriterMarkdomHandler
implements MarkdomHandler<Void> {
    private final JsonWriter writer;
    private final boolean includeSchema;

    public GsonJsonWriterMarkdomHandler(JsonWriter writer) {
        this(writer, false);
    }

    public GsonJsonWriterMarkdomHandler(JsonWriter writer, boolean includeSchema) {
        this.writer = (JsonWriter)ObjectHelper.notNull((String)"writer", (Object)writer);
        this.includeSchema = includeSchema;
    }

    public void onDocumentBegin() {
        this.writer.beginObject();
        if (this.includeSchema) {
            this.writer.name("$schema");
            this.writer.value("http://schema.markdom.io/markdom-1.0.json#");
        }
        this.writer.name("version");
        this.writer.value("1.0");
        this.writer.name("blocks");
        this.writer.beginArray();
    }

    public void onBlocksBegin() {
    }

    public void onBlockBegin(MarkdomBlockType type) {
        this.writer.beginObject();
        this.writer.name("type");
        this.writer.value(type.toName());
    }

    public void onCodeBlock(String code, Optional<String> hint) {
        this.writer.name("code");
        this.writer.value(code);
        if (hint.isPresent()) {
            this.writer.name("hint");
            this.writer.value(hint.get());
        }
    }

    public void onDivisionBlock() {
    }

    public void onCommentBlock(String comment) {
        this.writer.name("comment");
        this.writer.value(comment);
    }

    public void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.writer.name("level");
        this.writer.value((long)(level.ordinal() + 1));
    }

    public void onHeadingBlockEnd(MarkdomHeadingLevel level) {
    }

    public void onOrderedListBlockBegin(Integer startIndex) {
        this.writer.name("startIndex");
        this.writer.value((Number)startIndex);
        this.writer.name("items");
        this.writer.beginArray();
    }

    public void onOrderedListBlockEnd(Integer startIndex) {
        this.writer.endArray();
    }

    public void onParagraphBlockBegin() {
    }

    public void onParagraphBlockEnd() {
    }

    public void onQuoteBlockBegin() {
        this.writer.name("blocks");
        this.writer.beginArray();
    }

    public void onQuoteBlockEnd() {
        this.writer.endArray();
    }

    public void onUnorderedListBlockBegin() {
        this.writer.name("items");
        this.writer.beginArray();
    }

    public void onUnorderedListBlockEnd() {
        this.writer.endArray();
    }

    public void onBlockEnd(MarkdomBlockType type) {
        this.writer.endObject();
    }

    public void onNextBlock() {
    }

    public void onBlocksEnd() {
    }

    public void onListItemsBegin() {
    }

    public void onListItemBegin() {
        this.writer.beginObject();
        this.writer.name("blocks");
        this.writer.beginArray();
    }

    public void onListItemEnd() {
        this.writer.endArray();
        this.writer.endObject();
    }

    public void onNextListItem() {
    }

    public void onListItemsEnd() {
    }

    public void onContentsBegin() {
        this.writer.name("contents");
        this.writer.beginArray();
    }

    public void onContentBegin(MarkdomContentType type) {
        this.writer.beginObject();
        this.writer.name("type");
        this.writer.value(type.toName());
    }

    public void onCodeContent(String code) {
        this.writer.name("code");
        this.writer.value(code);
    }

    public void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.writer.name("level");
        this.writer.value((long)(level.ordinal() + 1));
    }

    public void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
    }

    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.writer.name("uri");
        this.writer.value(uri);
        if (title.isPresent()) {
            this.writer.name("title");
            this.writer.value(title.get());
        }
        if (alternative.isPresent()) {
            this.writer.name("alternative");
            this.writer.value(alternative.get());
        }
    }

    public void onLineBreakContent(Boolean hard) {
        this.writer.name("hard");
        this.writer.value(hard);
    }

    public void onLinkContentBegin(String uri, Optional<String> title) {
        this.writer.name("uri");
        this.writer.value(uri);
        if (title.isPresent()) {
            this.writer.name("title");
            this.writer.value(title.get());
        }
    }

    public void onLinkContentEnd(String uri, Optional<String> title) {
    }

    public void onTextContent(String text) {
        this.writer.name("text");
        this.writer.value(text);
    }

    public void onContentEnd(MarkdomContentType type) {
        this.writer.endObject();
    }

    public void onNextContent() {
    }

    public void onContentsEnd() {
        this.writer.endArray();
    }

    public void onDocumentEnd() {
        this.writer.endArray();
        this.writer.endObject();
        this.writer.flush();
    }

    public Void getResult() {
        return null;
    }
}

