/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.json.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.markdom.common.MarkdomException;
import io.markdom.handler.json.AbstractJsonObjectMarkdomDispatcher;
import io.markdom.util.ObjectHelper;
import java.util.Iterator;
import java.util.Optional;

public final class GsonJsonObjectMarkdomDispatcher
extends AbstractJsonObjectMarkdomDispatcher<JsonObject, JsonArray> {
    private final JsonObject object;

    public GsonJsonObjectMarkdomDispatcher(JsonObject object) {
        this.object = (JsonObject)ObjectHelper.notNull((String)"object", (Object)object);
    }

    protected JsonObject getRootObject() {
        return this.object;
    }

    protected Iterator<JsonObject> getObjects(final JsonArray jsonArray) {
        return new Iterator<JsonObject>(){
            final int length;
            int cursor;
            {
                this.length = jsonArray.size();
                this.cursor = 0;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.length;
            }

            @Override
            public JsonObject next() {
                JsonElement jsonNode;
                if (!((jsonNode = jsonArray.get(this.cursor++)) instanceof JsonObject)) {
                    throw new MarkdomException("Expected object node inside array");
                }
                return (JsonObject)jsonNode;
            }
        };
    }

    protected JsonArray optArray(JsonObject jsonObject, String key) {
        JsonElement element = jsonObject.get(key);
        if (null == element) {
            return new JsonArray();
        }
        return element.getAsJsonArray();
    }

    protected Optional<String> optString(JsonObject jsonObject, String key) {
        return Optional.ofNullable(jsonObject.get(key)).map(JsonElement::getAsString);
    }

    protected String reqString(JsonObject jsonObject, String key) {
        JsonElement element = jsonObject.get(key);
        if (null == element) {
            throw new MarkdomException("Expected text node for key " + key);
        }
        return element.getAsString();
    }

    protected Boolean reqBoolean(JsonObject jsonObject, String key) {
        JsonElement element = jsonObject.get(key);
        if (null == element) {
            throw new MarkdomException("Expected boolean node for key " + key);
        }
        return element.getAsBoolean();
    }

    protected Integer reqInteger(JsonObject jsonObject, String key) {
        JsonElement element = jsonObject.get(key);
        if (null == element) {
            throw new MarkdomException("Expected integer node for key " + key);
        }
        return element.getAsInt();
    }
}

