/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomHandler;
import io.markdom.util.ObjectHelper;
import java.util.Optional;
import java.util.Stack;

public final class SimpleMarkdomHandler<Result> {
    private final Stack<Boolean> firsts = new Stack();
    private final Stack<Object> parameters = new Stack();
    private final MarkdomHandler<Result> handler;

    public SimpleMarkdomHandler(MarkdomHandler<Result> handler) {
        this.handler = (MarkdomHandler)ObjectHelper.notNull((String)"handler", handler);
    }

    public void onDocumentBegin() {
        this.handler.onDocumentBegin();
        this.handler.onBlocksBegin();
        this.firsts.push(true);
    }

    public void onDocumentEnd() {
        this.firsts.pop();
        this.handler.onBlocksEnd();
        this.handler.onDocumentEnd();
    }

    public void onCodeBlock(String code, Optional<String> hint) {
        this.nextBlock();
        this.handler.onBlockBegin(MarkdomBlockType.CODE);
        this.handler.onCodeBlock(code, hint);
        this.handler.onBlockEnd(MarkdomBlockType.CODE);
    }

    public void onCommentBlock(String comment) {
        this.nextBlock();
        this.handler.onBlockBegin(MarkdomBlockType.COMMENT);
        this.handler.onCommentBlock(comment);
        this.handler.onBlockEnd(MarkdomBlockType.COMMENT);
    }

    public void onDivisionBlock() {
        this.nextBlock();
        this.handler.onBlockBegin(MarkdomBlockType.DIVISION);
        this.handler.onDivisionBlock();
        this.handler.onBlockEnd(MarkdomBlockType.DIVISION);
    }

    public void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.nextBlock();
        this.parameters.push((Object)level);
        this.handler.onBlockBegin(MarkdomBlockType.HEADING);
        this.handler.onHeadingBlockBegin(level);
        this.handler.onContentsBegin();
        this.firsts.push(true);
    }

    public void onHeadingBlockEnd() {
        this.firsts.pop();
        this.handler.onContentsEnd();
        this.handler.onHeadingBlockEnd((MarkdomHeadingLevel)((Object)this.parameters.pop()));
        this.handler.onBlockEnd(MarkdomBlockType.HEADING);
    }

    public void onOrderedListBlockBegin(Integer startIndex) {
        this.nextBlock();
        this.parameters.push(startIndex);
        this.handler.onBlockBegin(MarkdomBlockType.ORDERED_LIST);
        this.handler.onOrderedListBlockBegin(startIndex);
        this.handler.onListItemsBegin();
        this.firsts.push(true);
    }

    public void onOrderedListBlockEnd() {
        this.firsts.pop();
        this.handler.onListItemsEnd();
        this.handler.onOrderedListBlockEnd((Integer)this.parameters.pop());
        this.handler.onBlockEnd(MarkdomBlockType.ORDERED_LIST);
    }

    public void onParagraphBlockBegin() {
        this.nextBlock();
        this.handler.onBlockBegin(MarkdomBlockType.PARAGRAPH);
        this.handler.onParagraphBlockBegin();
        this.handler.onContentsBegin();
        this.firsts.push(true);
    }

    public void onParagraphBlockEnd() {
        this.firsts.pop();
        this.handler.onContentsEnd();
        this.handler.onParagraphBlockEnd();
        this.handler.onBlockEnd(MarkdomBlockType.PARAGRAPH);
    }

    public void onQuoteBlockBegin() {
        this.nextBlock();
        this.handler.onBlockBegin(MarkdomBlockType.QUOTE);
        this.handler.onQuoteBlockBegin();
        this.handler.onBlocksBegin();
        this.firsts.push(true);
    }

    public void onQuoteBlockEnd() {
        this.firsts.pop();
        this.handler.onBlocksEnd();
        this.handler.onQuoteBlockEnd();
        this.handler.onBlockEnd(MarkdomBlockType.QUOTE);
    }

    public void onUnorderedListBlockBegin() {
        this.nextBlock();
        this.handler.onBlockBegin(MarkdomBlockType.UNORDERED_LIST);
        this.handler.onUnorderedListBlockBegin();
        this.handler.onListItemsBegin();
        this.firsts.push(true);
    }

    public void onUnorderedListBlockEnd() {
        this.firsts.pop();
        this.handler.onListItemsEnd();
        this.handler.onUnorderedListBlockEnd();
        this.handler.onBlockEnd(MarkdomBlockType.UNORDERED_LIST);
    }

    public void onListItemBegin() {
        this.nextListItem();
        this.handler.onListItemBegin();
        this.handler.onBlocksBegin();
        this.firsts.push(true);
    }

    public void onListItemEnd() {
        this.firsts.pop();
        this.handler.onBlocksEnd();
        this.handler.onListItemEnd();
    }

    public void onCodeContent(String code) {
        this.nextContent();
        this.handler.onContentBegin(MarkdomContentType.CODE);
        this.handler.onCodeContent(code);
        this.handler.onContentEnd(MarkdomContentType.CODE);
    }

    public void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.nextContent();
        this.parameters.push((Object)level);
        this.handler.onContentBegin(MarkdomContentType.EMPHASIS);
        this.handler.onEmphasisContentBegin(level);
        this.handler.onContentsBegin();
        this.firsts.push(true);
    }

    public void onEmphasisContentEnd() {
        this.firsts.pop();
        this.handler.onContentsEnd();
        this.handler.onEmphasisContentEnd((MarkdomEmphasisLevel)((Object)this.parameters.pop()));
        this.handler.onContentEnd(MarkdomContentType.EMPHASIS);
    }

    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.nextContent();
        this.handler.onContentBegin(MarkdomContentType.IMAGE);
        this.handler.onImageContent(uri, title, alternative);
        this.handler.onContentEnd(MarkdomContentType.IMAGE);
    }

    public void onLineBreakContent(Boolean hard) {
        this.nextContent();
        this.handler.onContentBegin(MarkdomContentType.LINE_BREAK);
        this.handler.onLineBreakContent(hard);
        this.handler.onContentEnd(MarkdomContentType.LINE_BREAK);
    }

    public void onLinkContentBegin(String uri, Optional<String> title) {
        this.nextContent();
        this.parameters.push(title);
        this.parameters.push(uri);
        this.handler.onContentBegin(MarkdomContentType.LINK);
        this.handler.onLinkContentBegin(uri, title);
        this.handler.onContentsBegin();
        this.firsts.push(true);
    }

    public void onLinkContentEnd() {
        this.firsts.pop();
        this.handler.onContentsEnd();
        this.handler.onLinkContentEnd((String)this.parameters.pop(), (Optional)this.parameters.pop());
        this.handler.onContentEnd(MarkdomContentType.LINK);
    }

    public void onTextContent(String text) {
        this.nextContent();
        this.handler.onContentBegin(MarkdomContentType.TEXT);
        this.handler.onTextContent(text);
        this.handler.onContentEnd(MarkdomContentType.TEXT);
    }

    public Result getResult() {
        return this.handler.getResult();
    }

    private void nextBlock() {
        if (this.firsts.peek().booleanValue()) {
            this.firsts.pop();
            this.firsts.push(false);
        } else {
            this.handler.onNextBlock();
        }
    }

    private void nextListItem() {
        if (this.firsts.peek().booleanValue()) {
            this.firsts.pop();
            this.firsts.push(false);
        } else {
            this.handler.onNextListItem();
        }
    }

    private void nextContent() {
        if (this.firsts.peek().booleanValue()) {
            this.firsts.pop();
            this.firsts.push(false);
        } else {
            this.handler.onNextContent();
        }
    }
}

