/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomFilter;
import io.markdom.util.ObjectHelper;
import java.util.Optional;
import java.util.Set;

public class SimpleMarkdomFilter
implements MarkdomFilter {
    private final Set<MarkdomBlockType> blockTypes;
    private final Set<MarkdomContentType> contentTypes;

    public SimpleMarkdomFilter(Set<MarkdomBlockType> blockTypes, Set<MarkdomContentType> contentTypes) {
        this.blockTypes = (Set)ObjectHelper.notNull((String)"set of block types", blockTypes);
        this.contentTypes = (Set)ObjectHelper.notNull((String)"set of content types", contentTypes);
    }

    @Override
    public boolean testCodeBlock(String code, Optional<String> hint) {
        return this.blockTypes.contains((Object)MarkdomBlockType.CODE);
    }

    @Override
    public boolean testCommentBlock() {
        return this.blockTypes.contains((Object)MarkdomBlockType.COMMENT);
    }

    @Override
    public boolean testDivisionBlock() {
        return this.blockTypes.contains((Object)MarkdomBlockType.DIVISION);
    }

    @Override
    public boolean testHeadingBlock(MarkdomHeadingLevel level) {
        return this.blockTypes.contains((Object)MarkdomBlockType.HEADING);
    }

    @Override
    public boolean testOrderedListBlock(Integer startIndex) {
        return this.blockTypes.contains((Object)MarkdomBlockType.ORDERED_LIST);
    }

    @Override
    public boolean testParagraphBlock() {
        return this.blockTypes.contains((Object)MarkdomBlockType.PARAGRAPH);
    }

    @Override
    public boolean testQuoteBlock() {
        return this.blockTypes.contains((Object)MarkdomBlockType.QUOTE);
    }

    @Override
    public boolean testUnorderedListBlock() {
        return this.blockTypes.contains((Object)MarkdomBlockType.UNORDERED_LIST);
    }

    @Override
    public boolean testCodeContent(String code) {
        return this.contentTypes.contains((Object)MarkdomContentType.CODE);
    }

    @Override
    public boolean testEmphasisContent(MarkdomEmphasisLevel level) {
        return this.contentTypes.contains((Object)MarkdomContentType.EMPHASIS);
    }

    @Override
    public boolean testImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        return this.contentTypes.contains((Object)MarkdomContentType.IMAGE);
    }

    @Override
    public boolean testLineBreakContent(Boolean hard) {
        return this.contentTypes.contains((Object)MarkdomContentType.LINE_BREAK);
    }

    @Override
    public boolean testLinkContent(String uri, Optional<String> title) {
        return this.contentTypes.contains((Object)MarkdomContentType.LINK);
    }

    @Override
    public boolean testTextContent(String text) {
        return this.contentTypes.contains((Object)MarkdomContentType.TEXT);
    }
}

