/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomException;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomHandler;
import io.markdom.util.ObjectHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Stack;

public final class DebuggingMarkdomHandler<Result>
implements MarkdomHandler<Result> {
    private final MarkdomHandler<Result> handler;
    private final Stack<Context> contexts = new Stack();
    private final Stack<Parameter<?>> parameters = new Stack();
    private final EnumSet<Method> expectedMethods = EnumSet.noneOf(Method.class);

    public DebuggingMarkdomHandler(MarkdomHandler<Result> handler) {
        this.handler = (MarkdomHandler)ObjectHelper.notNull((String)"handler", handler);
        this.expectMethod(Method.ON_DOCUMENT_BEGIN);
    }

    @Override
    public void onDocumentBegin() {
        this.isExpectedMethod(Method.ON_DOCUMENT_BEGIN);
        this.contexts.push(Context.DOCUMENT);
        this.expectMethod(Method.ON_BLOCKS_BEGIN);
        this.handler.onDocumentBegin();
    }

    @Override
    public void onBlocksBegin() {
        this.isExpectedMethod(Method.ON_BLOCKS_BEGIN);
        this.expectMethod(Method.ON_BLOCK_BEGIN, Method.ON_BLOCKS_END);
        this.handler.onBlocksBegin();
    }

    @Override
    public void onBlockBegin(MarkdomBlockType type) {
        this.isExpectedMethod(Method.ON_BLOCK_BEGIN);
        this.checkParameter("block type", (Object)type, true);
        this.expectMethod(this.blockBeginCallback(type));
        this.handler.onBlockBegin(type);
    }

    private Method blockBeginCallback(MarkdomBlockType type) {
        switch (type) {
            case CODE: {
                return Method.ON_CODE_BLOCK;
            }
            case COMMENT: {
                return Method.ON_COMMENT_BLOCK;
            }
            case DIVISION: {
                return Method.ON_DIVISION_BLOCK;
            }
            case HEADING: {
                return Method.ON_HEADING_BLOCK_BEGIN;
            }
            case ORDERED_LIST: {
                return Method.ON_ORDERED_LIST_BLOCK_BEGIN;
            }
            case PARAGRAPH: {
                return Method.ON_PARAGRAPH_BLOCK_BEGIN;
            }
            case QUOTE: {
                return Method.ON_QUOTE_BLOCK_BEGIN;
            }
            case UNORDERED_LIST: {
                return Method.ON_UNORDERED_LIST_BLOCK_BEGIN;
            }
        }
        throw new InternalError("Unexpected block type: " + (Object)((Object)type));
    }

    @Override
    public void onBlockEnd(MarkdomBlockType type) {
        this.isExpectedMethod(Method.ON_BLOCK_END);
        this.checkAndCompareParameter("block type", (Object)type);
        this.expectMethod(Method.ON_NEXT_BLOCK, Method.ON_BLOCKS_END);
        this.handler.onBlockEnd(type);
    }

    @Override
    public void onNextBlock() {
        this.isExpectedMethod(Method.ON_NEXT_BLOCK);
        this.expectMethod(Method.ON_BLOCK_BEGIN);
        this.handler.onNextBlock();
    }

    @Override
    public void onBlocksEnd() {
        this.isExpectedMethod(Method.ON_BLOCKS_END);
        this.expectMethod(this.blocksEndCallback(this.contexts.peek()));
        this.handler.onBlocksEnd();
    }

    private Method blocksEndCallback(Context context) {
        switch (context) {
            case DOCUMENT: {
                return Method.ON_DOCUMENT_END;
            }
            case LIST_ITEM: {
                return Method.ON_LIST_ITEM_END;
            }
            case QUOTE_BLOCK: {
                return Method.ON_QUOTE_BLOCK_END;
            }
        }
        throw new InternalError("Unexpected blocks end context: " + (Object)((Object)context));
    }

    @Override
    public void onCodeBlock(String code, Optional<String> hint) {
        this.isExpectedMethod(Method.ON_CODE_BLOCK);
        this.checkParameter("code", code, false);
        this.checkParameter("optional hint", hint, false);
        this.validateNoLineBreak(hint, "hint");
        this.expectMethod(Method.ON_BLOCK_END);
        this.handler.onCodeBlock(code, hint);
    }

    @Override
    public void onCommentBlock(String comment) {
        this.isExpectedMethod(Method.ON_COMMENT_BLOCK);
        this.checkParameter("comment", comment, false);
        this.expectMethod(Method.ON_BLOCK_END);
        this.handler.onCommentBlock(comment);
    }

    @Override
    public void onDivisionBlock() {
        this.isExpectedMethod(Method.ON_DIVISION_BLOCK);
        this.expectMethod(Method.ON_BLOCK_END);
        this.handler.onDivisionBlock();
    }

    @Override
    public void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.isExpectedMethod(Method.ON_HEADING_BLOCK_BEGIN);
        this.checkParameter("heading level", (Object)level, true);
        this.contexts.push(Context.HEADING_BLOCK);
        this.expectMethod(Method.ON_CONTENTS_BEGIN);
        this.handler.onHeadingBlockBegin(level);
    }

    @Override
    public void onHeadingBlockEnd(MarkdomHeadingLevel level) {
        this.isExpectedMethod(Method.ON_HEADING_BLOCK_END);
        this.checkAndCompareParameter("heading level", (Object)level);
        this.contexts.pop();
        this.expectMethod(Method.ON_BLOCK_END);
        this.handler.onHeadingBlockEnd(level);
    }

    @Override
    public void onOrderedListBlockBegin(Integer startIndex) {
        this.isExpectedMethod(Method.ON_ORDERED_LIST_BLOCK_BEGIN);
        this.checkParameter("start index", startIndex, true);
        this.validateNotNegative(startIndex);
        this.contexts.push(Context.ORDERED_LIST);
        this.expectMethod(Method.ON_LIST_ITEMS_BEGIN);
        this.handler.onOrderedListBlockBegin(startIndex);
    }

    @Override
    public void onOrderedListBlockEnd(Integer startIndex) {
        this.isExpectedMethod(Method.ON_ORDERED_LIST_BLOCK_END);
        this.checkAndCompareParameter("start index", startIndex);
        this.contexts.pop();
        this.expectMethod(Method.ON_BLOCK_END);
        this.handler.onOrderedListBlockEnd(startIndex);
    }

    @Override
    public void onParagraphBlockBegin() {
        this.isExpectedMethod(Method.ON_PARAGRAPH_BLOCK_BEGIN);
        this.contexts.push(Context.PARAGRAPH_BLOCK);
        this.expectMethod(Method.ON_CONTENTS_BEGIN);
        this.handler.onParagraphBlockBegin();
    }

    @Override
    public void onParagraphBlockEnd() {
        this.isExpectedMethod(Method.ON_PARAGRAPH_BLOCK_END);
        this.contexts.pop();
        this.expectMethod(Method.ON_BLOCK_END);
        this.handler.onParagraphBlockEnd();
    }

    @Override
    public void onQuoteBlockBegin() {
        this.isExpectedMethod(Method.ON_QUOTE_BLOCK_BEGIN);
        this.contexts.push(Context.QUOTE_BLOCK);
        this.expectMethod(Method.ON_BLOCKS_BEGIN);
        this.handler.onQuoteBlockBegin();
    }

    @Override
    public void onQuoteBlockEnd() {
        this.isExpectedMethod(Method.ON_QUOTE_BLOCK_END);
        this.contexts.pop();
        this.expectMethod(Method.ON_BLOCK_END);
        this.handler.onQuoteBlockEnd();
    }

    @Override
    public void onUnorderedListBlockBegin() {
        this.isExpectedMethod(Method.ON_UNORDERED_LIST_BLOCK_BEGIN);
        this.contexts.push(Context.UNORDERED_LIST);
        this.expectMethod(Method.ON_LIST_ITEMS_BEGIN);
        this.handler.onUnorderedListBlockBegin();
    }

    @Override
    public void onUnorderedListBlockEnd() {
        this.isExpectedMethod(Method.ON_UNORDERED_LIST_BLOCK_END);
        this.contexts.pop();
        this.expectMethod(Method.ON_BLOCK_END);
        this.handler.onUnorderedListBlockEnd();
    }

    @Override
    public void onListItemsBegin() {
        this.isExpectedMethod(Method.ON_LIST_ITEMS_BEGIN);
        this.expectMethod(Method.ON_LIST_ITEM_BEGIN, Method.ON_LIST_ITEMS_END);
        this.handler.onListItemsBegin();
    }

    @Override
    public void onListItemBegin() {
        this.isExpectedMethod(Method.ON_LIST_ITEM_BEGIN);
        this.contexts.push(Context.LIST_ITEM);
        this.expectMethod(Method.ON_BLOCKS_BEGIN);
        this.handler.onListItemBegin();
    }

    @Override
    public void onListItemEnd() {
        this.isExpectedMethod(Method.ON_LIST_ITEM_END);
        this.contexts.pop();
        this.expectMethod(Method.ON_NEXT_LIST_ITEM, Method.ON_LIST_ITEMS_END);
        this.handler.onListItemEnd();
    }

    @Override
    public void onNextListItem() {
        this.isExpectedMethod(Method.ON_NEXT_LIST_ITEM);
        this.expectMethod(Method.ON_LIST_ITEM_BEGIN);
        this.handler.onNextListItem();
    }

    @Override
    public void onListItemsEnd() {
        this.isExpectedMethod(Method.ON_LIST_ITEMS_END);
        this.expectMethod(this.listItemEndCallback(this.contexts.peek()));
        this.handler.onListItemsEnd();
    }

    private Method listItemEndCallback(Context context) {
        switch (context) {
            case ORDERED_LIST: {
                return Method.ON_ORDERED_LIST_BLOCK_END;
            }
            case UNORDERED_LIST: {
                return Method.ON_UNORDERED_LIST_BLOCK_END;
            }
        }
        throw new InternalError("Unexpected imtem end context: " + (Object)((Object)context));
    }

    @Override
    public void onContentsBegin() {
        this.isExpectedMethod(Method.ON_CONTENTS_BEGIN);
        this.expectMethod(Method.ON_CONTENT_BEGIN, Method.ON_CONTENTS_END);
        this.handler.onContentsBegin();
    }

    @Override
    public void onContentBegin(MarkdomContentType type) {
        this.isExpectedMethod(Method.ON_CONTENT_BEGIN);
        this.checkParameter("content type", (Object)type, true);
        this.expectMethod(this.contentBeginCallback(type));
        this.handler.onContentBegin(type);
    }

    private Method contentBeginCallback(MarkdomContentType type) {
        switch (type) {
            case CODE: {
                return Method.ON_CODE_CONTENT;
            }
            case EMPHASIS: {
                return Method.ON_EMPHASIS_CONTENT_BEGIN;
            }
            case IMAGE: {
                return Method.ON_IMAGE_CONTENT;
            }
            case LINE_BREAK: {
                return Method.ON_LINE_BREAK_CONTENT;
            }
            case LINK: {
                return Method.ON_LINK_CONTENT_BEGIN;
            }
            case TEXT: {
                return Method.ON_TEXT_CONTENT;
            }
        }
        throw new InternalError("Unexpected content type: " + (Object)((Object)type));
    }

    @Override
    public void onContentEnd(MarkdomContentType type) {
        this.isExpectedMethod(Method.ON_CONTENT_END);
        this.checkAndCompareParameter("content type", (Object)type);
        this.expectMethod(Method.ON_NEXT_CONTENT, Method.ON_CONTENTS_END);
        this.handler.onContentEnd(type);
    }

    @Override
    public void onNextContent() {
        this.isExpectedMethod(Method.ON_NEXT_CONTENT);
        this.expectMethod(Method.ON_CONTENT_BEGIN);
        this.handler.onNextContent();
    }

    @Override
    public void onContentsEnd() {
        this.isExpectedMethod(Method.ON_CONTENTS_END);
        this.expectMethod(this.contentsEndCallback(this.contexts.peek()));
        this.handler.onContentsEnd();
    }

    private Method contentsEndCallback(Context context) {
        switch (context) {
            case HEADING_BLOCK: {
                return Method.ON_HEADING_BLOCK_END;
            }
            case PARAGRAPH_BLOCK: {
                return Method.ON_PARAGRAPH_BLOCK_END;
            }
            case EMPHASIS_CONTENT: {
                return Method.ON_EMPHASIS_CONTENT_END;
            }
            case LINK_CONTENT: {
                return Method.ON_LINK_CONTENT_END;
            }
        }
        throw new InternalError("Unexpected contents end context: " + (Object)((Object)context));
    }

    @Override
    public void onCodeContent(String code) {
        this.isExpectedMethod(Method.ON_CODE_CONTENT);
        this.checkParameter("code", code, false);
        this.validateNoLineBreak(code, "code");
        this.expectMethod(Method.ON_CONTENT_END);
        this.handler.onCodeContent(code);
    }

    @Override
    public void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.isExpectedMethod(Method.ON_EMPHASIS_CONTENT_BEGIN);
        this.checkParameter("emphasis level", (Object)level, true);
        this.contexts.push(Context.EMPHASIS_CONTENT);
        this.expectMethod(Method.ON_CONTENTS_BEGIN);
        this.handler.onEmphasisContentBegin(level);
    }

    @Override
    public void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
        this.isExpectedMethod(Method.ON_EMPHASIS_CONTENT_END);
        this.checkAndCompareParameter("emphasis level", (Object)level);
        this.contexts.pop();
        this.expectMethod(Method.ON_CONTENT_END);
        this.handler.onEmphasisContentEnd(level);
    }

    @Override
    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.isExpectedMethod(Method.ON_IMAGE_CONTENT);
        this.checkParameter("uri", uri, false);
        this.checkParameter("optional title", title, false);
        this.checkParameter("optional alternative", title, false);
        this.validateValidUri(uri);
        this.validateNoLineBreak(title, "title");
        this.validateNoLineBreak(alternative, "alternative");
        this.expectMethod(Method.ON_CONTENT_END);
        this.handler.onImageContent(uri, title, alternative);
    }

    @Override
    public void onLineBreakContent(Boolean hard) {
        this.isExpectedMethod(Method.ON_LINE_BREAK_CONTENT);
        this.checkParameter("hard", hard, false);
        this.checkLineBreakContext();
        this.expectMethod(Method.ON_CONTENT_END);
        this.handler.onLineBreakContent(hard);
    }

    @Override
    public void onLinkContentBegin(String uri, Optional<String> title) {
        this.isExpectedMethod(Method.ON_LINK_CONTENT_BEGIN);
        this.checkParameter("uri", uri, true);
        this.checkParameter("optional title", title, true);
        this.validateValidUri(uri);
        this.validateNoLineBreak(title, "title");
        this.checkLinkContentContext();
        this.contexts.push(Context.LINK_CONTENT);
        this.expectMethod(Method.ON_CONTENTS_BEGIN);
        this.handler.onLinkContentBegin(uri, title);
    }

    @Override
    public void onLinkContentEnd(String uri, Optional<String> title) {
        this.isExpectedMethod(Method.ON_LINK_CONTENT_END);
        this.checkAndCompareParameter("optional title", title);
        this.checkAndCompareParameter("uri", uri);
        this.contexts.pop();
        this.expectMethod(Method.ON_CONTENT_END);
        this.handler.onLinkContentEnd(uri, title);
    }

    @Override
    public void onTextContent(String text) {
        this.isExpectedMethod(Method.ON_TEXT_CONTENT);
        this.checkParameter("text", text, false);
        this.validateNoLineBreak(text, "text");
        this.expectMethod(Method.ON_CONTENT_END);
        this.handler.onTextContent(text);
    }

    @Override
    public void onDocumentEnd() {
        this.isExpectedMethod(Method.ON_DOCUMENT_END);
        this.expectMethod(Method.ON_RESULT);
        this.handler.onDocumentEnd();
    }

    @Override
    public Result getResult() {
        this.expectMethod(Method.ON_RESULT);
        return this.handler.getResult();
    }

    private void expectMethod(Method ... methods) {
        this.expectedMethods.clear();
        for (Method method : methods) {
            this.expectedMethods.add(method);
        }
    }

    private void isExpectedMethod(Method callback) {
        if (!this.expectedMethods.contains((Object)callback)) {
            throw new MarkdomException("The invoked method is none of " + this.expectedMethods + " in context " + this.parameters + ": " + (Object)((Object)callback));
        }
    }

    private void checkParameter(String name, Object value, boolean compareLater) {
        if (null == value) {
            throw new MarkdomException("The given " + name + " is null");
        }
        if (compareLater) {
            this.parameters.push(new Parameter<Object>(value));
        }
    }

    private void checkAndCompareParameter(String name, Object value) {
        if (null == value) {
            throw new MarkdomException("The given " + name + " is null");
        }
        Parameter<?> parameter = this.parameters.pop();
        if (!value.equals(((Parameter)parameter).payload)) {
            throw new MarkdomException("The given " + name + " is not " + ((Parameter)parameter).payload + ": " + value);
        }
    }

    private void validateNotNegative(Integer startIndex) {
        if (startIndex < 0) {
            throw new MarkdomException("The given start index is negative: " + startIndex);
        }
    }

    private void validateNoLineBreak(Optional<String> string, String name) {
        if (string.isPresent()) {
            this.validateNoLineBreak(string.get(), name);
        }
    }

    private void validateNoLineBreak(String string, String name) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if ('\n' != string.charAt(i)) continue;
            throw new MarkdomException("The given " + name + " contains a line break at index " + i + ": " + string);
        }
    }

    private void validateValidUri(String uri) {
        try {
            new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new MarkdomException("The given uri is invalid: " + uri, e);
        }
    }

    private void checkLineBreakContext() {
        if (this.contexts.contains((Object)Context.HEADING_BLOCK)) {
            throw new MarkdomException("A line break appeared inside a heading block");
        }
    }

    private void checkLinkContentContext() {
        if (this.contexts.contains((Object)Context.LINK_CONTENT)) {
            throw new MarkdomException("A link content appeared inside of another link content");
        }
    }

    private static class Parameter<Payload> {
        private final Payload payload;

        public Parameter(Payload payload) {
            this.payload = payload;
        }

        public Payload getPayload() {
            return this.payload;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Payload this$payload = this.getPayload();
            Payload other$payload = other.getPayload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Payload $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        public String toString() {
            return "DebuggingMarkdomHandler.Parameter(payload=" + this.getPayload() + ")";
        }
    }

    private static enum Method {
        ON_DOCUMENT_BEGIN,
        ON_DOCUMENT_END,
        ON_BLOCKS_BEGIN,
        ON_BLOCK_BEGIN,
        ON_BLOCK_END,
        ON_NEXT_BLOCK,
        ON_BLOCKS_END,
        ON_CODE_BLOCK,
        ON_COMMENT_BLOCK,
        ON_DIVISION_BLOCK,
        ON_HEADING_BLOCK_BEGIN,
        ON_HEADING_BLOCK_END,
        ON_ORDERED_LIST_BLOCK_BEGIN,
        ON_ORDERED_LIST_BLOCK_END,
        ON_PARAGRAPH_BLOCK_BEGIN,
        ON_PARAGRAPH_BLOCK_END,
        ON_QUOTE_BLOCK_BEGIN,
        ON_QUOTE_BLOCK_END,
        ON_UNORDERED_LIST_BLOCK_BEGIN,
        ON_UNORDERED_LIST_BLOCK_END,
        ON_LIST_ITEMS_BEGIN,
        ON_LIST_ITEM_BEGIN,
        ON_LIST_ITEM_END,
        ON_NEXT_LIST_ITEM,
        ON_LIST_ITEMS_END,
        ON_CONTENTS_BEGIN,
        ON_CONTENT_BEGIN,
        ON_CONTENT_END,
        ON_NEXT_CONTENT,
        ON_CONTENTS_END,
        ON_CODE_CONTENT,
        ON_EMPHASIS_CONTENT_BEGIN,
        ON_EMPHASIS_CONTENT_END,
        ON_IMAGE_CONTENT,
        ON_LINE_BREAK_CONTENT,
        ON_LINK_CONTENT_BEGIN,
        ON_LINK_CONTENT_END,
        ON_TEXT_CONTENT,
        ON_RESULT;

    }

    private static enum Context {
        DOCUMENT,
        HEADING_BLOCK,
        PARAGRAPH_BLOCK,
        QUOTE_BLOCK,
        LIST_ITEM,
        ORDERED_LIST,
        UNORDERED_LIST,
        EMPHASIS_CONTENT,
        LINK_CONTENT;

    }
}

